/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.api.machine.IMultiController;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.RecipeCondition;
import com.lowdragmc.mbd2.api.recipe.RecipeLogic;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;

public class BlockCondition
extends RecipeCondition {
    public static final BlockCondition INSTANCE = new BlockCondition();
    @Configurable(name="config.recipe.condition.block.min")
    @NumberRange(range={0.0, 2.147483647E9})
    private int minCount;
    @Configurable(name="config.recipe.condition.block.max")
    @NumberRange(range={0.0, 2.147483647E9})
    private int maxCount;
    @Configurable(name="config.recipe.condition.block.blocks", collapse=false)
    private Block[] blocks;

    public BlockCondition() {
        this(0, 0, new Block[0]);
    }

    public BlockCondition(int minLevel, int maxLevel, Block ... blocks) {
        this.minCount = minLevel;
        this.maxCount = maxLevel;
        this.blocks = blocks;
    }

    @Override
    public String getType() {
        return "block";
    }

    @Override
    public Component getTooltips() {
        MutableComponent blockNames = Component.m_237119_();
        for (int i = 0; i < this.blocks.length; ++i) {
            blockNames.m_7220_((Component)this.blocks[i].m_49954_());
            if (i >= this.blocks.length - 1) continue;
            blockNames.m_7220_((Component)Component.m_237113_((String)" || "));
        }
        return Component.m_237110_((String)"recipe.condition.block.tooltip", (Object[])new Object[]{blockNames, this.minCount, this.maxCount});
    }

    @Override
    public boolean test(@Nonnull MBDRecipe recipe, @Nonnull RecipeLogic recipeLogic) {
        int amount = 0;
        IMachine iMachine = recipeLogic.machine;
        if (iMachine instanceof IMultiController) {
            IMultiController controller = (IMultiController)iMachine;
            Level level = controller.getLevel();
            for (BlockPos pos : controller.getMultiblockState().getCache()) {
                if (!ArrayUtils.contains((Object[])this.blocks, (Object)level.m_8055_(pos).m_60734_())) continue;
                ++amount;
            }
        }
        return amount >= this.minCount && amount <= this.maxCount;
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        JsonObject config = super.serialize();
        config.addProperty("minCount", (Number)this.minCount);
        config.addProperty("maxCount", (Number)this.maxCount);
        JsonArray array = new JsonArray();
        for (Block block : this.blocks) {
            ResourceLocation key = ForgeRegistries.BLOCKS.getKey((Object)block);
            if (key == null) continue;
            array.add(key.toString());
        }
        config.add("blocks", (JsonElement)array);
        return config;
    }

    @Override
    public RecipeCondition deserialize(@Nonnull JsonObject config) {
        super.deserialize(config);
        this.minCount = GsonHelper.m_13824_((JsonObject)config, (String)"minCount", (int)0);
        this.maxCount = GsonHelper.m_13824_((JsonObject)config, (String)"maxCount", (int)0);
        JsonArray array = GsonHelper.m_13832_((JsonObject)config, (String)"blocks", (JsonArray)new JsonArray());
        this.blocks = new Block[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            String key = array.get(i).getAsString();
            this.blocks[i] = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(key));
            if (this.blocks[i] != null) continue;
            this.blocks[i] = Blocks.f_50016_;
        }
        return this;
    }

    @Override
    public RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        super.fromNetwork(buf);
        this.minCount = buf.m_130242_();
        this.maxCount = buf.m_130242_();
        int size = buf.m_130242_();
        this.blocks = new Block[size];
        for (int i = 0; i < size; ++i) {
            this.blocks[i] = (Block)ForgeRegistries.BLOCKS.getValue(buf.m_130281_());
        }
        return this;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        super.toNetwork(buf);
        buf.m_130130_(this.minCount);
        buf.m_130130_(this.maxCount);
        buf.m_130130_(this.blocks.length);
        for (Block block : this.blocks) {
            buf.m_130085_(Optional.ofNullable(ForgeRegistries.BLOCKS.getKey((Object)block)).orElse(new ResourceLocation("minecraft:air")));
        }
    }

    @Override
    public CompoundTag toNBT() {
        CompoundTag tag = super.toNBT();
        tag.m_128405_("minCount", this.minCount);
        tag.m_128405_("maxCount", this.maxCount);
        ListTag array = new ListTag();
        for (Block block : this.blocks) {
            ResourceLocation key = ForgeRegistries.BLOCKS.getKey((Object)block);
            if (key == null) continue;
            array.add((Object)StringTag.m_129297_((String)key.toString()));
        }
        tag.m_128365_("blocks", (Tag)array);
        return tag;
    }

    @Override
    public RecipeCondition fromNBT(CompoundTag tag) {
        super.fromNBT(tag);
        this.minCount = tag.m_128451_("minCount");
        this.maxCount = tag.m_128451_("maxCount");
        ListTag array = tag.m_128437_("blocks", 8);
        this.blocks = new Block[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            String key = array.m_128778_(i);
            this.blocks[i] = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(key));
            if (this.blocks[i] != null) continue;
            this.blocks[i] = Blocks.f_50016_;
        }
        return this;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public Block[] getBlocks() {
        return this.blocks;
    }

    public void setMinCount(int minCount) {
        this.minCount = minCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public void setBlocks(Block[] blocks) {
        this.blocks = blocks;
    }
}

