/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.machine.definition.config;

import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import com.lowdragmc.mbd2.common.machine.definition.config.MachineState;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.shapes.Shapes;

public class StateMachine<T extends MachineState>
implements ITagSerializable<CompoundTag> {
    protected final T rootState;
    protected final Map<String, T> states = new HashMap<String, T>();

    public StateMachine(T rootState) {
        this.rootState = rootState;
        this.initStateMachine();
    }

    public static <T extends MachineState> T createSingleDefault(Supplier<MachineState.Builder<T>> builderCreator, IRenderer renderer) {
        MachineState.Builder<T> builder = builderCreator.get().name("base").renderer(renderer).shape(Shapes.m_83144_()).lightLevel(0).child((MachineState)builderCreator.get().name("working").child((MachineState)builderCreator.get().name("waiting").build()).build()).child((MachineState)builderCreator.get().name("suspend").build());
        return builder.build();
    }

    public static <T extends MachineState> T createMultiblockDefault(Supplier<MachineState.Builder<T>> builderCreator, IRenderer renderer) {
        MachineState.Builder<T> builder = builderCreator.get().name("base").renderer(renderer).shape(Shapes.m_83144_()).lightLevel(0).child((MachineState)builderCreator.get().name("formed").child((MachineState)builderCreator.get().name("working").child((MachineState)builderCreator.get().name("waiting").build()).build()).child((MachineState)builderCreator.get().name("suspend").build()).build());
        return builder.build();
    }

    public static <T extends MachineState> T createDefault(Supplier<MachineState.Builder<T>> builderCreator) {
        return StateMachine.createSingleDefault(builderCreator, IRenderer.EMPTY);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("root", (Tag)((MachineState)this.rootState).serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        ((MachineState)this.rootState).deserializeNBT(tag.m_128469_("root"));
        this.initStateMachine();
    }

    public void initStateMachine() {
        this.states.clear();
        ((MachineState)this.rootState).init(this);
    }

    protected void addState(T state) {
        this.states.put(((MachineState)state).name(), state);
    }

    public T getState(String name) {
        return (T)((MachineState)this.states.getOrDefault(name, this.rootState));
    }

    public boolean hasState(String name) {
        return this.states.containsKey(name);
    }

    public T getRootState() {
        return this.rootState;
    }
}

