/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.machine.definition.config;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ArrayConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorSelectorConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.syncdata.IPersistedSerializable;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.RecipeCondition;
import com.lowdragmc.mbd2.api.recipe.RecipeLogic;
import com.lowdragmc.mbd2.api.recipe.content.ContentModifier;
import com.lowdragmc.mbd2.api.registry.MBDRegistries;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class RecipeModifier
implements IConfigurable,
IPersistedSerializable {
    @Configurable(name="config.recipe.content_modifier", subConfigurable=true, tips={"config.recipe.content_modifier.tooltip"}, collapse=false)
    public final ContentModifier contentModifier = ContentModifier.of(1.0, 0.0);
    @Configurable(name="config.recipe.target_content", tips={"config.recipe.target_content.tooltip"})
    public final IO targetContent = IO.BOTH;
    @Configurable(name="config.recipe.duration_modifier", subConfigurable=true, tips={"config.recipe.duration_modifier.tooltip"}, collapse=false)
    public final ContentModifier durationModifier = ContentModifier.of(1.0, 0.0);
    public final List<RecipeCondition> recipeConditions = new ArrayList<RecipeCondition>();
    @Configurable(name="config.machine_settings.max_parallel", subConfigurable=true, tips={"config.machine_settings.max_parallel.tooltip"}, collapse=false)
    @NumberRange(range={1.0, 2.147483647E9})
    private ContentModifier maxParallel = ContentModifier.identity();

    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        ListTag conditions = new ListTag();
        for (RecipeCondition condition : this.recipeConditions) {
            CompoundTag conditionTag = new CompoundTag();
            conditionTag.m_128359_("type", (String)MBDRegistries.RECIPE_CONDITIONS.getKey(condition.getClass()));
            conditionTag.m_128365_("data", (Tag)condition.toNBT());
            conditions.add((Object)conditionTag);
        }
        tag.m_128365_("recipeConditions", (Tag)conditions);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.recipeConditions.clear();
        ListTag conditions = tag.m_128437_("recipeConditions", 10);
        for (int i = 0; i < conditions.size(); ++i) {
            CompoundTag conditionTag = conditions.m_128728_(i);
            RecipeCondition condition = RecipeCondition.create((Class)MBDRegistries.RECIPE_CONDITIONS.get(conditionTag.m_128461_("type")));
            if (condition == null) continue;
            condition.fromNBT(conditionTag.m_128469_("data"));
            this.recipeConditions.add(condition);
        }
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        super.buildConfigurator(father);
        ArrayConfiguratorGroup conditions = new ArrayConfiguratorGroup("config.recipe.recipe_conditions", false, () -> this.recipeConditions, (getter, setter) -> new ConfiguratorSelectorConfigurator("config.recipe.recipe_condition.type", false, () -> RecipeModifier.lambda$buildConfigurator$1((Supplier)getter), arg_0 -> this.lambda$buildConfigurator$2((Supplier)getter, arg_0), (Object)"rain", true, MBDRegistries.RECIPE_CONDITIONS.registry().keySet().stream().toList(), String::toString, (arg_0, arg_1) -> RecipeModifier.lambda$buildConfigurator$3((Supplier)getter, arg_0, arg_1)), true);
        conditions.setTips(new String[]{"config.recipe.recipe_conditions.tooltip"});
        conditions.setAddDefault(() -> RecipeCondition.create((Class)MBDRegistries.RECIPE_CONDITIONS.get("rain")));
        conditions.setOnAdd(this.recipeConditions::add);
        conditions.setOnRemove(this.recipeConditions::remove);
        conditions.setOnUpdate(list -> {
            this.recipeConditions.clear();
            this.recipeConditions.addAll((Collection<RecipeCondition>)list);
        });
        father.addConfigurators(new Configurator[]{conditions});
    }

    private static /* synthetic */ void lambda$buildConfigurator$3(Supplier getter, String type, ConfiguratorSelectorConfigurator container) {
        RecipeCondition current = (RecipeCondition)getter.get();
        current.buildConfigurator((ConfiguratorGroup)container);
    }

    private /* synthetic */ void lambda$buildConfigurator$2(Supplier getter, String type) {
        RecipeCondition current = (RecipeCondition)getter.get();
        RecipeCondition condition = RecipeCondition.create((Class)MBDRegistries.RECIPE_CONDITIONS.get(type));
        if (condition != null) {
            this.recipeConditions.set(this.recipeConditions.indexOf(current), condition);
        }
    }

    private static /* synthetic */ String lambda$buildConfigurator$1(Supplier getter) {
        return ((RecipeCondition)getter.get()).getType();
    }

    public static class RecipeModifiers
    implements ITagSerializable<ListTag>,
    IConfigurable {
        public final List<RecipeModifier> recipeModifiers = new ArrayList<RecipeModifier>();

        public ListTag serializeNBT() {
            ListTag modifiers = new ListTag();
            for (RecipeModifier modifier : this.recipeModifiers) {
                modifiers.add((Object)modifier.serializeNBT());
            }
            return modifiers;
        }

        public void deserializeNBT(ListTag modifiers) {
            this.recipeModifiers.clear();
            for (int i = 0; i < modifiers.size(); ++i) {
                RecipeModifier modifier = new RecipeModifier();
                modifier.deserializeNBT(modifiers.m_128728_(i));
                this.recipeModifiers.add(modifier);
            }
        }

        public void buildConfigurator(ConfiguratorGroup father) {
            ArrayConfiguratorGroup modifiers = new ArrayConfiguratorGroup("config.recipe.recipe_modifiers", true, () -> this.recipeModifiers, (getter, setter) -> {
                RecipeModifier recipeModifier = (RecipeModifier)getter.get();
                ConfiguratorGroup group = new ConfiguratorGroup("config.recipe.content_modifier", false);
                recipeModifier.buildConfigurator(group);
                return group;
            }, true);
            modifiers.setTips(new String[]{"config.recipe.recipe_modifiers.tooltip"});
            modifiers.setAddDefault(RecipeModifier::new);
            modifiers.setOnAdd(this.recipeModifiers::add);
            modifiers.setOnRemove(this.recipeModifiers::remove);
            modifiers.setOnUpdate(list -> {
                this.recipeModifiers.clear();
                this.recipeModifiers.addAll((Collection<RecipeModifier>)list);
            });
            father.addConfigurators(new Configurator[]{modifiers});
        }

        @Nonnull
        public MBDRecipe applyModifiers(RecipeLogic recipeLogic, @Nonnull MBDRecipe recipe) {
            if (this.recipeModifiers.isEmpty()) {
                return recipe;
            }
            ArrayList<Pair> contentModifiers = new ArrayList<Pair>();
            ArrayList<ContentModifier> durationModifiers = new ArrayList<ContentModifier>();
            for (RecipeModifier modifier : this.recipeModifiers) {
                if (!this.checkConditions(recipeLogic, recipe, modifier)) continue;
                if (!modifier.contentModifier.isIdentity() && modifier.targetContent != IO.NONE) {
                    contentModifiers.add(Pair.of((Object)modifier.contentModifier, (Object)((Object)modifier.targetContent)));
                }
                if (modifier.durationModifier.isIdentity()) continue;
                durationModifiers.add(modifier.durationModifier);
            }
            if (!contentModifiers.isEmpty()) {
                List<ContentModifier> inputModifiers = contentModifiers.stream().filter(pair -> pair.getSecond() == IO.IN || pair.getSecond() == IO.BOTH).map(Pair::getFirst).toList();
                List<ContentModifier> outputModifiers = contentModifiers.stream().filter(pair -> pair.getSecond() == IO.OUT || pair.getSecond() == IO.BOTH).map(Pair::getFirst).toList();
                if (!inputModifiers.isEmpty()) {
                    recipe = recipe.copy(inputModifiers.stream().reduce(ContentModifier.IDENTITY, ContentModifier::merge), false, IO.IN);
                }
                if (!outputModifiers.isEmpty()) {
                    recipe = recipe.copy(outputModifiers.stream().reduce(ContentModifier.IDENTITY, ContentModifier::merge), false, IO.OUT);
                }
            }
            if (!durationModifiers.isEmpty()) {
                if (contentModifiers.isEmpty()) {
                    recipe = recipe.copy();
                }
                recipe.duration = durationModifiers.stream().reduce(ContentModifier.IDENTITY, ContentModifier::merge).apply(recipe.duration).intValue();
            }
            return recipe;
        }

        public ContentModifier getMaxParallel(RecipeLogic recipeLogic, @Nonnull MBDRecipe recipe) {
            if (this.recipeModifiers.isEmpty()) {
                return ContentModifier.IDENTITY;
            }
            ContentModifier maxParallel = ContentModifier.IDENTITY;
            for (RecipeModifier modifier : this.recipeModifiers) {
                if (modifier.maxParallel.isIdentity() || !this.checkConditions(recipeLogic, recipe, modifier)) continue;
                maxParallel = maxParallel.merge(modifier.maxParallel);
            }
            return maxParallel;
        }

        private boolean checkConditions(RecipeLogic recipeLogic, @Nonnull MBDRecipe recipe, RecipeModifier modifier) {
            HashMap<String, List> or = new HashMap<String, List>();
            boolean success = true;
            for (RecipeCondition condition2 : modifier.recipeConditions) {
                if (condition2.isOr()) {
                    or.computeIfAbsent(condition2.getType(), type -> new ArrayList()).add(condition2);
                    continue;
                }
                if (condition2.test(recipe, recipeLogic) != condition2.isReverse()) continue;
                success = false;
                break;
            }
            for (List conditions : or.values()) {
                MBDRecipe finalRecipe = recipe;
                if (!conditions.stream().allMatch(condition -> condition.test(finalRecipe, recipeLogic) == condition.isReverse())) continue;
                success = false;
                break;
            }
            return success;
        }
    }
}

