/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.machine.definition.config;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseGraph;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.parameter.ExposedParameter;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.trigger.StartNode;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.IPersistedSerializable;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.mbd2.common.graphprocessor.MachineEventGraphProcessor;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import com.lowdragmc.mbd2.common.gui.editor.machine.MachineEventsPanel;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineEvent;
import com.lowdragmc.mbd2.integration.ldlib.MBDLDLibPlugin;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class ConfigMachineEvents
implements IConfigurable,
IPersistedSerializable {
    public final Map<String, Class<? extends MachineEvent>> machineEvents = new HashMap<String, Class<? extends MachineEvent>>();
    public final Map<Class<? extends MachineEvent>, BaseGraph> eventGraphs = new HashMap<Class<? extends MachineEvent>, BaseGraph>();
    private final Map<Class<? extends MachineEvent>, MachineEventGraphProcessor> processorCache = new HashMap<Class<? extends MachineEvent>, MachineEventGraphProcessor>();

    public ConfigMachineEvents registerEventGroup(String group) {
        Optional.ofNullable(MBDLDLibPlugin.REGISTER_MACHINE_EVENTS.get(group)).ifPresent(l -> l.forEach(clazz -> this.machineEvents.put(clazz.getAnnotation(LDLRegister.class).name(), (Class<? extends MachineEvent>)clazz)));
        return this;
    }

    public void postGraphEvent(MachineEvent event) {
        Class<?> eventClazz = ((Object)((Object)event)).getClass();
        if (!this.eventGraphs.containsKey(eventClazz)) {
            return;
        }
        if (!this.processorCache.containsKey(eventClazz)) {
            this.processorCache.put(eventClazz, new MachineEventGraphProcessor(eventClazz, this.eventGraphs.get(eventClazz)));
        }
        this.processorCache.get(eventClazz).postEvent(event);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        CompoundTag eventGraphsTag = new CompoundTag();
        for (Map.Entry<Class<? extends MachineEvent>, BaseGraph> entry : this.eventGraphs.entrySet()) {
            if (!entry.getKey().isAnnotationPresent(LDLRegister.class)) continue;
            String name = entry.getKey().getAnnotation(LDLRegister.class).name();
            BaseGraph graph = entry.getValue();
            if (graph == null) continue;
            eventGraphsTag.m_128365_(name, (Tag)entry.getValue().serializeNBT());
        }
        tag.m_128365_("eventGraphs", (Tag)eventGraphsTag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.eventGraphs.clear();
        this.processorCache.clear();
        super.deserializeNBT(tag);
        CompoundTag eventGraphsTag = tag.m_128469_("eventGraphs");
        for (String name : eventGraphsTag.m_128431_()) {
            Class<? extends MachineEvent> clazz = this.machineEvents.get(name);
            if (clazz == null) continue;
            List<ExposedParameter<?>> parameters = MachineEvent.getExposedParameters(clazz);
            BaseGraph graph = new BaseGraph(parameters);
            try {
                graph.deserializeNBT(eventGraphsTag.m_128469_(name));
                this.eventGraphs.put(clazz, graph);
            }
            catch (Exception e) {
                LDLib.LOGGER.error("Failed to deserialize event graph for %s".formatted(name), (Throwable)e);
            }
        }
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        super.buildConfigurator(father);
        for (Class<? extends MachineEvent> clazz : this.machineEvents.values()) {
            MachineEventsPanel machineEventsPanel;
            LDLRegister annotation = clazz.getAnnotation(LDLRegister.class);
            String eventName = "%s.%s".formatted(annotation.group(), annotation.name());
            ButtonWidget removeButton = new ButtonWidget(90, 2, 80, 11, null);
            removeButton.setButtonTexture(new IGuiTexture[]{new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_GRAY.rectTexture(), new TextTexture("config.machine_event.graph.remove")})});
            removeButton.setVisible(this.eventGraphs.containsKey(clazz));
            Runnable updateRemoveButtonStyle = () -> removeButton.setVisible(this.eventGraphs.containsKey(clazz));
            Editor editor = Editor.INSTANCE;
            if (editor instanceof MachineEditor) {
                MachineEditor machineEditor = (MachineEditor)editor;
                machineEventsPanel = machineEditor.getTabPages().tabs.values().stream().filter(MachineEventsPanel.class::isInstance).map(MachineEventsPanel.class::cast).findAny().orElse(null);
            } else {
                machineEventsPanel = null;
            }
            MachineEventsPanel panel = machineEventsPanel;
            removeButton.setOnPressCallback(cd -> {
                BaseGraph removed = this.eventGraphs.remove(clazz);
                updateRemoveButtonStyle.run();
                if (panel != null && panel.getCurrentGraph() == removed) {
                    panel.closeEventGraphEditor();
                }
            });
            ImageWidget backgroundImage = new ImageWidget(0, 2, 80, 11, () -> {
                if (this.eventGraphs.containsKey(clazz)) {
                    return panel != null && panel.getCurrentGraph() == this.eventGraphs.get(clazz) ? ColorPattern.GREEN.rectTexture().setRadius(5.0f) : ColorPattern.YELLOW.rectTexture().setRadius(5.0f);
                }
                return ColorPattern.T_GRAY.rectTexture().setRadius(5.0f);
            });
            ButtonWidget editButton = new ButtonWidget(0, 3, 80, 11, cd -> {
                BaseGraph graph = this.eventGraphs.get(clazz);
                if (graph == null) {
                    List<ExposedParameter<?>> parameters = MachineEvent.getExposedParameters(clazz);
                    graph = new BaseGraph(parameters);
                    graph.addNode(BaseNode.createFromType(StartNode.class, (Position)new Position(0, 0)));
                    this.eventGraphs.put(clazz, graph);
                }
                updateRemoveButtonStyle.run();
                if (panel != null) {
                    panel.openEventGraphEditor(graph);
                }
            }).setButtonTexture(new IGuiTexture[]{new TextTexture(() -> {
                if (this.eventGraphs.containsKey(clazz)) {
                    if (panel != null && panel.getCurrentGraph() == this.eventGraphs.get(clazz)) {
                        return "config.machine_event.graph.editing";
                    }
                    return "config.machine_event.graph.edit";
                }
                return "config.machine_event.graph.add";
            })});
            WrapperConfigurator wrapper = new WrapperConfigurator(eventName, (Widget)new WidgetGroup(0, 0, 180, 11).addWidget((Widget)backgroundImage).addWidget((Widget)editButton).addWidget((Widget)removeButton));
            wrapper.setTips(new String[]{eventName + ".tips"});
            father.addConfigurators(new Configurator[]{wrapper});
        }
    }

    public Map<String, Class<? extends MachineEvent>> getMachineEvents() {
        return this.machineEvents;
    }

    public Map<Class<? extends MachineEvent>, BaseGraph> getEventGraphs() {
        return this.eventGraphs;
    }

    public Map<Class<? extends MachineEvent>, MachineEventGraphProcessor> getProcessorCache() {
        return this.processorCache;
    }
}

