/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.machine;

import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.IEnhancedManaged;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.IManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RPCMethod;
import com.lowdragmc.lowdraglib.syncdata.annotation.UpdateListener;
import com.lowdragmc.lowdraglib.syncdata.field.FieldManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.syncdata.managed.IRef;
import com.lowdragmc.lowdraglib.syncdata.managed.MultiManagedStorage;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.api.blockentity.IMachineBlockEntity;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeHandler;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeHandlerTrait;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.MBDRecipeType;
import com.lowdragmc.mbd2.api.recipe.RecipeLogic;
import com.lowdragmc.mbd2.api.recipe.content.ContentModifier;
import com.lowdragmc.mbd2.client.MachineSound;
import com.lowdragmc.mbd2.common.gui.factory.MachineUIFactory;
import com.lowdragmc.mbd2.common.machine.definition.MBDMachineDefinition;
import com.lowdragmc.mbd2.common.machine.definition.config.MachineState;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineAfterRecipeWorkingEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineBeforeRecipeWorkingEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineClientTickEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineCustomDataUpdateEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineDropsEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineFuelBurningFinishEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineFuelRecipeModifyEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineNeighborChangedEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineOnLoadEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineOnRecipeWaitingEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineOnRecipeWorkingEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineOpenUIEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachinePlacedEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineRecipeModifyEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineRecipeStatusChangedEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineRemovedEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineRightClickEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineStateChangedEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineTickEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineUIEvent;
import com.lowdragmc.mbd2.common.trait.ICapabilityProviderTrait;
import com.lowdragmc.mbd2.common.trait.ITrait;
import com.lowdragmc.mbd2.common.trait.TraitDefinition;
import com.lowdragmc.mbd2.integration.geckolib.GeckolibRenderer;
import com.lowdragmc.mbd2.integration.photon.MachineFX;
import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXHelper;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import software.bernie.geckolib.core.animation.AnimationController;

public class MBDMachine
implements IMachine,
IEnhancedManaged,
ICapabilityProvider,
IUIHolder {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MBDMachine.class);
    private final FieldManagedStorage syncStorage = new FieldManagedStorage((IManaged)this);
    private final MBDMachineDefinition definition;
    private final IMachineBlockEntity machineHolder;
    @Persisted
    @DescSynced
    @UpdateListener(methodName="updateCustomData")
    private CompoundTag customData = new CompoundTag();
    @Persisted
    @DescSynced
    private final RecipeLogic recipeLogic;
    private final Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> recipeCapabilitiesProxy;
    @Nonnull
    @Persisted
    @DescSynced
    @UpdateListener(methodName="updateState")
    private String machineState;
    private final List<ITrait> additionalTraits = new ArrayList<ITrait>();
    private Map<IRenderer, Object> animatableMachine = new HashMap<IRenderer, Object>();
    private Map<String, Object> photonFXs = new HashMap<String, Object>();
    @Persisted
    @DescSynced
    private int dynamicMachineLevel = -1;
    @Persisted
    @DescSynced
    private byte[] outputSignal = new byte[6];
    @Persisted
    @DescSynced
    private byte[] outputDirectSignal = new byte[6];
    @Persisted
    @DescSynced
    private byte analogOutputSignal = 0;
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private MachineSound currentSound;

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void onChanged() {
        this.markDirty();
    }

    public MBDMachine(IMachineBlockEntity machineHolder, MBDMachineDefinition definition, Object ... args) {
        this.machineHolder = machineHolder;
        this.definition = definition;
        IManagedStorage iManagedStorage = machineHolder.getRootStorage();
        if (!(iManagedStorage instanceof MultiManagedStorage)) {
            throw new RuntimeException("Root storage of MBDMachine's holder must be MultiManagedStorage");
        }
        MultiManagedStorage multiManagedStorage = (MultiManagedStorage)iManagedStorage;
        multiManagedStorage.attach((IManagedStorage)this.getSyncStorage());
        this.recipeCapabilitiesProxy = Tables.newCustomTable(new EnumMap(IO.class), HashMap::new);
        this.machineState = ((MachineState)definition.stateMachine().getRootState()).name();
        this.recipeLogic = this.createRecipeLogic(args);
        this.loadAdditionalTraits();
    }

    @Override
    public void onChunkUnloaded() {
        IMachine.super.onChunkUnloaded();
        for (ITrait additionalTrait : this.additionalTraits) {
            additionalTrait.onChunkUnloaded();
        }
    }

    @Override
    public void onUnload() {
        IMachine.super.onUnload();
        for (ITrait additionalTrait : this.additionalTraits) {
            additionalTrait.onMachineUnLoad();
        }
    }

    @Override
    public void onLoad() {
        IMachine.super.onLoad();
        for (ITrait additionalTrait : this.additionalTraits) {
            additionalTrait.onMachineLoad();
        }
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, () -> MinecraftForge.EVENT_BUS.post((Event)new MachineOnLoadEvent(this).postCustomEvent())));
        }
    }

    public void detach() {
        IManagedStorage iManagedStorage = this.machineHolder.getRootStorage();
        if (iManagedStorage instanceof MultiManagedStorage) {
            MultiManagedStorage multiManagedStorage = (MultiManagedStorage)iManagedStorage;
            multiManagedStorage.detach((IManagedStorage)this.getSyncStorage());
            for (ITrait trait : this.additionalTraits) {
                if (!(trait instanceof IManaged)) continue;
                IManaged managed = (IManaged)trait;
                multiManagedStorage.detach(managed.getSyncStorage());
            }
        }
    }

    protected RecipeLogic createRecipeLogic(Object ... args) {
        return new RecipeLogic(this);
    }

    public boolean isDisableRendering() {
        return false;
    }

    public void setMachineState(String newState) {
        if (this.machineState.equals(newState)) {
            return;
        }
        if (this.definition.stateMachine().hasState(newState)) {
            MachineEvent event = new MachineStateChangedEvent(this, this.machineState, newState).postCustomEvent();
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                String oldState = this.machineState;
                this.machineState = newState;
                this.notifyBlockUpdate();
                this.updateState(newState, oldState);
            }
        }
    }

    public void updateCustomData(CompoundTag newValue, CompoundTag oldValue) {
        MinecraftForge.EVENT_BUS.post((Event)new MachineCustomDataUpdateEvent(this, newValue, oldValue).postCustomEvent());
    }

    public void updateState(String newValue, String oldValue) {
        boolean hasLightChanged;
        boolean bl = hasLightChanged = ((MachineState)this.definition.stateMachine().getState(newValue)).getLightLevel() != ((MachineState)this.definition.stateMachine().getState(oldValue)).getLightLevel();
        if (hasLightChanged) {
            ProfilerFiller profilerfiller = this.getLevel().m_46473_();
            Level level = this.getLevel();
            BlockPos pos = this.getPos();
            int j = pos.m_123341_() & 0xF;
            int k = pos.m_123342_() & 0xF;
            int l = pos.m_123343_() & 0xF;
            profilerfiller.m_6180_("updateSkyLightSources");
            LevelChunk levelChunk = level.m_46745_(this.getPos());
            levelChunk.m_284400_().m_284521_((BlockGetter)level, j, pos.m_123342_(), l);
            profilerfiller.m_6182_("queueCheckLight");
            level.m_7726_().m_7827_().m_7174_(pos);
            profilerfiller.m_7238_();
        }
        if (this.isRemote()) {
            this.playStateSound(newValue);
            this.scheduleRenderUpdate();
        }
    }

    public void loadAdditionalTraits() {
        IManagedStorage iManagedStorage = this.machineHolder.getRootStorage();
        if (iManagedStorage instanceof MultiManagedStorage) {
            MultiManagedStorage multiManagedStorage = (MultiManagedStorage)iManagedStorage;
            for (ITrait trait : this.additionalTraits) {
                if (!(trait instanceof IManaged)) continue;
                IManaged managed = (IManaged)trait;
                multiManagedStorage.detach(managed.getSyncStorage());
            }
            this.additionalTraits.clear();
            this.definition.machineSettings().traitDefinitions().stream().sorted((a, b) -> b.getPriority() - a.getPriority()).forEach(traitDefinition -> {
                ITrait trait = traitDefinition.createTrait(this);
                this.additionalTraits.add(trait);
                if (trait instanceof IManaged) {
                    IManaged managed = (IManaged)trait;
                    for (IRef ref : managed.getSyncStorage().getPersistedFields()) {
                        ref.setPersistedPrefixName("trait." + traitDefinition.getName());
                    }
                    multiManagedStorage.attach(managed.getSyncStorage());
                }
            });
            this.initCapabilitiesProxy();
        }
    }

    public void initCapabilitiesProxy() {
        this.recipeCapabilitiesProxy.clear();
        for (ITrait trait : this.additionalTraits) {
            for (IRecipeHandlerTrait<?> recipeHandlerTrait : trait.getRecipeHandlerTraits()) {
                if (!this.recipeCapabilitiesProxy.contains((Object)recipeHandlerTrait.getHandlerIO(), recipeHandlerTrait.getRecipeCapability())) {
                    this.recipeCapabilitiesProxy.put((Object)recipeHandlerTrait.getHandlerIO(), recipeHandlerTrait.getRecipeCapability(), new ArrayList());
                }
                ((List)this.recipeCapabilitiesProxy.get((Object)recipeHandlerTrait.getHandlerIO(), recipeHandlerTrait.getRecipeCapability())).add(recipeHandlerTrait);
            }
        }
    }

    @Nullable
    public ITrait getTraitByDefinition(TraitDefinition traitDefinition) {
        for (ITrait trait : this.additionalTraits) {
            if (traitDefinition != trait.getDefinition()) continue;
            return trait;
        }
        return null;
    }

    @Nullable
    public ITrait getTraitByName(String name) {
        for (ITrait trait : this.additionalTraits) {
            if (!trait.getDefinition().getName().equals(name)) continue;
            return trait;
        }
        return null;
    }

    public <T> T getTraitByName(Class<T> clazz, String name) {
        for (ITrait trait : this.additionalTraits) {
            if (!trait.getDefinition().getName().equals(name) || !clazz.isInstance(trait)) continue;
            return (T)trait;
        }
        return null;
    }

    @Override
    public BlockEntity getHolder() {
        return this.machineHolder.getSelf();
    }

    @Override
    public long getOffset() {
        return this.machineHolder.getOffset();
    }

    @Override
    public Optional<Direction> getFrontFacing() {
        return this.getDefinition().blockProperties().rotationState().property.flatMap(property -> this.getBlockState().m_61145_((Property)property));
    }

    @Override
    public boolean isFacingValid(Direction facing) {
        return this.getDefinition().blockProperties().rotationState().test(facing);
    }

    @Override
    public void setFrontFacing(Direction facing) {
        BlockState blockState = this.getBlockState();
        Optional<DirectionProperty> property = this.getDefinition().blockProperties().rotationState().property;
        if (property.isPresent() && blockState.m_61138_((Property)property.get()) && this.isFacingValid(facing)) {
            this.getLevel().m_46597_(this.getPos(), (BlockState)blockState.m_61124_((Property)property.get(), (Comparable)facing));
        }
    }

    @Override
    @NotNull
    public MBDRecipeType getRecipeType() {
        return this.definition.recipeLogicSettings().getRecipeType();
    }

    @Override
    public void notifyRecipeStatusChanged(RecipeLogic.Status oldStatus, RecipeLogic.Status newStatus) {
        switch (newStatus) {
            case WORKING: {
                this.setMachineState("working");
                break;
            }
            case IDLE: {
                this.setMachineState(((MachineState)this.definition.stateMachine().getRootState()).name());
                break;
            }
            case WAITING: {
                this.setMachineState("waiting");
                break;
            }
            case SUSPEND: {
                this.setMachineState("suspend");
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new MachineRecipeStatusChangedEvent(this, oldStatus, newStatus).postCustomEvent());
    }

    @Override
    public int getMachineLevel() {
        return this.dynamicMachineLevel < 0 ? this.getDefinition().machineSettings().machineLevel() : this.dynamicMachineLevel;
    }

    public void setMachineLevel(int level) {
        this.dynamicMachineLevel = level;
    }

    @Override
    public void scheduleRenderUpdate() {
        IMachine.super.scheduleRenderUpdate();
    }

    public MachineState getMachineState() {
        return this.definition.getState(this.machineState);
    }

    public String getMachineStateName() {
        return this.machineState;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        ArrayList results = new ArrayList();
        for (ITrait trait : this.additionalTraits) {
            for (ICapabilityProviderTrait<?> capabilityProviderTrait : trait.getCapabilityProviderTraits()) {
                IO io;
                if (capabilityProviderTrait.getCapability() != cap || (io = capabilityProviderTrait.getCapabilityIO(side)) == IO.NONE) continue;
                results.add(capabilityProviderTrait.getCapContent(io));
            }
        }
        if (results.isEmpty()) {
            return LazyOptional.empty();
        }
        if (results.size() == 1) {
            return LazyOptional.of(() -> results.get(0));
        }
        for (ITrait trait : this.additionalTraits) {
            for (ICapabilityProviderTrait<?> capabilityProviderTrait : trait.getCapabilityProviderTraits()) {
                if (capabilityProviderTrait.getCapability() != cap) continue;
                return LazyOptional.of(() -> capabilityProviderTrait.mergeContents(results));
            }
        }
        return cap.orEmpty(cap, LazyOptional.of(() -> results.get(0)));
    }

    protected void rpcToPlayer(ServerPlayer player, String methodName, Object ... args) {
        this.machineHolder.rpcToPlayer((IManaged)this, player, methodName, args);
    }

    protected void rpcToTracking(String methodName, Object ... args) {
        this.machineHolder.rpcToTracking((IManaged)this, methodName, args);
    }

    public void serverTick() {
        MachineEvent event = new MachineTickEvent(this).postCustomEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            this.internalServerTick();
        }
    }

    protected void internalServerTick() {
        if (this.runRecipeLogic()) {
            this.recipeLogic.serverTick();
        }
        for (ITrait trait : this.additionalTraits) {
            trait.serverTick();
        }
    }

    @Override
    public boolean runRecipeLogic() {
        return this.getDefinition().recipeLogicSettings().isEnable() && IMachine.super.runRecipeLogic();
    }

    @Override
    @Nullable
    public MBDRecipe modifyFuelRecipe(MBDRecipe recipe) {
        MachineFuelRecipeModifyEvent event = new MachineFuelRecipeModifyEvent(this, recipe);
        MinecraftForge.EVENT_BUS.post((Event)event.postCustomEvent());
        if (event.isCanceled()) {
            return null;
        }
        return event.getRecipe();
    }

    @Override
    public void onFuelBurningFinish(@Nullable MBDRecipe recipe) {
        MinecraftForge.EVENT_BUS.post((Event)new MachineFuelBurningFinishEvent(this, recipe));
    }

    @Override
    @Nullable
    public MBDRecipe doModifyRecipe(@NotNull MBDRecipe recipe) {
        MachineRecipeModifyEvent.Before before = new MachineRecipeModifyEvent.Before(this, recipe);
        MinecraftForge.EVENT_BUS.post((Event)before.postCustomEvent());
        recipe = before.getRecipe();
        if (before.isCanceled() || recipe == null) {
            return recipe;
        }
        recipe = IMachine.super.doModifyRecipe(recipe);
        MachineRecipeModifyEvent.After after = new MachineRecipeModifyEvent.After(this, recipe);
        MinecraftForge.EVENT_BUS.post((Event)after.postCustomEvent());
        return after.getRecipe();
    }

    @Override
    @Nullable
    public MBDRecipe getModifiedRecipe(@Nonnull MBDRecipe recipe) {
        return this.getDefinition().recipeLogicSettings().recipeModifiers().applyModifiers(this.getRecipeLogic(), recipe);
    }

    @Override
    public ContentModifier getMaxParallel(@Nonnull MBDRecipe recipe) {
        return this.getDefinition().recipeLogicSettings().recipeModifiers().getMaxParallel(this.getRecipeLogic(), recipe);
    }

    @Override
    public boolean alwaysTryModifyRecipe() {
        return !this.getDefinition().recipeLogicSettings().recipeModifiers().recipeModifiers.isEmpty() || this.getDefinition().recipeLogicSettings().alwaysModifyRecipe();
    }

    @Override
    public boolean alwaysReSearchRecipe() {
        return this.getDefinition().recipeLogicSettings().alwaysSearchRecipe();
    }

    @Override
    public int getRecipeDampingValue() {
        return this.getDefinition().recipeLogicSettings().recipeDampingValue();
    }

    @Override
    public boolean consumeInputsAfterWorking(MBDRecipe recipe) {
        if (this.getDefinition().recipeLogicSettings().consumeInputsAfterWorking()) {
            MachineEvent event = new MachineAfterRecipeWorkingEvent(this, recipe).postCustomEvent();
            MinecraftForge.EVENT_BUS.post((Event)event);
            return !event.isCanceled();
        }
        return false;
    }

    @Override
    public boolean beforeWorking(MBDRecipe recipe) {
        MachineBeforeRecipeWorkingEvent event = new MachineBeforeRecipeWorkingEvent(this, recipe);
        MinecraftForge.EVENT_BUS.post((Event)event.postCustomEvent());
        if (event.isCanceled()) {
            return true;
        }
        return IMachine.super.beforeWorking(recipe);
    }

    @Override
    public boolean onWorking() {
        MachineOnRecipeWorkingEvent event = new MachineOnRecipeWorkingEvent(this, this.recipeLogic.getLastRecipe(), this.recipeLogic.getProgress());
        MinecraftForge.EVENT_BUS.post((Event)event.postCustomEvent());
        if (event.isCanceled()) {
            return true;
        }
        return IMachine.super.onWorking();
    }

    @Override
    public void onWaiting() {
        MinecraftForge.EVENT_BUS.post((Event)new MachineOnRecipeWaitingEvent(this, this.recipeLogic.getLastRecipe()).postCustomEvent());
        IMachine.super.onWaiting();
    }

    @Override
    public void afterWorking() {
        MinecraftForge.EVENT_BUS.post((Event)new MachineAfterRecipeWorkingEvent(this, this.recipeLogic.getLastRecipe()).postCustomEvent());
        IMachine.super.afterWorking();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        MinecraftForge.EVENT_BUS.post((Event)new MachineClientTickEvent(this).postCustomEvent());
        for (ITrait trait : this.additionalTraits) {
            trait.clientTick();
        }
        if (this.currentSound != null && this.currentSound.loop && this.currentSound.loopWithShuffle && !Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)this.currentSound)) {
            if (this.currentSound.predicate.getAsBoolean()) {
                this.currentSound.play();
            } else {
                this.currentSound = null;
            }
        }
    }

    public void animateTick(RandomSource random) {
    }

    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        MinecraftForge.EVENT_BUS.post((Event)new MachineNeighborChangedEvent(this, block, fromPos).postCustomEvent());
        for (ITrait trait : this.additionalTraits) {
            trait.onNeighborChanged(block, fromPos, isMoving);
        }
    }

    public void onMachinePlaced(LivingEntity player, ItemStack stack) {
        MinecraftForge.EVENT_BUS.post((Event)new MachinePlacedEvent(this, player, stack).postCustomEvent());
    }

    public BlockState getAppearance(BlockState state, Direction side, BlockState queryState, BlockPos queryPos) {
        return state;
    }

    public VoxelShape getShape(CollisionContext pContext) {
        return this.getDefinition().getState(this.machineState).getShape(this.getFrontFacing().orElse(Direction.NORTH));
    }

    public void setOutputSignal(int signal, Direction side) {
        if (!this.isRemote()) {
            byte sig = (byte)Mth.m_14045_((int)signal, (int)0, (int)15);
            if (this.outputSignal[side.ordinal()] != sig) {
                this.outputSignal[side.ordinal()] = sig;
                this.updateSignal();
            }
        }
    }

    public void setOutputDirectSignal(int signal, Direction side) {
        if (!this.isRemote()) {
            byte sig = (byte)Mth.m_14045_((int)signal, (int)0, (int)15);
            if (this.outputDirectSignal[side.ordinal()] != sig) {
                this.outputDirectSignal[side.ordinal()] = sig;
                this.updateSignal();
            }
        }
    }

    public void setAnalogOutputSignal(int signal) {
        byte sig;
        if (!this.isRemote() && this.analogOutputSignal != (sig = (byte)Mth.m_14045_((int)signal, (int)0, (int)15))) {
            this.analogOutputSignal = sig;
            this.updateSignal();
        }
    }

    public boolean canConnectRedstone(Direction direction) {
        if (this.getOutputSignal(direction) > 0) {
            return true;
        }
        return this.getDefinition().machineSettings().signalConnection().getConnection(this.getFrontFacing().orElse(Direction.NORTH), direction);
    }

    public int getOutputSignal(Direction direction) {
        return this.outputSignal[direction.ordinal()];
    }

    public int getOutputDirectSignal(Direction direction) {
        return this.outputDirectSignal[direction.ordinal()];
    }

    public void updateSignal() {
        if (!this.getLevel().f_46443_) {
            this.notifyBlockUpdate();
        }
    }

    public void onMachineRemoved() {
        for (ITrait additionalTrait : this.additionalTraits) {
            additionalTrait.onMachineRemoved();
        }
        MinecraftForge.EVENT_BUS.post((Event)new MachineRemovedEvent(this).postCustomEvent());
    }

    public ItemStack getDropItem() {
        return this.getDefinition().asStack();
    }

    public void onDrops(Entity entity, List<ItemStack> drops) {
        ItemStack drop;
        if (this.getDefinition().machineSettings().dropMachineItem() && !(drop = this.getDropItem()).m_41619_()) {
            drops.add(drop);
        }
        MinecraftForge.EVENT_BUS.post((Event)new MachineDropsEvent(this, entity, drops).postCustomEvent());
    }

    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        MachineRightClickEvent event = new MachineRightClickEvent(this, player, hand, hit);
        event.setInteractionResult(InteractionResult.PASS);
        MinecraftForge.EVENT_BUS.post((Event)event.postCustomEvent());
        return event.getInteractionResult();
    }

    public boolean shouldOpenUI(InteractionHand hand, BlockHitResult hit) {
        return this.getDefinition().machineSettings().hasUI();
    }

    public InteractionResult openUI(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MachineOpenUIEvent event = new MachineOpenUIEvent(this, player);
            MinecraftForge.EVENT_BUS.post((Event)event.postCustomEvent());
            if (event.isCanceled()) {
                return InteractionResult.PASS;
            }
            MachineUIFactory.INSTANCE.openUI(this, serverPlayer);
        }
        return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
    }

    public ModularUI createUI(Player entityPlayer) {
        WidgetGroup ui = this.getDefinition().uiCreator().apply(this);
        MachineUIEvent event = new MachineUIEvent(this, ui);
        MinecraftForge.EVENT_BUS.post((Event)event.postKubeJSEvent());
        ui = event.getRoot();
        if (ui == null) {
            return null;
        }
        return new ModularUI(ui, (IUIHolder)this, entityPlayer);
    }

    public boolean isInvalid() {
        return this.isInValid();
    }

    public boolean isRemote() {
        Level level = this.getLevel();
        return level == null ? LDLib.isRemote() : level.f_46443_;
    }

    public void markAsDirty() {
        this.markDirty();
    }

    @Nullable
    public AABB getRenderBoundingBox() {
        AABB aabb = this.getMachineState().getRenderingBox(this.getFrontFacing().orElse(Direction.NORTH));
        if (aabb != null) {
            aabb = aabb.m_82338_(this.getPos());
            return aabb;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public MachineSound getCurrentSound() {
        return this.currentSound;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playStateSound(String state) {
        if (this.getDefinition().stateMachine().hasState(state)) {
            this.currentSound = ((MachineState)this.definition.stateMachine().getState(state)).createMachineSound(this.getPos(), () -> IMachine.ofMachine((BlockGetter)this.getLevel(), this.getPos()).map(m -> m == this && ((MBDMachine)m).machineState.equals(state)).orElse(false));
            if (this.currentSound != null) {
                this.currentSound.play();
            }
        }
    }

    public void triggerGeckolibAnim(String animName, float speed) {
        this.triggerGeckolibAnim("", animName, speed);
    }

    @RPCMethod
    public void triggerGeckolibAnim(String controllerName, String animName, float speed) {
        if (MBD2.isGeckolibLoaded()) {
            if (this.isRemote()) {
                GeckolibRenderer renderer;
                AnimationController controller;
                IRenderer iRenderer;
                if (controllerName.isEmpty()) {
                    controllerName = "base_controller";
                }
                if ((iRenderer = this.getMachineState().getRenderer()) instanceof GeckolibRenderer && (controller = (AnimationController)(renderer = (GeckolibRenderer)iRenderer).getAnimatableFromMachine(this).getAnimatableInstanceCache().getManagerForId(0L).getAnimationControllers().get(controllerName)) != null) {
                    controller.setAnimationSpeed((double)Math.max(speed, 0.0f));
                    controller.tryTriggerAnimation(animName);
                }
            } else {
                this.rpcToTracking("triggerGeckolibAnim", controllerName, animName, Float.valueOf(speed));
            }
        }
    }

    @RPCMethod
    public void emitPhotonFx(String identifier, ResourceLocation fxLocation, Vector3f offset, Vector3f rotation, int delay, boolean forcedDeath, boolean replaceExisting) {
        if (MBD2.isPhotonLoaded()) {
            if (this.isRemote()) {
                FX fx = FXHelper.getFX((ResourceLocation)fxLocation);
                if (fx != null) {
                    MachineFX machineFX = new MachineFX(fx, identifier, this);
                    machineFX.setOffset(offset.x, offset.y, offset.z);
                    machineFX.setRotation(rotation.x, rotation.y, rotation.z);
                    machineFX.setDelay(delay);
                    machineFX.setForcedDeath(forcedDeath);
                    machineFX.setReplaceExisting(replaceExisting);
                    machineFX.start();
                }
            } else {
                this.rpcToTracking("emitPhotonFx", identifier, fxLocation, offset, rotation, delay, forcedDeath, replaceExisting);
            }
        }
    }

    @RPCMethod
    public void killPhotonFx(String identifier, boolean forcedDeath) {
        if (MBD2.isPhotonLoaded()) {
            if (this.isRemote()) {
                Object object = this.photonFXs.get(identifier);
                if (object instanceof MachineFX) {
                    MachineFX machineFX = (MachineFX)((Object)object);
                    machineFX.kill(forcedDeath);
                    this.photonFXs.remove(identifier);
                }
            } else {
                this.rpcToTracking("killPhotonFx", identifier, forcedDeath);
            }
        }
    }

    public FieldManagedStorage getSyncStorage() {
        return this.syncStorage;
    }

    public MBDMachineDefinition getDefinition() {
        return this.definition;
    }

    public IMachineBlockEntity getMachineHolder() {
        return this.machineHolder;
    }

    public CompoundTag getCustomData() {
        return this.customData;
    }

    @Override
    public RecipeLogic getRecipeLogic() {
        return this.recipeLogic;
    }

    @Override
    public Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> getRecipeCapabilitiesProxy() {
        return this.recipeCapabilitiesProxy;
    }

    public void setCustomData(CompoundTag customData) {
        this.customData = customData;
    }

    public List<ITrait> getAdditionalTraits() {
        return this.additionalTraits;
    }

    public Map<IRenderer, Object> getAnimatableMachine() {
        return this.animatableMachine;
    }

    public Map<String, Object> getPhotonFXs() {
        return this.photonFXs;
    }

    public int getDynamicMachineLevel() {
        return this.dynamicMachineLevel;
    }

    public byte[] getOutputSignal() {
        return this.outputSignal;
    }

    public byte[] getOutputDirectSignal() {
        return this.outputDirectSignal;
    }

    public byte getAnalogOutputSignal() {
        return this.analogOutputSignal;
    }
}

