/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.recipe.ingredient.entity;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ValueConfigurator;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.WidgetTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SearchComponentWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.mbd2.api.recipe.ingredient.EntityIngredient;
import com.lowdragmc.mbd2.common.gui.recipe.ingredient.entity.EntityPreviewWidget;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class EntityTypeConfigurator
extends ValueConfigurator<EntityType<?>>
implements SearchComponentWidget.IWidgetSearch<EntityType<?>> {
    protected SearchComponentWidget<EntityType<?>> searchComponent;
    protected ImageWidget image;

    public EntityTypeConfigurator(String name, Supplier<EntityType<?>> supplier, Consumer<EntityType<?>> onUpdate, @Nonnull EntityType<?> defaultValue, boolean forceUpdate) {
        super(name, supplier, onUpdate, defaultValue, forceUpdate);
        if (this.value == null) {
            this.value = defaultValue;
        }
    }

    protected void onValueUpdate(EntityType<?> newValue) {
        if (newValue == null) {
            newValue = (EntityType)this.defaultValue;
        }
        if (this.value == newValue) {
            return;
        }
        super.onValueUpdate((Object)newValue);
        this.searchComponent.setCurrent((Object)((EntityType)this.value));
    }

    public void init(int width) {
        super.init(width);
        this.image = new ImageWidget(this.leftWidth, 2, width - this.leftWidth - 3 - this.rightWidth, 10, (IGuiTexture)ColorPattern.T_GRAY.rectTexture().setRadius(5.0f));
        this.addWidget((Widget)this.image);
        this.image.setDraggingConsumer(o -> o instanceof EntityType || o instanceof Entity, o -> this.image.setImage((IGuiTexture)ColorPattern.GREEN.rectTexture().setRadius(5.0f)), o -> this.image.setImage((IGuiTexture)ColorPattern.T_GRAY.rectTexture().setRadius(5.0f)), o -> {
            if (o instanceof Entity) {
                Entity entity = (Entity)o;
                this.onValueUpdate(entity.m_6095_());
                this.updateValue();
            } else if (o instanceof EntityType) {
                EntityType entityType = (EntityType)o;
                this.onValueUpdate(entityType);
                this.updateValue();
            }
            this.image.setImage((IGuiTexture)ColorPattern.T_GRAY.rectTexture().setRadius(5.0f));
        });
        this.searchComponent = new SearchComponentWidget(this.leftWidth + 3, 2, width - this.leftWidth - 6 - this.rightWidth, 10, (SearchComponentWidget.IWidgetSearch)this);
        this.addWidget((Widget)this.searchComponent);
        this.searchComponent.setIconProvider(type -> new WidgetTexture((Widget)new EntityPreviewWidget(EntityIngredient.of(1, type), 0, 0, 18, 18).setShowAmount(false)));
        this.searchComponent.setShowUp(true);
        this.searchComponent.setCapacity(5);
        this.searchComponent.setCurrent((Object)((EntityType)this.value));
        TextFieldWidget textFieldWidget = this.searchComponent.textFieldWidget;
        textFieldWidget.setClientSideWidget();
        textFieldWidget.setBordered(false);
    }

    public String resultDisplay(EntityType<?> entityType) {
        return BuiltInRegistries.f_256780_.m_7981_(entityType).toString();
    }

    public void selectResult(EntityType<?> value) {
        this.onValueUpdate(value);
        this.updateValue();
    }

    public void search(String word, Consumer<EntityType<?>> find) {
        String wordLower = word.toLowerCase();
        for (Map.Entry entry : BuiltInRegistries.f_256780_.m_6579_()) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            EntityType entityType = (EntityType)entry.getValue();
            ResourceLocation id = ((ResourceKey)entry.getKey()).m_135782_();
            if (!id.toString().contains(wordLower)) continue;
            find.accept(entityType);
        }
    }
}

