/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor.recipe.widget;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.editor.data.IProject;
import com.lowdragmc.lowdraglib.gui.editor.data.Resources;
import com.lowdragmc.lowdraglib.gui.editor.ui.view.FloatViewWidget;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.MBDRecipeSerializer;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import com.lowdragmc.mbd2.common.gui.editor.RecipeTypeProject;
import net.minecraft.nbt.CompoundTag;

public class RecipeXEIPreviewFloatView
extends FloatViewWidget {
    private boolean isFuel;
    private MBDRecipe recipe;
    private CompoundTag lastData;

    public RecipeXEIPreviewFloatView() {
        super(200, 200, 200, 120, false);
    }

    public String name() {
        return "recipe_xei_preview";
    }

    public String group() {
        return "editor.machine";
    }

    public IGuiTexture getIcon() {
        return new ProgressTexture();
    }

    public IGuiTexture getHoverIcon() {
        return Icons.REMOVE;
    }

    public MachineEditor getEditor() {
        return (MachineEditor)this.editor;
    }

    public void clearRecipe() {
        this.content.clearAllWidgets();
    }

    public void loadRecipe(boolean isFuel, MBDRecipe recipe) {
        this.clearRecipe();
        this.isFuel = isFuel;
        if (recipe == null) {
            return;
        }
        IProject iProject = this.editor.getCurrentProject();
        if (iProject instanceof RecipeTypeProject) {
            RecipeTypeProject project = (RecipeTypeProject)iProject;
            this.recipe = recipe;
            this.lastData = MBDRecipeSerializer.SERIALIZER.toNBT(recipe);
            CompoundTag tag = IConfigurableWidget.serializeNBT((IConfigurableWidget)(isFuel ? project.getFuelUI() : project.getUi()), (Resources)project.getResources(), (boolean)true);
            WidgetGroup ui = new WidgetGroup();
            ui.setClientSideWidget();
            IConfigurableWidget.deserializeNBT((IConfigurableWidget)ui, (CompoundTag)tag, (Resources)project.getResources(), (boolean)true);
            project.getRecipeType().bindXEIRecipeUI(ui, recipe);
            ui.setSelfPosition(0, 0);
            this.resetSeize(ui.getSizeWidth(), ui.getSizeHeight());
            this.content.addWidget((Widget)ui);
        }
    }

    public void resetSeize(int width, int height) {
        this.setSize(width, height + 15);
        this.clearAllWidgets();
        this.initWidget();
        if (this.isCollapse) {
            this.title.setSize(new Size(15, 15));
            this.title.setBackground(new IGuiTexture[]{new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_RED.rectTexture().setRadius(5.0f), ColorPattern.GRAY.borderTexture(-1).setRadius(5.0f)})});
            this.content.setVisible(false);
            this.content.setActive(false);
        } else {
            this.title.setSize(new Size(this.getSize().width, 15));
            this.title.setBackground(new IGuiTexture[]{new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_RED.rectTexture().setTopRadius(5.0f), ColorPattern.GRAY.borderTexture(-1).setTopRadius(5.0f)})});
            this.content.setVisible(true);
            this.content.setActive(true);
        }
    }

    public void updateScreen() {
        CompoundTag data;
        super.updateScreen();
        if (this.recipe != null && !(data = MBDRecipeSerializer.SERIALIZER.toNBT(this.recipe)).equals((Object)this.lastData)) {
            this.loadRecipe(this.isFuel, this.recipe);
        }
    }
}

