/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor.multiblock.widget;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.gui.widget.SelectableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.lowdragmc.mbd2.api.pattern.BlockPattern;
import com.lowdragmc.mbd2.api.pattern.MultiblockShapeInfo;
import com.lowdragmc.mbd2.api.registry.MBDRegistries;
import com.lowdragmc.mbd2.common.blockentity.MachineBlockEntity;
import com.lowdragmc.mbd2.common.gui.editor.MultiblockMachineProject;
import com.lowdragmc.mbd2.common.gui.editor.multiblock.MultiblockShapeInfoPanel;
import com.lowdragmc.mbd2.common.machine.MBDMultiblockMachine;
import com.lowdragmc.mbd2.utils.ControllerBlockInfo;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ShapeInfoList
extends DraggableScrollableWidgetGroup {
    private final MultiblockShapeInfoPanel panel;
    @Nullable
    private MultiblockShapeInfo selectedShapeInfo;

    public ShapeInfoList(MultiblockShapeInfoPanel panel, Size size) {
        super(0, 0, size.width, size.height);
        this.panel = panel;
        this.setYScrollBarWidth(4).setYBarStyle(null, (IGuiTexture)ColorPattern.T_WHITE.rectTexture().setRadius(2.0f).transform(-0.5f, 0.0f));
        this.reloadShapeInfos();
    }

    public void reloadShapeInfos() {
        this.clearAllWidgets();
        TrackedDummyWorld level = this.panel.getLevel();
        level.clear();
        BlockPos offset = new BlockPos(0, 0, 0);
        ArrayList<MultiblockShapeInfo> shapes = new ArrayList<MultiblockShapeInfo>(this.panel.getProject().getMultiblockShapeInfos());
        boolean isBuiltin = shapes.isEmpty();
        if (isBuiltin) {
            BlockPattern blockPattern = MultiblockMachineProject.createBlockPattern(this.panel.getProject().getBlockPlaceholders(), this.panel.getProject().getLayerAxis(), this.panel.getProject().getAisleRepetitions(), this.panel.getProject().getDefinition(), true);
            int[] repetition = Arrays.stream(this.panel.getProject().getAisleRepetitions()).mapToInt(range -> range[0]).toArray();
            shapes.add(new MultiblockShapeInfo(blockPattern.getPreview(repetition)));
            for (int layer = 0; layer < this.panel.getProject().getAisleRepetitions().length; ++layer) {
                int[] range2 = this.panel.getProject().getAisleRepetitions()[layer];
                int i = range2[0] + 1;
                while (i <= range2[1]) {
                    repetition[layer] = i++;
                    shapes.add(new MultiblockShapeInfo(blockPattern.getPreview(repetition)));
                    repetition[layer] = range2[0];
                }
            }
        }
        for (int i = 0; i < shapes.size(); ++i) {
            MultiblockShapeInfo shapeInfo = shapes.get(i);
            int yOffset = 3 + this.widgets.size() * 82;
            SelectableWidgetGroup selectableWidgetGroup = new SelectableWidgetGroup(0, yOffset, this.getSizeWidth() - 2, 95);
            SceneWidget scene = new SceneWidget((selectableWidgetGroup.getSizeWidth() - 80) / 2, 0, 80, 80, null);
            scene.setRenderFacing(false);
            scene.setRenderSelect(false);
            scene.setIntractable(false);
            scene.createScene((Level)level);
            scene.getRenderer().setOnLookingAt(null);
            scene.useCacheBuffer();
            ArrayList<BlockPos> renderPositions = new ArrayList<BlockPos>();
            BlockInfo[][][] blocks = shapeInfo.getBlocks();
            for (int x = 0; x < blocks.length; ++x) {
                for (int y = 0; y < blocks[x].length; ++y) {
                    for (int z = 0; z < blocks[x][y].length; ++z) {
                        BlockPos pos = offset.m_7918_(x, y, z);
                        renderPositions.add(pos);
                        BlockInfo blockInfo = blocks[x][y][z];
                        if (blockInfo instanceof ControllerBlockInfo) {
                            ControllerBlockInfo controllerBlockInfo = (ControllerBlockInfo)blockInfo;
                            blockInfo = new BlockInfo((BlockState)MBDRegistries.FAKE_MACHINE().block().m_49966_().m_61124_((Property)MBDRegistries.FAKE_MACHINE().blockProperties().rotationState().property.orElseThrow(), (Comparable)controllerBlockInfo.getFacing()), blockEntity -> {
                                if (blockEntity instanceof MachineBlockEntity) {
                                    MachineBlockEntity machineBlockEntity = (MachineBlockEntity)blockEntity;
                                    MBDMultiblockMachine controllerMachine = this.panel.getProject().getDefinition().createMachine(machineBlockEntity);
                                    machineBlockEntity.setMachine(controllerMachine);
                                    controllerMachine.loadAdditionalTraits();
                                }
                            });
                        }
                        level.addBlock(pos, blockInfo);
                    }
                }
            }
            scene.setRenderedCore(renderPositions);
            selectableWidgetGroup.setSelectedTexture((IGuiTexture)ColorPattern.T_GRAY.rectTexture());
            selectableWidgetGroup.setOnSelected(group -> {
                this.panel.loadShapeInfo(isBuiltin ? null : shapeInfo, renderPositions);
                this.selectedShapeInfo = shapeInfo;
            });
            selectableWidgetGroup.addWidget((Widget)scene);
            selectableWidgetGroup.addWidget((Widget)new ImageWidget(0, 80, selectableWidgetGroup.getSizeWidth(), 15, (IGuiTexture)new TextTexture((String)(isBuiltin ? "auto-built" : "page: " + i)).setColor(isBuiltin ? ColorPattern.GRAY.color : ColorPattern.WHITE.color).setType(TextTexture.TextType.ROLL).setWidth(selectableWidgetGroup.getSizeWidth())));
            offset = offset.m_7918_(1000, 0, 1000);
            this.addWidget((Widget)selectableWidgetGroup);
        }
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 1 && this.selectedShapeInfo != null && this.isMouseOverElement(mouseX, mouseY) && !this.panel.getProject().getMultiblockShapeInfos().isEmpty()) {
            TreeBuilder.Menu menu = TreeBuilder.Menu.start().leaf((IGuiTexture)Icons.REMOVE, "editor.machine.multiblock.multiblock_shape_info.remove", () -> {
                this.panel.getProject().getMultiblockShapeInfos().remove(this.selectedShapeInfo);
                this.panel.clearShapeInfo();
                this.reloadShapeInfos();
            });
            this.panel.getEditor().openMenu(mouseX, mouseY, menu);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public MultiblockShapeInfoPanel getPanel() {
        return this.panel;
    }

    @Nullable
    public MultiblockShapeInfo getSelectedShapeInfo() {
        return this.selectedShapeInfo;
    }
}

