/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor.multiblock.widget;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.layout.Layout;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.mbd2.api.pattern.predicates.SimplePredicate;
import com.lowdragmc.mbd2.common.gui.editor.PredicateResource;
import com.lowdragmc.mbd2.common.gui.editor.multiblock.BlockPlaceholder;
import com.lowdragmc.mbd2.common.gui.editor.multiblock.MultiblockPatternPanel;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3i;

public class PatternLayerList
extends WidgetGroup {
    private final MultiblockPatternPanel panel;
    private final DraggableScrollableWidgetGroup layerContainer;

    public PatternLayerList(MultiblockPatternPanel panel, Size size) {
        super(0, 0, size.width, size.height);
        this.panel = panel;
        this.layerContainer = new DraggableScrollableWidgetGroup(0, 14, size.width, size.height - 14);
        this.layerContainer.setYScrollBarWidth(4).setYBarStyle(null, (IGuiTexture)ColorPattern.T_WHITE.rectTexture().setRadius(2.0f).transform(-0.5f, 0.0f));
        this.addWidget((Widget)this.layerContainer);
        this.addWidget((Widget)new ImageWidget(2, 1, size.width - 2 - 40, 14, (IGuiTexture)new TextTexture("editor.machine.multiblock.multiblock_pattern.layer_direction").setWidth(size.width - 2 - 40).setType(TextTexture.TextType.LEFT)));
        this.addWidget((Widget)new ImageWidget(size.width - 40, 1, 12, 12, () -> panel.getProject().getLayerAxis() == Direction.Axis.X ? ColorPattern.T_GREEN.rectTexture().setRadius(2.0f) : ColorPattern.T_GRAY.rectTexture().setRadius(2.0f)));
        this.addWidget((Widget)new ButtonWidget(size.width - 40, 1, 12, 12, (IGuiTexture)new TextTexture("x"), cd -> {
            panel.getProject().setLayerAxis(Direction.Axis.X);
            this.reloadLayers();
        }));
        this.addWidget((Widget)new ImageWidget(size.width - 40 + 13, 1, 12, 12, () -> panel.getProject().getLayerAxis() == Direction.Axis.Y ? ColorPattern.T_GREEN.rectTexture().setRadius(2.0f) : ColorPattern.T_GRAY.rectTexture().setRadius(2.0f)));
        this.addWidget((Widget)new ButtonWidget(size.width - 40 + 13, 1, 12, 12, (IGuiTexture)new TextTexture("y"), cd -> {
            panel.getProject().setLayerAxis(Direction.Axis.Y);
            this.reloadLayers();
        }));
        this.addWidget((Widget)new ImageWidget(size.width - 40 + 26, 1, 12, 12, () -> panel.getProject().getLayerAxis() == Direction.Axis.Z ? ColorPattern.T_GREEN.rectTexture().setRadius(2.0f) : ColorPattern.T_GRAY.rectTexture().setRadius(2.0f)));
        this.addWidget((Widget)new ButtonWidget(size.width - 40 + 26, 1, 12, 12, (IGuiTexture)new TextTexture("z"), cd -> {
            panel.getProject().setLayerAxis(Direction.Axis.Z);
            this.reloadLayers();
        }));
        this.reloadLayers();
    }

    public void reloadLayers() {
        this.layerContainer.clearAllWidgets();
        BlockPlaceholder[][][] placeholders = this.panel.getProject().getBlockPlaceholders();
        Direction.Axis axis = this.panel.getProject().getLayerAxis();
        int layerCount = switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> placeholders.length;
            case Direction.Axis.Y -> placeholders[0].length;
            case Direction.Axis.Z -> placeholders[0][0].length;
        };
        WidgetGroup container = new WidgetGroup(0, 0, this.layerContainer.getSizeWidth(), 16 * layerCount);
        container.setLayout(Layout.VERTICAL_LEFT);
        container.setLayoutPadding(2);
        for (int i = 0; i < layerCount; ++i) {
            container.addWidget((Widget)this.createLayerGroup(axis, i));
        }
        container.setDynamicSized(true);
        this.layerContainer.addWidget((Widget)container);
    }

    private WidgetGroup createLayerGroup(Direction.Axis axis, int index) {
        BlockPlaceholder[][][] placeholders = this.panel.getProject().getBlockPlaceholders();
        BlockPlaceholder[][] slice = this.getSliceByAxis(placeholders, axis, index);
        int totalAmount = slice.length * slice[0].length;
        WidgetGroup group = new WidgetGroup(2, 0, this.layerContainer.getSizeWidth() - 6, 28);
        WidgetGroup children = new WidgetGroup(2, 28, this.layerContainer.getSizeWidth() - 6, 16 * totalAmount);
        boolean hasController = false;
        int blockIndex = 0;
        String text = switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> "Y: %d, Z: %d";
            case Direction.Axis.Y -> "X: %d, Z: %d";
            case Direction.Axis.Z -> "X: %d, Y: %d";
        };
        for (int i = 0; i < slice.length; ++i) {
            for (int j = 0; j < slice[i].length; ++j) {
                BlockPlaceholder placeholder = slice[i][j];
                hasController |= placeholder.isController();
                Vector3i pos = switch (axis) {
                    default -> throw new IncompatibleClassChangeError();
                    case Direction.Axis.X -> new Vector3i(index, i, j);
                    case Direction.Axis.Y -> new Vector3i(i, index, j);
                    case Direction.Axis.Z -> new Vector3i(i, j, index);
                };
                WidgetGroup blockInfo = new WidgetGroup(10, 16 * blockIndex, children.getSizeWidth() - 10, 14);
                blockInfo.addWidget((Widget)new ImageWidget(2, 0, 14, 14, () -> new ItemStackTexture((ItemStack[])placeholder.getPredicates().stream().map(arg_0 -> ((PredicateResource)this.panel.getProject().getPredicateResource()).getResource(arg_0)).filter(Objects::nonNull).map(SimplePredicate::getCandidates).flatMap(Collection::stream).filter(itemStack -> !itemStack.m_41619_()).toArray(ItemStack[]::new))));
                blockInfo.addWidget((Widget)new ImageWidget(18, 1, blockInfo.getSizeWidth() - 18, 14, (IGuiTexture)new TextTexture(text.formatted(i, j)).setWidth(blockInfo.getSizeWidth() - 18).setType(TextTexture.TextType.ROLL)));
                children.addWidget((Widget)blockInfo);
                children.addWidget((Widget)new ImageWidget(0, 16 * blockIndex, children.getSizeWidth(), 14, () -> this.panel.isBlockSelected(pos) ? ColorPattern.T_GREEN.rectTexture() : IGuiTexture.EMPTY));
                children.addWidget((Widget)new ButtonWidget(0, 16 * blockIndex, children.getSizeWidth(), 14, cd -> {
                    if (cd.isCtrlClick || cd.isShiftClick) {
                        if (this.panel.isBlockSelected(pos)) {
                            this.panel.removeSelectedBlock(pos);
                        } else {
                            this.panel.addSelectedBlock(pos);
                        }
                    } else {
                        this.panel.addSelectedBlock(pos, true);
                    }
                }));
                ++blockIndex;
            }
        }
        children.setVisible(false);
        SwitchWidget layerButton = new SwitchWidget(1, 1, 14, 14, (cd, pressed) -> {
            children.setVisible(pressed.booleanValue());
            group.setSizeHeight(pressed != false ? 28 + 16 * totalAmount : 28);
        }).setTexture((IGuiTexture)Icons.RIGHT.copy().scale(0.8f), (IGuiTexture)Icons.DOWN.copy().scale(0.8f)).setSupplier(() -> ((WidgetGroup)children).isVisible());
        ImageWidget layerLabel = new ImageWidget(16, 2, group.getSizeWidth() - 4 - 32, 14, (IGuiTexture)new TextTexture((Direction.Axis.X == axis ? "X: " : (Direction.Axis.Y == axis ? "Y: " : "Z: ")) + index).setWidth(group.getSizeWidth() - 4 - 32).setType(TextTexture.TextType.ROLL));
        SwitchWidget visibleButton = new SwitchWidget(group.getSizeWidth() - 4 - 16, 1, 14, 14, (cd, pressed) -> this.panel.setVisibleLayer(pressed != false ? index : -1)).setTexture((IGuiTexture)Icons.EYE.copy().scale(0.8f), Icons.EYE.copy().scale(0.8f).setColor(ColorPattern.T_GREEN.color)).setSupplier(() -> this.panel.getVisibleLayer() == index);
        if (hasController) {
            group.addWidget((Widget)new ImageWidget(2, 14, group.getSizeWidth() - 4, 10, (IGuiTexture)new TextTexture("editor.machine.multiblock.multiblock_pattern.repetition_controller").setWidth(group.getSizeWidth() - 4).setType(TextTexture.TextType.ROLL)));
        } else {
            int[] repetition = this.panel.getProject().getAisleRepetitions()[index];
            group.addWidget((Widget)new ImageWidget(2, 14, 20, 10, (IGuiTexture)new TextTexture("min")));
            group.addWidget((Widget)new ImageWidget(24, 14, 40, 10, (IGuiTexture)ColorPattern.T_GRAY.rectTexture().setRadius(5.0f)));
            group.addWidget((Widget)new TextFieldWidget(27, 14, 37, 10, () -> "" + repetition[0], s -> {
                repetition[0] = Integer.parseInt(s);
                if (repetition[0] > repetition[1]) {
                    repetition[1] = repetition[0];
                }
            }).setCurrentString((Object)("" + repetition[0])).setBordered(false).setNumbersOnly(1, 100).setWheelDur(1.0f));
            group.addWidget((Widget)new ImageWidget(66, 14, 20, 10, (IGuiTexture)new TextTexture("max")));
            group.addWidget((Widget)new ImageWidget(88, 14, 40, 10, (IGuiTexture)ColorPattern.T_GRAY.rectTexture().setRadius(5.0f)));
            group.addWidget((Widget)new TextFieldWidget(91, 14, 37, 10, () -> "" + repetition[1], s -> {
                repetition[1] = Integer.parseInt(s);
                if (repetition[0] > repetition[1]) {
                    repetition[0] = repetition[1];
                }
            }).setCurrentString((Object)("" + repetition[1])).setBordered(false).setNumbersOnly(1, 100).setWheelDur(1.0f));
            group.addWidget(new ImageWidget(130, 13, 11, 11, (IGuiTexture)Icons.HELP).setHoverTooltips(new String[]{"editor.machine.multiblock.multiblock_pattern.repetition"}));
        }
        group.setBackground(new IGuiTexture[]{ColorPattern.T_GRAY.borderTexture(-2)});
        group.addWidget((Widget)layerButton);
        group.addWidget((Widget)layerLabel);
        group.addWidget((Widget)visibleButton);
        group.addWidget((Widget)children);
        return group;
    }

    private BlockPlaceholder[][] getSliceByAxis(BlockPlaceholder[][][] placeholders, Direction.Axis axis, int index) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> placeholders[index];
            case Direction.Axis.Y -> {
                BlockPlaceholder[][] blocks = new BlockPlaceholder[placeholders.length][];
                for (int i = 0; i < blocks.length; ++i) {
                    blocks[i] = placeholders[i][index];
                }
                yield blocks;
            }
            case Direction.Axis.Z -> {
                BlockPlaceholder[][] blocks = new BlockPlaceholder[placeholders.length][];
                for (int i = 0; i < blocks.length; ++i) {
                    blocks[i] = new BlockPlaceholder[placeholders[i].length];
                    for (int j = 0; j < blocks[i].length; ++j) {
                        blocks[i][j] = placeholders[i][j][index];
                    }
                }
                yield blocks;
            }
        };
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY) && button == 1) {
            this.panel.openMenu(mouseX, mouseY);
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public MultiblockPatternPanel getPanel() {
        return this.panel;
    }

    public DraggableScrollableWidgetGroup getLayerContainer() {
        return this.layerContainer;
    }
}

