/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor.multiblock;

import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.SceneEditorWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import com.lowdragmc.mbd2.common.gui.editor.MultiblockMachineProject;
import com.lowdragmc.mbd2.common.gui.editor.multiblock.widget.ShapeInfoList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public class MultiblockShapeInfoPanel
extends WidgetGroup {
    protected final MachineEditor editor;
    protected final MultiblockMachineProject project;
    protected final TrackedDummyWorld level;
    protected final SceneEditorWidget scene;
    protected final WidgetGroup buttonGroup;

    public MultiblockShapeInfoPanel(MachineEditor editor, MultiblockMachineProject project) {
        super(0, 32, Editor.INSTANCE.getSize().getWidth() - 252, Editor.INSTANCE.getSize().height - 16 - 16);
        this.editor = editor;
        this.project = project;
        this.scene = new SceneEditorWidget(0, 0, this.getSize().width, this.getSize().height, null);
        this.addWidget((Widget)this.scene);
        this.buttonGroup = new WidgetGroup(0, 0, this.getSize().width, this.getSize().height);
        this.addWidget((Widget)this.buttonGroup);
        this.scene.disableTransformGizmo();
        this.scene.setRenderFacing(false);
        this.scene.setRenderSelect(false);
        this.level = new TrackedDummyWorld();
        this.scene.createScene((Level)this.level);
        this.scene.useCacheBuffer();
        this.prepareButtonGroup();
        this.buttonGroup.setSize(new Size(Math.max(0, this.buttonGroup.widgets.size() * 25 - 5), 20));
        this.buttonGroup.setSelfPosition(new Position(this.getSize().width - this.buttonGroup.getSize().width - 25, 25));
    }

    public void clearShapeInfo() {
        this.scene.setRenderedCore(Collections.emptyList());
        this.editor.getConfigPanel().clearAllConfigurators(MachineEditor.BASIC);
    }

    public void loadShapeInfo(@Nullable IConfigurable configurable, Collection<BlockPos> blocks) {
        this.scene.setRenderedCore(blocks);
        if (configurable != null) {
            this.editor.getConfigPanel().openConfigurator(MachineEditor.BASIC, configurable);
        } else {
            this.editor.getConfigPanel().clearAllConfigurators(MachineEditor.BASIC);
        }
    }

    public void onPanelSelected() {
        this.editor.getConfigPanel().clearAllConfigurators();
        this.editor.getToolPanel().clearAllWidgets();
        this.editor.getToolPanel().setTitle("editor.machine.multiblock.multiblock_shape_info");
        this.editor.getToolPanel().addNewToolBox("editor.machine.multiblock.multiblock_shape_info", Icons.WIDGET_CUSTOM, size -> new ShapeInfoList(this, (Size)size));
        if (this.editor.getToolPanel().inAnimate()) {
            this.editor.getToolPanel().getAnimation().appendOnFinish(() -> this.editor.getToolPanel().show());
        } else {
            this.editor.getToolPanel().show();
        }
        this.clearShapeInfo();
    }

    public void onPanelDeselected() {
        this.editor.getToolPanel().setTitle("ldlib.gui.editor.group.tool_box");
        this.editor.getToolPanel().hide();
        this.editor.getToolPanel().clearAllWidgets();
        this.editor.getConfigPanel().clearAllConfigurators();
    }

    protected void prepareButtonGroup() {
    }

    public MachineEditor getEditor() {
        return this.editor;
    }

    public MultiblockMachineProject getProject() {
        return this.project;
    }

    public TrackedDummyWorld getLevel() {
        return this.level;
    }

    public SceneEditorWidget getScene() {
        return this.scene;
    }
}

