/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor.machine;

import com.lowdragmc.lowdraglib.gui.animation.Transform;
import com.lowdragmc.lowdraglib.gui.editor.data.IProject;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.editor.ui.MainPanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.tool.WidgetToolBox;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import com.lowdragmc.mbd2.common.gui.editor.MachineProject;
import com.lowdragmc.mbd2.common.gui.editor.machine.widget.TraitUIFloatView;

public class MachineUIPanel
extends MainPanel {
    private final TraitUIFloatView floatView;

    public MachineUIPanel(MachineEditor editor) {
        WidgetGroup widgetGroup;
        IProject iProject = editor.getCurrentProject();
        if (iProject instanceof MachineProject) {
            MachineProject machineProject = (MachineProject)iProject;
            widgetGroup = machineProject.getUi();
        } else {
            widgetGroup = new WidgetGroup();
        }
        super((Editor)editor, widgetGroup);
        this.floatView = new TraitUIFloatView();
    }

    public MachineEditor getEditor() {
        return (MachineEditor)this.editor;
    }

    public void onPanelSelected() {
        this.editor.getConfigPanel().clearAllConfigurators();
        this.editor.getToolPanel().clearAllWidgets();
        for (WidgetToolBox.Default tab : WidgetToolBox.Default.TABS) {
            this.editor.getToolPanel().addNewToolBox("ldlib.gui.editor.group." + tab.groupName, tab.icon, arg_0 -> ((WidgetToolBox.Default)tab).createToolBox(arg_0));
        }
        if (this.editor.getToolPanel().inAnimate()) {
            this.editor.getToolPanel().getAnimation().appendOnFinish(() -> this.editor.getToolPanel().show());
        } else {
            this.editor.getToolPanel().show();
        }
        this.editor.getFloatView().addWidgetAnima((Widget)this.floatView, new Transform().duration(200L).scale(0.2f));
        this.floatView.reloadTrait();
    }

    public void onPanelDeselected() {
        this.editor.getToolPanel().hide();
        this.editor.getToolPanel().clearAllWidgets();
        this.editor.getConfigPanel().clearAllConfigurators();
        this.editor.getFloatView().removeWidget((Widget)this.floatView);
    }

    public TraitUIFloatView getFloatView() {
        return this.floatView;
    }
}

