/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.graphprocessor.node;

import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

@LDLRegister(name="machine info", group="graph_processor.node.mbd2.machine")
public class MachineInfoNode
extends BaseNode {
    @InputPort
    public MBDMachine machine;
    @OutputPort
    public Level level;
    @OutputPort
    public Vector3f xyz;
    @OutputPort
    public Direction front;
    @OutputPort
    public String status;
    @OutputPort(name="recipe status", tips={"graph_processor.node.mbd2.recipe_logic.status.tips"})
    public String recipeStatus;
    @OutputPort(name="custom data")
    public CompoundTag customData;
    @OutputPort(name="machine level")
    public int machineLevel;

    protected void process() {
        if (this.machine != null) {
            BlockPos pos = this.machine.getPos();
            this.level = this.machine.getLevel();
            this.xyz = new Vector3f((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
            this.front = this.machine.getFrontFacing().orElse(Direction.NORTH);
            this.status = this.machine.getMachineState().name();
            this.recipeStatus = this.machine.getRecipeLogic().getStatus().toString();
            this.customData = this.machine.getCustomData();
            this.machineLevel = this.machine.getMachineLevel();
        }
    }
}

