/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.client.renderer;

import com.lowdragmc.lowdraglib.client.scene.WorldSceneRenderer;
import com.lowdragmc.lowdraglib.client.scene.forge.WorldSceneRendererImpl;
import com.lowdragmc.lowdraglib.client.utils.RenderUtils;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.lowdragmc.mbd2.api.block.RotationState;
import com.lowdragmc.mbd2.api.blockentity.IMachineBlockEntity;
import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.api.machine.IMultiController;
import com.lowdragmc.mbd2.api.pattern.MultiblockShapeInfo;
import com.lowdragmc.mbd2.common.block.MBDMachineBlock;
import com.lowdragmc.mbd2.common.machine.MBDMultiblockMachine;
import com.lowdragmc.mbd2.common.machine.definition.MultiblockMachineDefinition;
import com.lowdragmc.mbd2.utils.ControllerBlockInfo;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class MultiblockInWorldPreviewRenderer {
    private static final AtomicReference<Object> BUFFERS = new AtomicReference();
    @Nullable
    private static TrackedDummyWorld LEVEL = null;
    @Nullable
    private static Thread THREAD = null;
    @Nullable
    private static Set<BlockPos> BLOCK_ENTITIES;
    private static final AtomicInteger PREVIEW_LEFT_TICK;
    @Nullable
    private static BlockPos PATTERN_ERROR_POS;
    private static final AtomicInteger PATTERN_ERROR_LEFT_TICK;
    private static final AtomicReference<CacheState> CACHE_STATE;
    @Nullable
    private static BlockPos LAST_POS;
    private static int LAST_LAYER;

    private static VertexBuffer[] initBuffers() {
        List layers = RenderType.m_110506_();
        VertexBuffer[] buffers = new VertexBuffer[layers.size()];
        for (int j = 0; j < layers.size(); ++j) {
            buffers[j] = new VertexBuffer(VertexBuffer.Usage.STATIC);
        }
        return buffers;
    }

    public static void cleanPreview() {
        CACHE_STATE.set(CacheState.UNUSED);
        LEVEL = null;
        BLOCK_ENTITIES = null;
        PREVIEW_LEFT_TICK.set(-1);
        LAST_POS = null;
        LAST_LAYER = -1;
    }

    public static void removePreview(BlockPos pos) {
        if (LAST_POS != null && LAST_POS.equals((Object)pos)) {
            MultiblockInWorldPreviewRenderer.cleanPreview();
        }
    }

    public static void clearPatternError() {
        PATTERN_ERROR_POS = null;
        PATTERN_ERROR_LEFT_TICK.set(-1);
    }

    public static void showPatternErrorPos(BlockPos pos, int duration) {
        PATTERN_ERROR_POS = pos;
        PATTERN_ERROR_LEFT_TICK.set(duration);
    }

    public static void showPreview(BlockPos pos, MBDMultiblockMachine controller, int duration) {
        MultiblockMachineDefinition definition;
        MBDMachineBlock machineBlock;
        int z;
        BlockInfo[] column;
        int y;
        BlockInfo[][] aisle;
        int x;
        Direction front = controller.getFrontFacing().orElse(Direction.NORTH);
        MultiblockShapeInfo[] shapeInfos = controller.getDefinition().shapeInfoFactory().apply(controller.getDefinition());
        if (shapeInfos.length == 0) {
            return;
        }
        MultiblockShapeInfo shapeInfo = shapeInfos[0];
        HashMap<BlockPos, BlockInfo> blockMap = new HashMap<BlockPos, BlockInfo>();
        IMachine controllerBase = null;
        LEVEL = new TrackedDummyWorld();
        BlockInfo[][][] blocks = shapeInfo.getBlocks();
        BlockPos controllerPatternPos = null;
        Direction controllerPatternFront = Direction.NORTH;
        int maxY = 0;
        for (x = 0; x < blocks.length; ++x) {
            aisle = blocks[x];
            maxY = Math.max(maxY, aisle.length);
            for (y = 0; y < aisle.length; ++y) {
                column = aisle[y];
                for (z = 0; z < column.length; ++z) {
                    Object object;
                    BlockInfo blockInfo = column[z];
                    if (blockInfo instanceof ControllerBlockInfo) {
                        ControllerBlockInfo info = (ControllerBlockInfo)blockInfo;
                        controllerPatternPos = new BlockPos(x, y, z);
                        controllerPatternFront = info.getFacing();
                        continue;
                    }
                    BlockState blockState = column[z].getBlockState();
                    if (blockState == null || !((object = blockState.m_60734_()) instanceof MBDMachineBlock) || !((object = (machineBlock = (MBDMachineBlock)((Object)object)).getDefinition()) instanceof MultiblockMachineDefinition)) continue;
                    definition = (MultiblockMachineDefinition)object;
                    controllerPatternPos = new BlockPos(x, y, z);
                    if (!definition.blockProperties().rotationState().property.isPresent()) continue;
                    controllerPatternFront = (Direction)blockState.m_61143_((Property)definition.blockProperties().rotationState().property.get());
                }
            }
        }
        if (controllerPatternPos == null) {
            return;
        }
        if (LAST_POS != null && LAST_POS.equals((Object)pos)) {
            if (++LAST_LAYER >= maxY) {
                LAST_LAYER = -1;
            }
        } else {
            LAST_LAYER = -1;
        }
        LAST_POS = pos;
        for (x = 0; x < blocks.length; ++x) {
            aisle = blocks[x];
            for (y = 0; y < aisle.length; ++y) {
                column = aisle[y];
                if (LAST_LAYER != -1 && LAST_LAYER != y) continue;
                for (z = 0; z < column.length; ++z) {
                    IMachineBlockEntity holder;
                    BlockPos realPos;
                    Object object;
                    RotationState rotationState;
                    BlockState blockState = column[z].getBlockState();
                    BlockPos offset = new BlockPos(x, y, z).m_121996_((Vec3i)controllerPatternPos);
                    if (blockState == null || offset.equals((Object)new BlockPos(0, 0, 0))) continue;
                    offset = switch (controllerPatternFront) {
                        case Direction.SOUTH -> offset.m_7954_(Rotation.CLOCKWISE_180);
                        case Direction.EAST -> offset.m_7954_(Rotation.COUNTERCLOCKWISE_90);
                        case Direction.WEST -> offset.m_7954_(Rotation.CLOCKWISE_90);
                        default -> offset.m_7954_(Rotation.NONE);
                    };
                    offset = switch (front) {
                        case Direction.SOUTH -> offset.m_7954_(Rotation.CLOCKWISE_180);
                        case Direction.EAST -> offset.m_7954_(Rotation.COUNTERCLOCKWISE_90);
                        case Direction.WEST -> offset.m_7954_(Rotation.CLOCKWISE_90);
                        default -> offset.m_7954_(Rotation.NONE);
                    };
                    offset = MultiblockInWorldPreviewRenderer.rotateByFrontAxis(offset, front, Rotation.NONE);
                    definition = blockState.m_60734_();
                    if (definition instanceof MBDMachineBlock && (rotationState = (machineBlock = (MBDMachineBlock)((Object)definition)).getRotationState()) != RotationState.NONE && rotationState.property.isPresent()) {
                        Direction face = (Direction)blockState.m_61143_((Property)rotationState.property.get());
                        if (face.m_122434_() != Direction.Axis.Y) {
                            switch (front) {
                                default: {
                                    throw new IncompatibleClassChangeError();
                                }
                                case NORTH: 
                                case UP: 
                                case DOWN: {
                                    Direction direction = front;
                                    break;
                                }
                                case SOUTH: {
                                    Direction direction = face.m_122424_();
                                    break;
                                }
                                case WEST: {
                                    Direction direction = face.m_122428_();
                                    break;
                                }
                                case EAST: {
                                    Direction direction = face = face.m_122427_();
                                }
                            }
                        }
                        if (rotationState.test(face)) {
                            blockState = (BlockState)blockState.m_61124_((Property)rotationState.property.get(), (Comparable)face);
                        }
                    }
                    if ((object = column[z].getBlockEntity(realPos = pos.m_121955_((Vec3i)offset))) instanceof IMachineBlockEntity && (object = (holder = (IMachineBlockEntity)object).getMetaMachine()) instanceof IMultiController) {
                        IMultiController cont = (IMultiController)object;
                        holder.getSelf().m_142339_((Level)LEVEL);
                        controllerBase = cont;
                        continue;
                    }
                    blockMap.put(realPos, BlockInfo.fromBlockState((BlockState)blockState));
                }
            }
        }
        LEVEL.addBlocks(blockMap);
        if (controllerBase != null) {
            LEVEL.setInnerBlockEntity(controllerBase.getHolder());
        }
        MultiblockInWorldPreviewRenderer.prepareBuffers(LEVEL, blockMap.keySet(), duration);
    }

    private static BlockPos rotateByFrontAxis(BlockPos pos, Direction front, Rotation rotation) {
        if (front.m_122434_() == Direction.Axis.X) {
            return switch (rotation) {
                default -> new BlockPos(-pos.m_123341_(), pos.m_123342_(), -pos.m_123343_());
                case Rotation.CLOCKWISE_90 -> new BlockPos(-pos.m_123341_(), -front.m_122421_().m_122540_() * pos.m_123343_(), front.m_122421_().m_122540_() * -pos.m_123342_());
                case Rotation.CLOCKWISE_180 -> new BlockPos(-pos.m_123341_(), -pos.m_123342_(), pos.m_123343_());
                case Rotation.COUNTERCLOCKWISE_90 -> new BlockPos(-pos.m_123341_(), front.m_122421_().m_122540_() * pos.m_123343_(), front.m_122421_().m_122540_() * pos.m_123342_());
            };
        }
        if (front.m_122434_() == Direction.Axis.Y) {
            return switch (rotation) {
                default -> new BlockPos(-front.m_122421_().m_122540_() * pos.m_123341_(), -front.m_122421_().m_122540_() * pos.m_123343_(), -pos.m_123342_());
                case Rotation.CLOCKWISE_90 -> new BlockPos(pos.m_123342_(), -front.m_122421_().m_122540_() * pos.m_123343_(), -front.m_122421_().m_122540_() * pos.m_123341_());
                case Rotation.CLOCKWISE_180 -> new BlockPos(front.m_122421_().m_122540_() * pos.m_123341_(), -front.m_122421_().m_122540_() * pos.m_123343_(), pos.m_123342_());
                case Rotation.COUNTERCLOCKWISE_90 -> new BlockPos(-pos.m_123342_(), -front.m_122421_().m_122540_() * pos.m_123343_(), front.m_122421_().m_122540_() * pos.m_123341_());
            };
        }
        if (front.m_122434_() == Direction.Axis.Z) {
            return switch (rotation) {
                default -> pos;
                case Rotation.CLOCKWISE_90 -> new BlockPos(front.m_122421_().m_122540_() * pos.m_123342_(), -front.m_122421_().m_122540_() * pos.m_123341_(), pos.m_123343_());
                case Rotation.CLOCKWISE_180 -> new BlockPos(-pos.m_123341_(), -pos.m_123342_(), pos.m_123343_());
                case Rotation.COUNTERCLOCKWISE_90 -> new BlockPos(front.m_122421_().m_122540_() * -pos.m_123342_(), front.m_122421_().m_122540_() * pos.m_123341_(), pos.m_123343_());
            };
        }
        return pos;
    }

    public static void onClientTick() {
        if (PREVIEW_LEFT_TICK.get() > 0 && PREVIEW_LEFT_TICK.decrementAndGet() <= 0) {
            MultiblockInWorldPreviewRenderer.cleanPreview();
        }
        if (PATTERN_ERROR_LEFT_TICK.get() > 0 && PATTERN_ERROR_LEFT_TICK.decrementAndGet() <= 0) {
            MultiblockInWorldPreviewRenderer.clearPatternError();
        }
    }

    public static void renderInWorldPreview(PoseStack poseStack, Camera camera, float partialTicks) {
        Vec3 projectedView;
        if (PATTERN_ERROR_POS != null) {
            poseStack.m_85836_();
            projectedView = camera.m_90583_();
            poseStack.m_85837_(-projectedView.f_82479_, -projectedView.f_82480_, -projectedView.f_82481_);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderUtils.renderBlockOverLay((PoseStack)poseStack, (BlockPos)PATTERN_ERROR_POS, (float)0.6f, (float)0.0f, (float)0.0f, (float)1.01f);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            poseStack.m_85849_();
        }
        if (CACHE_STATE.get() == CacheState.COMPILED && LEVEL != null) {
            poseStack.m_85836_();
            projectedView = camera.m_90583_();
            poseStack.m_85837_(-projectedView.f_82479_, -projectedView.f_82480_, -projectedView.f_82481_);
            for (int i = 0; i < RenderType.m_110506_().size(); ++i) {
                VertexBuffer vertexbuffer = MultiblockInWorldPreviewRenderer.getBUFFERS()[i];
                if (vertexbuffer.m_231230_() || vertexbuffer.m_166892_() == null) continue;
                RenderType layer = (RenderType)RenderType.m_110506_().get(i);
                if (layer == RenderType.m_110466_() && BLOCK_ENTITIES != null) {
                    MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
                    for (BlockPos pos : BLOCK_ENTITIES) {
                        BlockEntity tile = LEVEL.m_7702_(pos);
                        if (tile == null) continue;
                        poseStack.m_85836_();
                        poseStack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
                        BlockEntityRenderer ber = Minecraft.m_91087_().m_167982_().m_112265_(tile);
                        if (ber != null && tile.m_58898_() && tile.m_58903_().m_155262_(tile.m_58900_())) {
                            ber.m_6922_(tile, partialTicks, poseStack, (MultiBufferSource)buffers, 0xF000F0, OverlayTexture.f_118083_);
                        }
                        poseStack.m_85849_();
                    }
                    buffers.m_109911_();
                }
                layer.m_110185_();
                poseStack.m_85836_();
                ShaderInstance shaderInstance = RenderSystem.getShader();
                for (int j = 0; j < 12; ++j) {
                    int k = RenderSystem.getShaderTexture((int)j);
                    shaderInstance.m_173350_("Sampler" + j, (Object)k);
                }
                if (shaderInstance.f_173308_ != null) {
                    shaderInstance.f_173308_.m_5679_(poseStack.m_85850_().m_252922_());
                }
                if (shaderInstance.f_173309_ != null) {
                    shaderInstance.f_173309_.m_5679_(RenderSystem.getProjectionMatrix());
                }
                if (shaderInstance.f_173312_ != null) {
                    shaderInstance.f_173312_.m_5941_(RenderSystem.getShaderColor());
                }
                if (shaderInstance.f_173315_ != null) {
                    shaderInstance.f_173315_.m_5985_(Float.MAX_VALUE);
                }
                if (shaderInstance.f_173316_ != null) {
                    shaderInstance.f_173316_.m_5985_(RenderSystem.getShaderFogEnd());
                }
                if (shaderInstance.f_173317_ != null) {
                    shaderInstance.f_173317_.m_5941_(RenderSystem.getShaderFogColor());
                }
                if (shaderInstance.f_202432_ != null) {
                    shaderInstance.f_202432_.m_142617_(RenderSystem.getShaderFogShape().m_202324_());
                }
                if (shaderInstance.f_173310_ != null) {
                    shaderInstance.f_173310_.m_5679_(RenderSystem.getTextureMatrix());
                }
                if (shaderInstance.f_173319_ != null) {
                    shaderInstance.f_173319_.m_5985_(RenderSystem.getShaderGameTime());
                }
                RenderSystem.setupShaderLights((ShaderInstance)shaderInstance);
                shaderInstance.m_173363_();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (layer == RenderType.m_110466_()) {
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc((int)770, (int)771);
                    RenderSystem.depthMask((boolean)false);
                } else {
                    RenderSystem.enableDepthTest();
                    RenderSystem.disableBlend();
                    RenderSystem.depthMask((boolean)true);
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                vertexbuffer.m_85921_();
                vertexbuffer.m_166882_();
                poseStack.m_85849_();
                shaderInstance.m_173362_();
                VertexBuffer.m_85931_();
                layer.m_110188_();
            }
            poseStack.m_85849_();
        }
    }

    private static void prepareBuffers(TrackedDummyWorld level, Collection<BlockPos> renderedBlocks, int duration) {
        if (THREAD != null) {
            THREAD.interrupt();
        }
        CACHE_STATE.set(CacheState.COMPILING);
        MultiblockInWorldPreviewRenderer.getBUFFERS();
        THREAD = new Thread(() -> {
            BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
            ModelBlockRenderer.m_111000_();
            PoseStack poseStack = new PoseStack();
            for (int i = 0; i < RenderType.m_110506_().size(); ++i) {
                if (Thread.interrupted()) {
                    return;
                }
                RenderType layer = (RenderType)RenderType.m_110506_().get(i);
                BufferBuilder buffer = new BufferBuilder(layer.m_110507_());
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
                MultiblockInWorldPreviewRenderer.renderBlocks(level, poseStack, dispatcher, layer, new WorldSceneRenderer.VertexConsumerWrapper((VertexConsumer)buffer), renderedBlocks);
                BufferBuilder.RenderedBuffer builder = buffer.m_231175_();
                VertexBuffer vertexBuffer = MultiblockInWorldPreviewRenderer.getBUFFERS()[i];
                Runnable toUpload = () -> {
                    if (!vertexBuffer.m_231230_()) {
                        vertexBuffer.m_85921_();
                        vertexBuffer.m_231221_(builder);
                        VertexBuffer.m_85931_();
                    }
                };
                CompletableFuture.runAsync(toUpload, runnable -> RenderSystem.recordRenderCall(runnable::run));
            }
            ModelBlockRenderer.m_111077_();
            HashSet<BlockPos> poses = new HashSet<BlockPos>();
            for (BlockPos pos : renderedBlocks) {
                if (Thread.interrupted()) {
                    return;
                }
                BlockEntity tile = level.m_7702_(pos);
                if (tile == null || Minecraft.m_91087_().m_167982_().m_112265_(tile) == null) continue;
                poses.add(pos);
            }
            if (Thread.interrupted()) {
                return;
            }
            BLOCK_ENTITIES = poses;
            CACHE_STATE.set(CacheState.COMPILED);
            THREAD = null;
            PREVIEW_LEFT_TICK.set(duration);
        });
        THREAD.start();
    }

    private static void renderBlocks(TrackedDummyWorld level, PoseStack poseStack, BlockRenderDispatcher dispatcher, RenderType layer, WorldSceneRenderer.VertexConsumerWrapper wrapperBuffer, Collection<BlockPos> renderedBlocks) {
        for (BlockPos pos : renderedBlocks) {
            BlockState state = level.m_8055_(pos);
            FluidState fluidState = state.m_60819_();
            Block block = state.m_60734_();
            BlockEntity te = level.m_7702_(pos);
            if (block == Blocks.f_50016_) continue;
            if (state.m_60799_() != RenderShape.INVISIBLE && ItemBlockRenderTypes.getRenderLayers((BlockState)state).contains(layer)) {
                poseStack.m_85836_();
                poseStack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
                poseStack.m_85837_(0.5, 0.5, 0.5);
                poseStack.m_85841_(0.8f, 0.8f, 0.8f);
                poseStack.m_85837_(-0.5, -0.5, -0.5);
                level.setRenderFilter(p -> p.equals((Object)pos));
                WorldSceneRendererImpl.renderBlocksForge((BlockRenderDispatcher)dispatcher, (BlockState)state, (BlockPos)pos, (BlockAndTintGetter)level, (PoseStack)poseStack, (VertexConsumer)wrapperBuffer, (RandomSource)level.f_46441_, (RenderType)layer);
                level.setRenderFilter(p -> true);
                poseStack.m_85849_();
            }
            if (!fluidState.m_76178_() && ItemBlockRenderTypes.m_109287_((FluidState)fluidState) == layer) {
                wrapperBuffer.addOffset((double)(pos.m_123341_() - (pos.m_123341_() & 0xF)), (double)(pos.m_123342_() - (pos.m_123342_() & 0xF)), (double)(pos.m_123343_() - (pos.m_123343_() & 0xF)));
                dispatcher.m_234363_(pos, (BlockAndTintGetter)level, (VertexConsumer)wrapperBuffer, state, fluidState);
            }
            wrapperBuffer.clerOffset();
            wrapperBuffer.clearColor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VertexBuffer[] getBUFFERS() {
        VertexBuffer[] value = BUFFERS.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = BUFFERS;
            synchronized (atomicReference) {
                value = BUFFERS.get();
                if (value == null) {
                    VertexBuffer[] actualValue = MultiblockInWorldPreviewRenderer.initBuffers();
                    value = actualValue == null ? BUFFERS : actualValue;
                    BUFFERS.set(value);
                }
            }
        }
        return value == BUFFERS ? null : value;
    }

    static {
        PREVIEW_LEFT_TICK = new AtomicInteger(-1);
        PATTERN_ERROR_POS = null;
        PATTERN_ERROR_LEFT_TICK = new AtomicInteger(-1);
        CACHE_STATE = new AtomicReference<CacheState>(CacheState.UNUSED);
        LAST_POS = null;
        LAST_LAYER = -1;
    }

    private static enum CacheState {
        UNUSED,
        COMPILING,
        COMPILED;

    }
}

