/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.recipe;

import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.MBDRecipeSerializer;
import com.lowdragmc.mbd2.api.recipe.MBDRecipeType;
import com.lowdragmc.mbd2.api.recipe.RecipeCondition;
import com.lowdragmc.mbd2.api.recipe.content.Content;
import com.lowdragmc.mbd2.api.recipe.ingredient.FluidIngredient;
import com.lowdragmc.mbd2.api.recipe.ingredient.SizedIngredient;
import com.lowdragmc.mbd2.common.capability.recipe.FluidRecipeCapability;
import com.lowdragmc.mbd2.common.capability.recipe.ItemRecipeCapability;
import com.lowdragmc.mbd2.common.recipe.BiomeCondition;
import com.lowdragmc.mbd2.common.recipe.DimensionCondition;
import com.lowdragmc.mbd2.common.recipe.PositionYCondition;
import com.lowdragmc.mbd2.common.recipe.RainingCondition;
import com.lowdragmc.mbd2.common.recipe.ThunderCondition;
import com.lowdragmc.mbd2.utils.TagUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MBDRecipeBuilder {
    public final Map<RecipeCapability<?>, List<Content>> input = new HashMap();
    public final Map<RecipeCapability<?>, List<Content>> output = new HashMap();
    public CompoundTag data = new CompoundTag();
    public final List<RecipeCondition> conditions = new ArrayList<RecipeCondition>();
    public ResourceLocation id;
    public MBDRecipeType recipeType;
    public int duration = 100;
    public boolean perTick;
    public String slotName;
    public String uiName;
    public float chance = 1.0f;
    public float tierChanceBoost = 0.0f;
    public boolean isFuel = false;
    public int priority = 0;
    public BiConsumer<MBDRecipeBuilder, Consumer<FinishedRecipe>> onSave;

    public MBDRecipeBuilder(ResourceLocation id, MBDRecipeType recipeType) {
        this.id = id;
        this.recipeType = recipeType;
    }

    public MBDRecipeBuilder(MBDRecipe toCopy, MBDRecipeType recipeType) {
        this.id = toCopy.id;
        this.recipeType = recipeType;
        toCopy.inputs.forEach((k, v) -> this.input.put((RecipeCapability<?>)k, new ArrayList(v)));
        toCopy.outputs.forEach((k, v) -> this.output.put((RecipeCapability<?>)k, new ArrayList(v)));
        this.conditions.addAll(toCopy.conditions);
        this.data = toCopy.data.m_6426_();
        this.duration = toCopy.duration;
        this.isFuel = toCopy.isFuel;
    }

    public static MBDRecipeBuilder of(ResourceLocation id, MBDRecipeType recipeType) {
        return new MBDRecipeBuilder(id, recipeType);
    }

    public static MBDRecipeBuilder ofRaw() {
        return new MBDRecipeBuilder(MBD2.id("raw"), null);
    }

    public MBDRecipeBuilder copy(String id) {
        return this.copy(MBD2.id(id));
    }

    public MBDRecipeBuilder copy(ResourceLocation id) {
        MBDRecipeBuilder copy = new MBDRecipeBuilder(id, this.recipeType);
        this.input.forEach((k, v) -> copy.input.put((RecipeCapability<?>)k, new ArrayList(v)));
        this.output.forEach((k, v) -> copy.output.put((RecipeCapability<?>)k, new ArrayList(v)));
        copy.conditions.addAll(this.conditions);
        copy.data = this.data.m_6426_();
        copy.duration = this.duration;
        copy.chance = this.chance;
        copy.perTick = this.perTick;
        copy.isFuel = this.isFuel;
        copy.uiName = this.uiName;
        copy.slotName = this.slotName;
        copy.onSave = this.onSave;
        return copy;
    }

    public MBDRecipeBuilder copyFrom(MBDRecipeBuilder builder) {
        return builder.copy(builder.id).onSave(null).recipeType(this.recipeType);
    }

    public <T> MBDRecipeBuilder input(RecipeCapability<T> capability, T ... obj) {
        this.input.computeIfAbsent(capability, c -> new ArrayList()).addAll(Arrays.stream(obj).map(capability::of).map(o -> new Content(o, this.perTick, this.chance, this.tierChanceBoost, this.slotName, this.uiName)).toList());
        return this;
    }

    public <T> MBDRecipeBuilder output(RecipeCapability<T> capability, T ... obj) {
        this.output.computeIfAbsent(capability, c -> new ArrayList()).addAll(Arrays.stream(obj).map(capability::of).map(o -> new Content(o, this.perTick, this.chance, this.tierChanceBoost, this.slotName, this.uiName)).toList());
        return this;
    }

    public <T> MBDRecipeBuilder removeInputs(RecipeCapability<T> capability) {
        this.input.remove(capability);
        return this;
    }

    public <T> MBDRecipeBuilder removeOutputs(RecipeCapability<T> capability) {
        this.output.remove(capability);
        return this;
    }

    public <T> MBDRecipeBuilder inputs(RecipeCapability<T> capability, Object ... obj) {
        this.input.computeIfAbsent(capability, c -> new ArrayList()).addAll(Arrays.stream(obj).map(capability::of).map(o -> new Content(o, this.perTick, this.chance, this.tierChanceBoost, this.slotName, this.uiName)).toList());
        return this;
    }

    public <T> MBDRecipeBuilder outputs(RecipeCapability<T> capability, Object ... obj) {
        this.output.computeIfAbsent(capability, c -> new ArrayList()).addAll(Arrays.stream(obj).map(capability::of).map(o -> new Content(o, this.perTick, this.chance, this.tierChanceBoost, this.slotName, this.uiName)).toList());
        return this;
    }

    public MBDRecipeBuilder addCondition(RecipeCondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public MBDRecipeBuilder inputItems(Ingredient ... inputs) {
        return this.input(ItemRecipeCapability.CAP, inputs);
    }

    public MBDRecipeBuilder inputItems(ItemStack ... inputs) {
        for (ItemStack itemStack : inputs) {
            if (!itemStack.m_41619_()) continue;
            LDLib.LOGGER.error("gt recipe {} input items is empty", (Object)this.id);
            throw new IllegalArgumentException(String.valueOf(this.id) + ": input items is empty");
        }
        return this.input(ItemRecipeCapability.CAP, (Ingredient[])Arrays.stream(inputs).map(SizedIngredient::create).toArray(Ingredient[]::new));
    }

    public MBDRecipeBuilder inputItems(TagKey<Item> tag, int amount) {
        return this.inputItems(SizedIngredient.create(tag, amount));
    }

    public MBDRecipeBuilder inputItems(TagKey<Item> tag) {
        return this.inputItems(tag, 1);
    }

    public MBDRecipeBuilder inputItems(Item input, int amount) {
        return this.inputItems(new ItemStack((ItemLike)input, amount));
    }

    public MBDRecipeBuilder inputItems(Item input) {
        return this.inputItems(SizedIngredient.create(new ItemStack((ItemLike)input)));
    }

    public MBDRecipeBuilder inputItems(Supplier<? extends Item> input) {
        return this.inputItems(input.get());
    }

    public MBDRecipeBuilder inputItems(Supplier<? extends Item> input, int amount) {
        return this.inputItems(new ItemStack((ItemLike)input.get(), amount));
    }

    public MBDRecipeBuilder itemOutputs(ItemStack ... outputs) {
        return this.outputItems(outputs);
    }

    public MBDRecipeBuilder outputItems(ItemStack ... outputs) {
        for (ItemStack itemStack : outputs) {
            if (!itemStack.m_41619_()) continue;
            LDLib.LOGGER.error("gt recipe {} output items is empty", (Object)this.id);
            throw new IllegalArgumentException(String.valueOf(this.id) + ": output items is empty");
        }
        return this.output(ItemRecipeCapability.CAP, (Ingredient[])Arrays.stream(outputs).map(SizedIngredient::create).toArray(Ingredient[]::new));
    }

    public MBDRecipeBuilder outputItems(Item input, int amount) {
        return this.outputItems(new ItemStack((ItemLike)input, amount));
    }

    public MBDRecipeBuilder outputItems(Item input) {
        return this.outputItems(new ItemStack((ItemLike)input));
    }

    public MBDRecipeBuilder outputItems(Supplier<? extends ItemLike> input) {
        return this.outputItems(new ItemStack((ItemLike)input.get().m_5456_()));
    }

    public MBDRecipeBuilder outputItems(Supplier<? extends ItemLike> input, int amount) {
        return this.outputItems(new ItemStack((ItemLike)input.get().m_5456_(), amount));
    }

    public MBDRecipeBuilder notConsumable(ItemStack itemStack) {
        float lastChance = this.chance;
        this.chance = 0.0f;
        this.inputItems(itemStack);
        this.chance = lastChance;
        return this;
    }

    public MBDRecipeBuilder notConsumable(Item item) {
        float lastChance = this.chance;
        this.chance = 0.0f;
        this.inputItems(item);
        this.chance = lastChance;
        return this;
    }

    public MBDRecipeBuilder notConsumable(Supplier<? extends Item> item) {
        float lastChance = this.chance;
        this.chance = 0.0f;
        this.inputItems(item);
        this.chance = lastChance;
        return this;
    }

    public MBDRecipeBuilder inputFluids(FluidStack ... inputs) {
        return this.input(FluidRecipeCapability.CAP, (FluidIngredient[])Arrays.stream(inputs).map(fluid -> {
            if (!Platform.isForge() && fluid.getFluid() == Fluids.f_76193_) {
                return FluidIngredient.of(fluid);
            }
            return FluidIngredient.of(TagUtil.createFluidTag(BuiltInRegistries.f_257020_.m_7981_((Object)fluid.getFluid()).m_135815_()), fluid.getAmount());
        }).toArray(FluidIngredient[]::new));
    }

    public MBDRecipeBuilder inputFluids(FluidIngredient ... inputs) {
        return this.input(FluidRecipeCapability.CAP, inputs);
    }

    public MBDRecipeBuilder outputFluids(FluidStack ... outputs) {
        return this.output(FluidRecipeCapability.CAP, (FluidIngredient[])Arrays.stream(outputs).map(xva$0 -> FluidIngredient.of(xva$0)).toArray(FluidIngredient[]::new));
    }

    public MBDRecipeBuilder outputFluids(FluidIngredient ... outputs) {
        return this.output(FluidRecipeCapability.CAP, outputs);
    }

    public MBDRecipeBuilder addData(String key, Tag data) {
        this.data.m_128365_(key, data);
        return this;
    }

    public MBDRecipeBuilder addData(String key, int data) {
        this.data.m_128405_(key, data);
        return this;
    }

    public MBDRecipeBuilder addData(String key, long data) {
        this.data.m_128356_(key, data);
        return this;
    }

    public MBDRecipeBuilder addData(String key, String data) {
        this.data.m_128359_(key, data);
        return this;
    }

    public MBDRecipeBuilder addData(String key, Float data) {
        this.data.m_128350_(key, data.floatValue());
        return this;
    }

    public MBDRecipeBuilder addData(String key, boolean data) {
        this.data.m_128379_(key, data);
        return this;
    }

    public MBDRecipeBuilder blastFurnaceTemp(int blastTemp) {
        return this.addData("ebf_temp", blastTemp);
    }

    public MBDRecipeBuilder explosivesAmount(int explosivesAmount) {
        return this.addData("explosives_amount", explosivesAmount);
    }

    public MBDRecipeBuilder explosivesType(ItemStack explosivesType) {
        return this.addData("explosives_type", (Tag)explosivesType.m_41739_(new CompoundTag()));
    }

    public MBDRecipeBuilder solderMultiplier(int multiplier) {
        return this.addData("solderMultiplier", multiplier);
    }

    public MBDRecipeBuilder disableDistilleryRecipes(boolean flag) {
        return this.addData("disable_distillery", flag);
    }

    public MBDRecipeBuilder fusionStartEU(long eu) {
        return this.addData("eu_to_start", eu);
    }

    public MBDRecipeBuilder dimension(ResourceLocation dimension, boolean reverse) {
        return this.addCondition(new DimensionCondition(dimension).setReverse(reverse));
    }

    public MBDRecipeBuilder dimension(ResourceLocation dimension) {
        return this.dimension(dimension, false);
    }

    public MBDRecipeBuilder biome(ResourceLocation biome, boolean reverse) {
        return this.addCondition(new BiomeCondition(biome).setReverse(reverse));
    }

    public MBDRecipeBuilder biome(ResourceLocation biome) {
        return this.biome(biome, false);
    }

    public MBDRecipeBuilder rain(float minLevel, float maxLevel, boolean reverse) {
        return this.addCondition(new RainingCondition(minLevel, maxLevel).setReverse(reverse));
    }

    public MBDRecipeBuilder rain(float minLevel, float maxLevel) {
        return this.rain(minLevel, maxLevel, false);
    }

    public MBDRecipeBuilder thunder(float minLevel, float maxLevel, boolean reverse) {
        return this.addCondition(new ThunderCondition(minLevel, maxLevel).setReverse(reverse));
    }

    public MBDRecipeBuilder thunder(float minLevel, float maxLevel) {
        return this.thunder(minLevel, maxLevel, false);
    }

    public MBDRecipeBuilder posY(int min, int max, boolean reverse) {
        return this.addCondition(new PositionYCondition(min, max).setReverse(reverse));
    }

    public MBDRecipeBuilder posY(int min, int max) {
        return this.posY(min, max, false);
    }

    public FinishedRecipe build() {
        return new FinishedRecipe(){

            public void m_7917_(JsonObject pJson) {
                MBDRecipeSerializer.SERIALIZER.toJson(MBDRecipeBuilder.this.buildRawRecipe());
            }

            public ResourceLocation m_6445_() {
                return new ResourceLocation(MBDRecipeBuilder.this.id.m_135827_(), MBDRecipeBuilder.this.recipeType.getRegistryName().m_135815_() + "/" + MBDRecipeBuilder.this.id.m_135815_());
            }

            public RecipeSerializer<?> m_6637_() {
                return MBDRecipeSerializer.SERIALIZER;
            }

            @Nullable
            public JsonObject m_5860_() {
                return null;
            }

            @Nullable
            public ResourceLocation m_6448_() {
                return null;
            }
        };
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        if (this.onSave != null) {
            this.onSave.accept(this, consumer);
        }
        consumer.accept(this.build());
    }

    public MBDRecipe saveAsBuiltinRecipe() {
        MBDRecipe recipe = this.buildRawRecipe();
        this.recipeType.builtinRecipes.put(this.id, recipe);
        return recipe;
    }

    public MBDRecipe buildRawRecipe() {
        return new MBDRecipe(this.recipeType, this.id, this.input, this.output, this.conditions, this.data, this.duration, this.isFuel, this.priority);
    }

    public MBDRecipeBuilder id(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public MBDRecipeBuilder recipeType(MBDRecipeType recipeType) {
        this.recipeType = recipeType;
        return this;
    }

    public MBDRecipeBuilder duration(int duration) {
        this.duration = duration;
        return this;
    }

    public MBDRecipeBuilder perTick(boolean perTick) {
        this.perTick = perTick;
        return this;
    }

    public MBDRecipeBuilder slotName(String slotName) {
        this.slotName = slotName;
        return this;
    }

    public MBDRecipeBuilder uiName(String uiName) {
        this.uiName = uiName;
        return this;
    }

    public MBDRecipeBuilder chance(float chance) {
        this.chance = chance;
        return this;
    }

    public MBDRecipeBuilder tierChanceBoost(float tierChanceBoost) {
        this.tierChanceBoost = tierChanceBoost;
        return this;
    }

    public MBDRecipeBuilder isFuel(boolean isFuel) {
        this.isFuel = isFuel;
        return this;
    }

    public MBDRecipeBuilder priority(int priority) {
        this.priority = priority;
        return this;
    }

    public MBDRecipeBuilder onSave(BiConsumer<MBDRecipeBuilder, Consumer<FinishedRecipe>> onSave) {
        this.onSave = onSave;
        return this;
    }
}

