/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.pattern.error;

import com.lowdragmc.mbd2.api.pattern.MultiblockState;
import com.lowdragmc.mbd2.api.pattern.TraceabilityPredicate;
import com.lowdragmc.mbd2.api.pattern.predicates.SimplePredicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PatternError {
    protected MultiblockState worldState;

    public void setWorldState(MultiblockState worldState) {
        this.worldState = worldState;
    }

    public Level getWorld() {
        return this.worldState.getWorld();
    }

    public BlockPos getPos() {
        return this.worldState.getPos();
    }

    public List<List<ItemStack>> getCandidates() {
        TraceabilityPredicate predicate = this.worldState.predicate;
        ArrayList<List<ItemStack>> candidates = new ArrayList<List<ItemStack>>();
        for (SimplePredicate common : predicate.common) {
            candidates.add(common.getCandidates());
        }
        for (SimplePredicate limited : predicate.limited) {
            candidates.add(limited.getCandidates());
        }
        return candidates;
    }

    public Component getErrorInfo() {
        List<List<ItemStack>> candidates = this.getCandidates();
        MutableComponent items = Component.m_237119_();
        for (List<ItemStack> candidate : candidates) {
            if (candidate.isEmpty()) continue;
            items.m_7220_(candidate.get(0).m_41611_());
            items.m_7220_((Component)Component.m_237113_((String)", "));
        }
        return Component.m_237110_((String)"mbd2.multiblock.pattern.error", (Object[])new Object[]{items, this.worldState.getPos()});
    }
}

