/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.machine;

import com.lowdragmc.mbd2.api.capability.MBDCapabilities;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeCapabilityHolder;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.MBDRecipeType;
import com.lowdragmc.mbd2.api.recipe.RecipeLogic;
import com.lowdragmc.mbd2.api.recipe.content.ContentModifier;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface IMachine
extends IRecipeCapabilityHolder {
    public static Optional<IMachine> ofMachine(@Nullable BlockEntity blockEntity) {
        return blockEntity == null ? Optional.empty() : blockEntity.getCapability(MBDCapabilities.CAPABILITY_MACHINE).resolve();
    }

    public static Optional<IMachine> ofMachine(@Nonnull BlockGetter level, @Nonnull BlockPos pos) {
        return IMachine.ofMachine(level.m_7702_(pos));
    }

    public BlockEntity getHolder();

    default public Level getLevel() {
        return this.getHolder().m_58904_();
    }

    default public BlockPos getPos() {
        return this.getHolder().m_58899_();
    }

    default public BlockState getBlockState() {
        return this.getHolder().m_58900_();
    }

    public long getOffset();

    default public long getOffsetTimer() {
        Level level = this.getLevel();
        return level == null ? this.getOffset() : level.m_46467_() + this.getOffset();
    }

    default public void markDirty() {
        Level level = this.getLevel();
        if (level != null && !level.f_46443_ && level.m_7654_() != null) {
            level.m_7654_().execute(() -> this.getHolder().m_6596_());
        }
    }

    default public boolean isInValid() {
        return this.getHolder().m_58901_();
    }

    default public void saveCustomPersistedData(CompoundTag tag, boolean forDrop) {
    }

    default public void loadCustomPersistedData(CompoundTag tag) {
    }

    public Optional<Direction> getFrontFacing();

    default public boolean hasFrontFacing() {
        return this.getFrontFacing().isPresent();
    }

    public boolean isFacingValid(Direction var1);

    public void setFrontFacing(Direction var1);

    default public void onRotated(Direction oldFacing, Direction newFacing) {
    }

    default public void scheduleRenderUpdate() {
        BlockPos pos = this.getPos();
        Level level = this.getLevel();
        if (level != null) {
            BlockState state = level.m_8055_(pos);
            if (level.f_46443_) {
                level.m_7260_(pos, state, state, 8);
            }
        }
    }

    default public void notifyBlockUpdate() {
        BlockPos pos = this.getPos();
        Level level = this.getLevel();
        if (level != null) {
            level.m_46672_(pos, level.m_8055_(pos).m_60734_());
        }
    }

    default public void onChunkUnloaded() {
        this.getRecipeLogic().inValid();
    }

    default public void onUnload() {
        this.getRecipeLogic().inValid();
    }

    default public void onLoad() {
    }

    @Nonnull
    public MBDRecipeType getRecipeType();

    default public void notifyRecipeStatusChanged(RecipeLogic.Status oldStatus, RecipeLogic.Status newStatus) {
    }

    default public boolean runRecipeLogic() {
        return this.getRecipeType() != MBDRecipeType.DUMMY;
    }

    @Nonnull
    public RecipeLogic getRecipeLogic();

    @Nullable
    default public MBDRecipe modifyFuelRecipe(MBDRecipe recipe) {
        return recipe;
    }

    default public void onFuelBurningFinish(@Nullable MBDRecipe recipe) {
    }

    @Nullable
    default public MBDRecipe doModifyRecipe(@Nonnull MBDRecipe recipe) {
        if ((recipe = this.getModifiedRecipe(recipe)) == null) {
            return null;
        }
        return this.applyParallel(recipe, this.getMaxParallel(recipe).apply(1).intValue());
    }

    @Nullable
    default public MBDRecipe getModifiedRecipe(@Nonnull MBDRecipe recipe) {
        return recipe;
    }

    default public ContentModifier getMaxParallel(@Nonnull MBDRecipe recipe) {
        return ContentModifier.IDENTITY;
    }

    @Nonnull
    default public MBDRecipe applyParallel(@Nonnull MBDRecipe recipe, int maxParallel) {
        if (maxParallel > 1) {
            Pair<MBDRecipe, Integer> result = MBDRecipe.accurateParallel(this, recipe, maxParallel, false);
            return (MBDRecipe)result.getFirst();
        }
        return recipe;
    }

    default public boolean beforeWorking(MBDRecipe recipe) {
        return false;
    }

    default public boolean onWorking() {
        return false;
    }

    default public void onWaiting() {
    }

    default public void afterWorking() {
    }

    default public boolean dampingWhenWaiting() {
        return true;
    }

    default public boolean alwaysTryModifyRecipe() {
        return false;
    }

    default public boolean alwaysReSearchRecipe() {
        return false;
    }

    default public int getRecipeDampingValue() {
        return 2;
    }

    default public boolean consumeInputsAfterWorking(MBDRecipe recipe) {
        return false;
    }

    default public int getMachineLevel() {
        return 0;
    }

    @Override
    default public int getChanceTier() {
        return this.getMachineLevel();
    }
}

