/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.forge.inventory.energy;

import net.creeperhost.polylib.inventory.energy.PlatformItemEnergyManager;
import net.creeperhost.polylib.inventory.item.ItemStackHolder;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;

public record ForgeItemEnergyManager(IEnergyStorage energy) implements PlatformItemEnergyManager
{
    public ForgeItemEnergyManager(CapabilityProvider<?> energyItem) {
        this((IEnergyStorage)energyItem.getCapability(ForgeCapabilities.ENERGY).orElseThrow(IllegalArgumentException::new));
    }

    @Override
    public long getStoredEnergy() {
        return this.energy.getEnergyStored();
    }

    @Override
    public long getCapacity() {
        return this.energy.getMaxEnergyStored();
    }

    @Override
    public long extract(ItemStackHolder holder, long amount, boolean simulate) {
        return this.energy.extractEnergy((int)amount, simulate);
    }

    @Override
    public long insert(ItemStackHolder holder, long amount, boolean simulate) {
        return this.energy.receiveEnergy((int)amount, simulate);
    }

    @Override
    public boolean supportsInsertion() {
        return this.energy.canReceive();
    }

    @Override
    public boolean supportsExtraction() {
        return this.energy.canExtract();
    }
}

