/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.fastener;

import java.util.ConcurrentModificationException;
import java.util.Set;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.fastener.Fastener;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.Event;

public class CollectFastenersEvent
extends Event {
    private final Level world;
    private final AABB region;
    private final Set<Fastener<?>> fasteners;

    public CollectFastenersEvent(Level world, AABB region, Set<Fastener<?>> fasteners) {
        this.world = world;
        this.region = region;
        this.fasteners = fasteners;
    }

    public Level getWorld() {
        return this.world;
    }

    public AABB getRegion() {
        return this.region;
    }

    public void accept(LevelChunk chunk) {
        try {
            for (BlockEntity entity : chunk.m_62954_().values()) {
                this.accept((ICapabilityProvider)entity);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    public void accept(ICapabilityProvider provider) {
        provider.getCapability(CapabilityHandler.FASTENER_CAP).ifPresent(this::accept);
    }

    public void accept(Fastener<?> fastener) {
        if (this.region.m_82390_(fastener.getConnectionPoint())) {
            this.fasteners.add(fastener);
        }
    }
}

