/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.common.inventory;

import cofh.lib.api.IStorageCallback;
import cofh.lib.api.StorageGroup;
import cofh.lib.common.inventory.IOItemHandler;
import cofh.lib.common.inventory.ItemStorageCoFH;
import cofh.lib.common.inventory.SimpleItemHandler;
import cofh.lib.common.inventory.SimpleItemInv;
import cofh.lib.util.Constants;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class IOItemInv
extends SimpleItemInv {
    protected List<ItemStorageCoFH> accessibleSlots = new ArrayList<ItemStorageCoFH>();
    protected List<ItemStorageCoFH> internalSlots = new ArrayList<ItemStorageCoFH>();
    protected IOItemHandler outputHandler;
    protected IOItemHandler inputHandler;
    protected IItemHandler internalHandler;

    public IOItemInv(@Nullable IStorageCallback callback) {
        super(callback);
    }

    public IOItemInv(IStorageCallback callback, String tag) {
        super(callback, tag);
    }

    public void addSlot(ItemStorageCoFH slot, StorageGroup group) {
        if (this.allHandler != null) {
            return;
        }
        this.slots.add(slot);
        switch (group) {
            case INTERNAL: {
                this.internalSlots.add(slot);
                break;
            }
            case ACCESSIBLE: {
                this.accessibleSlots.add(slot);
                break;
            }
        }
    }

    public void setConditions(Supplier<Boolean> allowInsert, Supplier<Boolean> allowExtract) {
        this.outputHandler.setConditions(Constants.FALSE, allowExtract);
        this.inputHandler.setConditions(allowInsert, Constants.FALSE);
    }

    public void initHandlers() {
        ((ArrayList)this.slots).trimToSize();
        ((ArrayList)this.accessibleSlots).trimToSize();
        ((ArrayList)this.internalSlots).trimToSize();
        this.outputHandler = new IOItemHandler(this.callback, this.accessibleSlots);
        this.inputHandler = new IOItemHandler(this.callback, this.accessibleSlots);
        this.internalHandler = new SimpleItemHandler(this.callback, this.internalSlots);
        this.allHandler = new SimpleItemHandler(this.callback, this.slots);
    }

    public boolean isBufferEmpty() {
        for (ItemStorageCoFH slot : this.accessibleSlots) {
            if (slot.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isBufferFull() {
        for (ItemStorageCoFH slot : this.accessibleSlots) {
            if (slot.isFull()) continue;
            return false;
        }
        return true;
    }

    public boolean isConfigEmpty() {
        for (ItemStorageCoFH slot : this.internalSlots) {
            if (slot.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isConfigFull() {
        for (ItemStorageCoFH slot : this.internalSlots) {
            if (slot.isFull()) continue;
            return false;
        }
        return true;
    }

    public List<ItemStorageCoFH> getAccessibleSlots() {
        return this.accessibleSlots;
    }

    public List<ItemStorageCoFH> getInternalSlots() {
        return this.internalSlots;
    }

    @Override
    public IItemHandler getHandler(StorageGroup group) {
        if (this.allHandler == null) {
            this.initHandlers();
        }
        switch (group) {
            case INPUT: {
                return this.inputHandler;
            }
            case OUTPUT: {
                return this.outputHandler;
            }
            case INTERNAL: {
                return this.internalHandler;
            }
            case ALL: {
                return this.allHandler;
            }
        }
        return EmptyHandler.INSTANCE;
    }
}

