/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fluid.texture;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.mantle.fluid.texture.FluidTexture;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.mantle.util.JsonHelper;

public abstract class AbstractFluidTextureProvider
extends GenericDataProvider {
    private final Map<FluidType, FluidTexture.Builder> allTextures = new HashMap<FluidType, FluidTexture.Builder>();
    private final Set<FluidType> ignore = new HashSet<FluidType>();
    @Nullable
    private final String modId;

    public AbstractFluidTextureProvider(PackOutput packOutput, @Nullable String modId) {
        super(packOutput, PackOutput.Target.RESOURCE_PACK, "mantle/fluid_texture", JsonHelper.DEFAULT_GSON);
        this.modId = modId;
    }

    public final CompletableFuture<?> m_213708_(CachedOutput cache) {
        List<String> missing;
        this.addTextures();
        IForgeRegistry fluidTypeRegistry = (IForgeRegistry)ForgeRegistries.FLUID_TYPES.get();
        if (this.modId != null && !(missing = fluidTypeRegistry.getEntries().stream().filter(entry -> ((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals(this.modId) && !this.allTextures.containsKey(entry.getValue()) && !this.ignore.contains(entry.getValue())).map(e -> ((ResourceKey)e.getKey()).m_135782_().toString()).toList()).isEmpty()) {
            throw new IllegalStateException("Missing fluid textures for: " + String.join((CharSequence)", ", missing));
        }
        return AbstractFluidTextureProvider.allOf(this.allTextures.entrySet().stream().map(entry -> this.saveJson(cache, Objects.requireNonNull(fluidTypeRegistry.getKey((Object)((FluidType)entry.getKey()))), ((FluidTexture.Builder)entry.getValue()).build().serialize())));
    }

    public abstract void addTextures();

    public FluidTexture.Builder texture(FluidType fluid) {
        return this.allTextures.computeIfAbsent(fluid, FluidTexture.Builder::new);
    }

    public FluidTexture.Builder texture(FluidObject<?> fluid) {
        return this.texture(fluid.getType());
    }

    public FluidTexture.Builder texture(RegistryObject<? extends FluidType> fluid) {
        return this.texture((FluidType)fluid.get());
    }

    public void skip(FluidType fluid) {
        this.ignore.add(fluid);
    }

    public void skip(FluidObject<?> fluid) {
        this.skip(fluid.getType());
    }

    public void skip(RegistryObject<? extends FluidType> fluid) {
        this.skip((FluidType)fluid.get());
    }
}

