/*
 * Decompiled with CFR 0.152.
 */
package com.horriblenerd.compat.jei;

import com.horriblenerd.cobblegenrandomizer.util.Generator;
import com.horriblenerd.compat.jei.GeneratorRecipeWrapper;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public abstract class GeneratorRecipeCategoryBase<T extends GeneratorRecipeWrapper>
implements IRecipeCategory<T> {
    private final IDrawableStatic background;
    private final String localizedName;
    private final IDrawable icon;
    private final ItemStack iconStack;
    private final int size;

    public GeneratorRecipeCategoryBase(IGuiHelper guiHelper, ItemStack iconStack, String localizedName, int size) {
        this.size = size;
        this.background = this.size == 0 ? guiHelper.createBlankDrawable(52, 27) : (this.size == 1 ? guiHelper.createBlankDrawable(52, 45) : guiHelper.createBlankDrawable(52, 63));
        this.localizedName = localizedName;
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)iconStack);
        this.iconStack = iconStack;
    }

    @Nonnull
    public Component getTitle() {
        return Component.m_237115_((String)this.localizedName);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GeneratorRecipeWrapper recipeWrapper, IFocusGroup focuses) {
        ItemStack outputItemStack = new ItemStack((ItemLike)recipeWrapper.weightedBlock.getBlock());
        ItemStack catalystItemStack = new ItemStack((ItemLike)recipeWrapper.catalyst);
        int offset = 18;
        int startingX = 0;
        int startingY = 0;
        if (recipeWrapper.type == Generator.Type.COBBLESTONE) {
            if (this.size != 0) {
                startingY += 18;
            }
            builder.addSlot(RecipeIngredientRole.INPUT, startingX, startingY).addFluidStack((Fluid)Fluids.f_76193_, 1000L);
            builder.addSlot(RecipeIngredientRole.INPUT, startingX + 2 * offset, startingY).addFluidStack((Fluid)Fluids.f_76195_, 1000L);
            builder.addSlot(RecipeIngredientRole.OUTPUT, startingX + offset - 1, startingY - 1).addItemStack(outputItemStack);
            if (recipeWrapper.catalyst != Blocks.f_50016_) {
                builder.addSlot(RecipeIngredientRole.INPUT, startingX + offset - 1, startingY + offset - 1).addItemStack(catalystItemStack);
            }
        } else if (recipeWrapper.type == Generator.Type.STONE) {
            builder.addSlot(RecipeIngredientRole.INPUT, startingX + offset, startingY).addFluidStack((Fluid)Fluids.f_76195_, 1000L);
            builder.addSlot(RecipeIngredientRole.INPUT, startingX, startingY + offset).addFluidStack((Fluid)Fluids.f_76193_, 1000L);
            builder.addSlot(RecipeIngredientRole.OUTPUT, startingX + offset - 1, startingY + offset - 1).addItemStack(outputItemStack);
            if (recipeWrapper.catalyst != Blocks.f_50016_) {
                builder.addSlot(RecipeIngredientRole.INPUT, startingX + offset - 1, startingY + 2 * offset - 1).addItemStack(catalystItemStack);
            }
        } else if (recipeWrapper.type == Generator.Type.BASALT) {
            builder.addSlot(RecipeIngredientRole.INPUT, startingX, startingY).addFluidStack((Fluid)Fluids.f_76195_, 1000L);
            builder.addSlot(RecipeIngredientRole.INPUT, startingX + 2 * offset, startingY - 1).addItemStack(new ItemStack((ItemLike)Items.f_42363_));
            builder.addSlot(RecipeIngredientRole.OUTPUT, startingX + offset - 1, startingY - 1).addItemStack(outputItemStack);
            builder.addSlot(RecipeIngredientRole.INPUT, startingX + offset - 1, startingY + offset - 1).addItemStack(new ItemStack((ItemLike)Items.f_42050_));
        }
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        String weightString = String.format("%s: %d", I18n.m_118938_((String)"cobblegenrandomizer.jei.weight", (Object[])new Object[0]), ((GeneratorRecipeWrapper)recipe).weightedBlock.m_142631_().m_146281_());
        int y = (1 + this.size) * 18;
        minecraft.f_91062_.m_272078_(weightString, 2.0f, (float)y, -8355712, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0, false);
    }
}

