/*
 * Decompiled with CFR 0.152.
 */
package com.horriblenerd.cobblegenrandomizer.util;

import com.horriblenerd.cobblegenrandomizer.Config;
import com.horriblenerd.cobblegenrandomizer.util.Generator;
import com.horriblenerd.cobblegenrandomizer.util.Util;
import com.horriblenerd.cobblegenrandomizer.util.WeightedBlock;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GeneratorLists {
    private static final Logger LOGGER = LogManager.getLogger();
    public List<WeightedBlock> COBBLE_LIST;
    public List<WeightedBlock> STONE_LIST;
    public List<WeightedBlock> BASALT_LIST;
    public List<Generator> CUSTOM_GENERATOR_LIST;

    public boolean reload() {
        LOGGER.debug("Reloading generator lists...");
        this.COBBLE_LIST = Util.getWeightedList((List)Config.BLOCK_LIST_COBBLE.get());
        this.STONE_LIST = Util.getWeightedList((List)Config.BLOCK_LIST_STONE.get());
        this.BASALT_LIST = Util.getWeightedList((List)Config.BLOCK_LIST_BASALT.get());
        LOGGER.debug("Reloading custom generators...");
        this.CUSTOM_GENERATOR_LIST = new ArrayList<Generator>();
        boolean ret = true;
        for (List l : (List)Config.CUSTOM_GENERATORS.get()) {
            Generator gen = Util.createGenerator(l);
            if (gen != null) {
                this.CUSTOM_GENERATOR_LIST.add(gen);
                continue;
            }
            LOGGER.error("Invalid custom generator: " + l);
            ret = false;
        }
        return ret;
    }
}

