/*
 * Decompiled with CFR 0.152.
 */
package com.horriblenerd.cobblegenrandomizer;

import com.horriblenerd.cobblegenrandomizer.CobbleGenRandomizer;
import com.horriblenerd.cobblegenrandomizer.util.Generator;
import com.horriblenerd.cobblegenrandomizer.util.Util;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForgeEventHandlers {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public void onFluidPlaceBlockEvent(BlockEvent.FluidPlaceBlockEvent event) {
        LevelAccessor worldIn = event.getLevel();
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            Block block = Blocks.f_50016_;
            if (event.getNewState().m_60734_() == Blocks.f_50652_) {
                block = Util.getLoot(serverLevel, event.getPos(), Generator.Type.COBBLESTONE);
            } else if (event.getNewState().m_60734_() == Blocks.f_50069_) {
                block = Util.getLoot(serverLevel, event.getPos(), Generator.Type.STONE);
            } else if (event.getNewState().m_60734_() == Blocks.f_50137_) {
                block = Util.getLoot(serverLevel, event.getPos(), Generator.Type.BASALT);
            }
            if (block != Blocks.f_50016_) {
                event.setNewState(block.m_49966_());
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(LevelEvent.Load event) {
        if (CobbleGenRandomizer.GENERATORS.reload()) {
            LOGGER.info("Successfully loaded generators");
        } else {
            LOGGER.error("An error occurred during generator loading");
        }
    }
}

