/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.redui;

import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.List;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.lib.Rect;
import mrtjp.projectred.lib.Size;
import mrtjp.projectred.lib.Vec2;
import mrtjp.projectred.redui.AbstractGuiNode;
import mrtjp.projectred.redui.PVMMatrix;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.joml.Matrix4f;

public abstract class ViewportRenderNode
extends AbstractGuiNode {
    private final PVMMatrix pvMatrix = new PVMMatrix();

    protected abstract void renderInViewport(PoseStack var1, Vec2 var2, float var3, boolean var4);

    protected abstract List<Component> getToolTip(Point var1, boolean var2);

    protected abstract double getTargetPlaneDistance();

    protected abstract double getVerticalFOV();

    protected abstract double getMaxRenderDist();

    protected abstract Vector3 getCameraPosition();

    protected Rect getGlFrame() {
        Rect screenFrame = this.getRoot().getScreenFrame();
        Rect frame = this.convertParentRectToScreen(this.getFrame());
        Rect bottomLeftFrame = new Rect(new Point(frame.x(), screenFrame.height() - frame.y() - frame.height()), frame.size);
        double glWScale = this.getRoot().getMinecraft().m_91268_().m_85449_();
        double glHScale = this.getRoot().getMinecraft().m_91268_().m_85449_();
        return new Rect(new Point((int)Math.round((double)bottomLeftFrame.x() * glWScale), (int)Math.round((double)bottomLeftFrame.y() * glHScale)), new Size((int)Math.round((double)bottomLeftFrame.width() * glWScale), (int)Math.round((double)bottomLeftFrame.height() * glHScale)));
    }

    protected Vector3 mouseToWorld(Point mouse) {
        return this.ndcMouseToWorld(this.getFrame().ndc(mouse));
    }

    protected Vector3 ndcMouseToWorld(Vec2 ndcMouse) {
        return this.pvMatrix.ndcToWorldCoordinates(ndcMouse.dx, ndcMouse.dy, this.getTargetPlaneDistance());
    }

    protected double distanceToEncloseRect(double width, double height) {
        double fovY = this.getVerticalFOV();
        double fovX = fovY * (double)this.getFrame().width() / (double)this.getFrame().height();
        double xDist = width / (2.0 * Math.tan(fovX / 2.0));
        double yDist = height / (2.0 * Math.tan(fovY / 2.0));
        return Math.max(xDist, yDist);
    }

    @Override
    public void drawBack(GuiGraphics graphics, Point mouse, float partialFrame) {
        Rect glFrame = this.getGlFrame();
        this.pvMatrix.setProjection(this.getVerticalFOV(), glFrame.width(), glFrame.height(), 0.2f, this.getMaxRenderDist());
        this.pvMatrix.setView(this.getCameraPosition().x, this.getCameraPosition().y, this.getCameraPosition().z, 1.5707963267948701, 0.0);
        int glvpH = GlStateManager.Viewport.m_157129_();
        int glvpW = GlStateManager.Viewport.m_157128_();
        int glvpX = GlStateManager.Viewport.m_157126_();
        int glvpY = GlStateManager.Viewport.m_157127_();
        RenderSystem.viewport((int)glFrame.x(), (int)glFrame.y(), (int)glFrame.width(), (int)glFrame.height());
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)this.pvMatrix.getProjectionMatrix().toMatrix4f(), (VertexSorting)VertexSorting.f_276633_);
        PoseStack mvStack = RenderSystem.getModelViewStack();
        mvStack.m_85836_();
        mvStack.m_166856_();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.clear((int)256, (boolean)false);
        PoseStack pStack = this.pvMatrix.getModelViewMatrixStack();
        this.renderInViewport(pStack, this.getFrame().ndc(mouse), partialFrame, this.isFirstHit(mouse));
        mvStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.restoreProjectionMatrix();
        RenderSystem.viewport((int)glvpX, (int)glvpY, (int)glvpW, (int)glvpH);
    }

    @Override
    public void drawFront(GuiGraphics graphics, Point mouse, float partialFrame) {
        List<Component> tooltip = this.getToolTip(mouse, this.isFirstHit(mouse));
        this.renderTooltip(graphics, mouse, tooltip);
    }
}

