/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.fluid;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectManager;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffects;
import slimeknights.tconstruct.library.modifiers.modules.build.StatBoostModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolTankHelper;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.particle.FluidParticleData;
import slimeknights.tconstruct.tools.modules.armor.CounterModule;

public abstract class UseFluidOnHitModifier
extends Modifier {
    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addModule(ToolTankHelper.TANK_HANDLER);
        hookBuilder.addModule((HookProvider)StatBoostModule.add(ToolTankHelper.CAPACITY_STAT).eachLevel(1000.0f));
    }

    public static void spawnParticles(Entity target, FluidStack fluid) {
        Level level = target.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)new FluidParticleData((ParticleType<FluidParticleData>)((ParticleType)TinkerCommons.fluidParticle.get()), fluid), target.m_20185_(), target.m_20227_(0.5), target.m_20189_(), 10, 0.1, 0.2, 0.1, 0.2);
        }
    }

    public abstract FluidEffectContext.Entity createContext(LivingEntity var1, @Nullable Player var2, @Nullable Entity var3);

    protected void useFluid(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source) {
        FluidStack fluid;
        LivingEntity self = context.getEntity();
        float level = CounterModule.getLevel(tool, modifier, slotType, self);
        if (RANDOM.nextFloat() < 0.25f * level && !(fluid = ToolTankHelper.TANK_HELPER.getFluid(tool)).isEmpty()) {
            FluidEffectContext.Entity fluidContext;
            int consumed;
            Player p;
            Player player = self instanceof Player ? (p = (Player)self) : null;
            FluidEffects recipe = FluidEffectManager.INSTANCE.find(fluid.getFluid());
            if (recipe.hasEffects() && (consumed = recipe.applyToEntity(fluid, 1.0f, fluidContext = this.createContext(self, player, source.m_7639_()), IFluidHandler.FluidAction.EXECUTE)) > 0) {
                UseFluidOnHitModifier.spawnParticles(fluidContext.getTarget(), fluid);
                if (player == null || !player.m_7500_()) {
                    fluid.shrink(consumed);
                    ToolTankHelper.TANK_HELPER.setFluid(tool, fluid);
                }
            }
        }
    }
}

