/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.logic;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.events.ToolEquipmentChangeEvent;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class EquipmentChangeWatcher {
    private static final ResourceLocation ID = TConstruct.getResource("equipment_watcher");
    public static final Capability<PlayerLastEquipment> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerLastEquipment>(){});

    private EquipmentChangeWatcher() {
    }

    public static void register() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.NORMAL, false, RegisterCapabilitiesEvent.class, event -> event.register(PlayerLastEquipment.class));
        MinecraftForge.EVENT_BUS.addListener(EquipmentChangeWatcher::onEquipmentChange);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            MinecraftForge.EVENT_BUS.addListener(EquipmentChangeWatcher::onPlayerTick);
            MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, EquipmentChangeWatcher::attachCapability);
        }
    }

    private static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        EquipmentChangeWatcher.runModifierHooks(event.getEntity(), event.getSlot(), event.getFrom(), event.getTo());
    }

    private static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity.m_20193_().f_46443_ && entity instanceof Player) {
            PlayerLastEquipment provider = new PlayerLastEquipment((Player)entity);
            event.addCapability(ID, (ICapabilityProvider)provider);
            event.addListener((Runnable)provider);
        }
    }

    private static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.CLIENT) {
            event.player.getCapability(CAPABILITY).ifPresent(PlayerLastEquipment::update);
        }
    }

    private static void runModifierHooks(LivingEntity entity, EquipmentSlot changedSlot, ItemStack original, ItemStack replacement) {
        EquipmentChangeContext context = new EquipmentChangeContext(entity, changedSlot, original, replacement);
        IToolStackView tool = context.getOriginalTool();
        if (tool != null) {
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getHook(ModifierHooks.EQUIPMENT_CHANGE).onUnequip(tool, entry, context);
            }
        }
        if ((tool = context.getReplacementTool()) != null) {
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getHook(ModifierHooks.EQUIPMENT_CHANGE).onEquip(tool, entry, context);
            }
        }
        for (EquipmentSlot otherSlot : EquipmentSlot.values()) {
            if (otherSlot == changedSlot || (tool = context.getToolInSlot(otherSlot)) == null) continue;
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getHook(ModifierHooks.EQUIPMENT_CHANGE).onEquipmentChange(tool, entry, context, otherSlot);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new ToolEquipmentChangeEvent(context));
    }

    protected static class PlayerLastEquipment
    implements ICapabilityProvider,
    Runnable {
        @Nullable
        private final Player player;
        private final Map<EquipmentSlot, ItemStack> lastItems = new EnumMap<EquipmentSlot, ItemStack>(EquipmentSlot.class);
        private LazyOptional<PlayerLastEquipment> capability;

        private PlayerLastEquipment(@Nullable Player player) {
            this.player = player;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                this.lastItems.put(slot, ItemStack.f_41583_);
            }
            this.capability = LazyOptional.of(() -> this);
        }

        public void update() {
            if (this.player != null) {
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    ItemStack newStack = this.player.m_6844_(slot);
                    ItemStack oldStack = this.lastItems.get(slot);
                    if (ItemStack.m_41728_((ItemStack)oldStack, (ItemStack)newStack)) continue;
                    this.lastItems.put(slot, newStack.m_41777_());
                    EquipmentChangeWatcher.runModifierHooks((LivingEntity)this.player, slot, oldStack, newStack);
                }
            }
        }

        @Override
        public void run() {
            this.capability.invalidate();
            this.capability = LazyOptional.of(() -> this);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return CAPABILITY.orEmpty(cap, this.capability);
        }
    }
}

