/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.tools.definition.module.material.MaterialRepairToolHook;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IRepairKitItem;
import slimeknights.tconstruct.library.tools.part.MaterialItem;
import slimeknights.tconstruct.library.tools.part.ToolPartItem;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

public class RepairKitItem
extends MaterialItem
implements IRepairKitItem {
    private static final String TOOLTIP_KEY = TConstruct.makeTranslationKey("item", "repair_kit.tooltip");
    private final float repairAmount;

    public RepairKitItem(Item.Properties properties, float repairAmount) {
        super(properties);
        this.repairAmount = repairAmount;
    }

    public RepairKitItem(Item.Properties properties) {
        this(properties, 0.0f);
    }

    @Override
    public boolean canUseMaterial(MaterialId material) {
        return MaterialRegistry.getInstance().getAllStats(material).stream().anyMatch(stats -> stats == StatlessMaterialStats.REPAIR_KIT || stats.getType().canRepair());
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flag) {
        MaterialVariantId materialVariant;
        if (flag.m_7050_() && !TooltipUtil.isDisplay(stack) && !(materialVariant = this.getMaterial(stack)).equals(IMaterial.UNKNOWN_ID)) {
            tooltip.add((Component)Component.m_237110_((String)ToolPartItem.MATERIAL_KEY, (Object[])new Object[]{materialVariant.toString()}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        tooltip.add((Component)Component.m_237110_((String)TOOLTIP_KEY, (Object[])new Object[]{Float.valueOf(this.getRepairAmount())}).m_130940_(ChatFormatting.GRAY));
    }

    @Override
    public float getRepairAmount() {
        if (this.repairAmount == 0.0f) {
            return ((Double)Config.COMMON.repairKitAmount.get()).floatValue();
        }
        return this.repairAmount;
    }

    public boolean m_142207_(ItemStack stack, Slot slot, ClickAction action, Player player) {
        ItemStack toolItem;
        if (action == ClickAction.SECONDARY && slot.m_150651_(player) && !(toolItem = slot.m_7993_()).m_41619_() && toolItem.m_204117_(TinkerTags.Items.MODIFIABLE)) {
            float amount;
            ToolStack tool = ToolStack.from(toolItem);
            MaterialId material = this.getMaterial(stack).getId();
            if (tool.getDamage() > 0 && material != IMaterial.UNKNOWN_ID && (amount = MaterialRepairToolHook.repairAmount(tool, material)) > 0.0f) {
                amount *= this.getRepairAmount() / 3.0f;
                for (ModifierEntry entry : tool.getModifierList()) {
                    amount = entry.getHook(ModifierHooks.REPAIR_FACTOR).getRepairFactor(tool, entry, amount);
                    if (!(amount <= 0.0f)) continue;
                    return true;
                }
                ToolDamageUtil.repair(tool, (int)amount);
                tool.updateStack(toolItem);
                stack.m_41774_(1);
            }
            return true;
        }
        return false;
    }
}

