/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public final class ModifierUtil {
    @Nonnull
    public static FoodConsumer foodConsumer = (player, stack, hunger, saturation) -> {};

    public static void dropItem(Level level, double x, double y, double z, ItemStack stack) {
        if (!stack.m_41619_() && !level.f_46443_) {
            ItemEntity ent = new ItemEntity(level, x, y, z, stack);
            ent.m_32060_();
            RandomSource rand = level.f_46441_;
            ent.m_20256_(ent.m_20184_().m_82520_((double)((rand.m_188501_() - rand.m_188501_()) * 0.1f), (double)(rand.m_188501_() * 0.05f), (double)((rand.m_188501_() - rand.m_188501_()) * 0.1f)));
            level.m_7967_((Entity)ent);
        }
    }

    public static void dropItem(Entity target, ItemStack stack) {
        ModifierUtil.dropItem(target.m_9236_(), target.m_20185_(), target.m_20186_() + 1.0, target.m_20189_(), stack);
    }

    public static void dropItem(Level level, Vec3 location, ItemStack stack) {
        ModifierUtil.dropItem(level, location.m_7096_(), location.m_7098_(), location.m_7094_(), stack);
    }

    @Nullable
    public static LivingEntity asLiving(@Nullable Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living;
        }
        return null;
    }

    @Nullable
    public static Player asPlayer(@Nullable Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        return null;
    }

    public static int getModifierLevel(ItemStack stack, ModifierId modifier) {
        ListTag list;
        int size;
        CompoundTag nbt;
        if (!stack.m_41619_() && stack.m_204117_(TinkerTags.Items.MODIFIABLE) && (nbt = stack.m_41783_()) != null && nbt.m_128425_("tic_modifiers", 9) && (size = (list = nbt.m_128437_("tic_modifiers", 10)).size()) > 0) {
            String key = modifier.toString();
            for (int i = 0; i < size; ++i) {
                CompoundTag entry = list.m_128728_(i);
                if (!key.equals(entry.m_128461_("name"))) continue;
                return entry.m_128451_("level");
            }
        }
        return 0;
    }

    public static boolean hasUpgrades(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_204117_(TinkerTags.Items.MODIFIABLE)) {
            CompoundTag nbt = stack.m_41783_();
            return nbt != null && !nbt.m_128437_("tic_upgrades", 10).isEmpty();
        }
        return false;
    }

    public static boolean validArmorSlot(LivingEntity living, EquipmentSlot slot) {
        return slot.m_254934_() || living.m_6844_(slot).m_204117_(TinkerTags.Items.HELD);
    }

    public static boolean validArmorSlot(IToolStackView tool, EquipmentSlot slot) {
        return slot.m_254934_() || tool.hasTag(TinkerTags.Items.HELD);
    }

    public static boolean checkVolatileFlag(ItemStack stack, ResourceLocation flag) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128425_("tic_volatile_data", 10)) {
            return nbt.m_128469_("tic_volatile_data").m_128471_(flag.toString());
        }
        return false;
    }

    public static boolean checkPersistentPresent(ItemStack stack, ResourceLocation key) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128425_("tic_volatile_data", 10)) {
            return nbt.m_128469_("tic_volatile_data").m_128441_(key.toString());
        }
        return false;
    }

    public static int getVolatileInt(ItemStack stack, ResourceLocation flag) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128425_("tic_volatile_data", 10)) {
            return nbt.m_128469_("tic_volatile_data").m_128451_(flag.toString());
        }
        return 0;
    }

    public static int getPersistentInt(ItemStack stack, ResourceLocation flag, int defealtValue) {
        String flagString;
        CompoundTag persistent;
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128425_("tic_persistent", 10) && (persistent = nbt.m_128469_("tic_persistent")).m_128425_(flagString = flag.toString(), 3)) {
            return persistent.m_128451_(flagString);
        }
        return defealtValue;
    }

    public static String getPersistentString(ItemStack stack, ResourceLocation flag) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128425_("tic_persistent", 10)) {
            return nbt.m_128469_("tic_persistent").m_128461_(flag.toString());
        }
        return "";
    }

    public static boolean canPerformAction(IToolStackView tool, ToolAction action) {
        if (!tool.isBroken()) {
            if (tool.getHook(ToolHooks.TOOL_ACTION).canPerformAction(tool, action)) {
                return true;
            }
            for (ModifierEntry entry : tool.getModifierList()) {
                if (!entry.getHook(ModifierHooks.TOOL_ACTION).canPerformAction(tool, entry, action)) continue;
                return true;
            }
        }
        return false;
    }

    public static float getInaccuracy(IToolStackView tool, LivingEntity living) {
        return 3.0f * (1.0f / ConditionalStatModifierHook.getModifiedStat(tool, living, ToolStats.ACCURACY) - 1.0f);
    }

    private ModifierUtil() {
    }

    public static interface FoodConsumer {
        public void onConsume(Player var1, ItemStack var2, int var3, float var4);
    }
}

