/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.recipe.casting.AbstractCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.material.AbstractMaterialCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;
import slimeknights.tconstruct.library.tools.definition.module.material.MaterialRepairModule;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolMaterialHook;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class PartSwapCastingRecipe
extends AbstractMaterialCastingRecipe {
    public static final RecordLoadable<PartSwapCastingRecipe> LOADER = RecordLoadable.create((RecordField)LoadableRecipeSerializer.TYPED_SERIALIZER.requiredField(), (RecordField)ContextKey.ID.requiredField(), (RecordField)LoadableRecipeSerializer.RECIPE_GROUP, (RecordField)IngredientLoadable.ALLOW_EMPTY.requiredField("tools", AbstractCastingRecipe::getCast), (RecordField)ITEM_COST_FIELD, (RecordField)IntLoadable.FROM_ZERO.requiredField("index", r -> r.index), PartSwapCastingRecipe::new);
    private final int index;
    @Nullable
    private MaterialFluidRecipe cachedPartSwapping = null;

    protected PartSwapCastingRecipe(TypeAwareRecipeSerializer<?> serializer, ResourceLocation id, String group, Ingredient cast, int itemCost, int index) {
        super(serializer, id, group, cast, itemCost, true, false);
        this.index = index;
    }

    private int getIndex(List<MaterialStatsId> requirements) {
        if (this.index < 0) {
            return requirements.size() + this.index;
        }
        return this.index;
    }

    @Override
    protected MaterialFluidRecipe getFluidRecipe(ICastingContainer inv) {
        MaterialFluidRecipe materialFluidRecipe;
        Item item = inv.getStack().m_41720_();
        if (item instanceof IModifiable) {
            IModifiable modifiable = (IModifiable)item;
            materialFluidRecipe = this.getFluidRecipe(inv, modifiable);
        } else {
            materialFluidRecipe = MaterialFluidRecipe.EMPTY;
        }
        return materialFluidRecipe;
    }

    protected MaterialFluidRecipe getFluidRecipe(ICastingContainer inv, IModifiable modifiable) {
        ItemStack stack = inv.getStack();
        Fluid fluid = inv.getFluid();
        List<MaterialStatsId> requirements = ToolMaterialHook.stats(modifiable.getToolDefinition());
        int index = this.getIndex(requirements);
        MaterialVariantId currentMaterial = MaterialIdNBT.from(stack).getMaterial(index);
        if (this.cachedPartSwapping != null && this.cachedPartSwapping.matches(fluid, currentMaterial)) {
            return this.cachedPartSwapping;
        }
        MaterialFluidRecipe casting = super.getFluidRecipe(inv);
        if (casting != MaterialFluidRecipe.EMPTY && !casting.getOutput().sameVariant(currentMaterial) && requirements.get(index).canUseMaterial(casting.getOutput().getId())) {
            this.cachedPartSwapping = casting;
            return casting;
        }
        MaterialFluidRecipe composite = MaterialCastingLookup.getCompositeFluid(fluid, currentMaterial);
        if (composite != MaterialFluidRecipe.EMPTY) {
            this.cachedPartSwapping = composite;
            return composite;
        }
        return MaterialFluidRecipe.EMPTY;
    }

    protected boolean canPartSwap(ICastingContainer inv) {
        ItemStack cast = inv.getStack();
        Item item = cast.m_41720_();
        if (!(item instanceof IModifiable)) {
            return false;
        }
        IModifiable modifiable = (IModifiable)item;
        List<MaterialStatsId> requirements = ToolMaterialHook.stats(modifiable.getToolDefinition());
        int index = this.getIndex(requirements);
        if (index >= requirements.size()) {
            return false;
        }
        MaterialFluidRecipe recipe = this.getFluidRecipe(inv, modifiable);
        if (recipe == MaterialFluidRecipe.EMPTY || !requirements.get(index).canUseMaterial(recipe.getOutput().getId())) {
            return false;
        }
        ToolStack original = ToolStack.from(cast);
        ToolStack tool = original.copy();
        tool.replaceMaterial(index, recipe.getOutput().getId());
        return tool.tryValidate() == null && ModifierRemovalHook.onRemoved(original, tool) == null;
    }

    public boolean matches(ICastingContainer inv, Level level) {
        return this.getCast().test(inv.getStack()) && this.canPartSwap(inv);
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.getCast().m_43908_()[0].m_41777_();
    }

    public ItemStack assemble(ICastingContainer inv, RegistryAccess access) {
        float repairDurability;
        MaterialFluidRecipe fluidRecipe = this.getFluidRecipe(inv);
        MaterialVariant material = fluidRecipe.getOutput();
        ItemStack cast = inv.getStack();
        ToolStack original = ToolStack.from(cast);
        ToolStack tool = original.copy();
        List<MaterialStatsId> stats = ToolMaterialHook.stats(tool.getDefinition());
        int index = this.getIndex(stats);
        tool.replaceMaterial(index, material.getVariant());
        if (fluidRecipe.getInput() == null && (repairDurability = (float)MaterialRepairModule.getDurability(null, material.getId(), stats.get(index))) > 0.0f && tool.getDamage() > 0) {
            ModifierEntry entry;
            repairDurability *= (float)this.itemCost / 3.0f;
            Iterator<ModifierEntry> iterator = tool.getModifierList().iterator();
            while (iterator.hasNext() && !((repairDurability = (entry = iterator.next()).getHook(ModifierHooks.REPAIR_FACTOR).getRepairFactor(tool, entry, repairDurability)) <= 0.0f)) {
            }
            if (repairDurability > 0.0f) {
                ToolDamageUtil.repair(tool, (int)repairDurability);
            }
        }
        tool.tryValidate();
        ModifierRemovalHook.onRemoved(original, tool);
        return tool.copyStack(cast, 1);
    }
}

