/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.book.content;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.element.TextComponentData;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.TextComponentElement;
import slimeknights.mantle.client.screen.book.element.TextElement;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.book.content.AbstractMaterialContent;
import slimeknights.tconstruct.library.client.book.elements.TinkerItemElement;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.json.variable.ToFloatFunction;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.part.ToolPartItem;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.stats.PlatingMaterialStats;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

public class ArmorMaterialContent
extends AbstractMaterialContent {
    public static final ResourceLocation ID = TConstruct.getResource("armor_material");
    private static final Set<MaterialStatsId> SUPPORTED = Stream.concat(PlatingMaterialStats.TYPES.stream().map(MaterialStatType::getId), Stream.of(StatlessMaterialStats.MAILLE.getIdentifier(), StatlessMaterialStats.SHIELD_CORE.getIdentifier())).collect(Collectors.toSet());
    private static final List<MaterialStatsId> TOP_DOWN_STATS = List.of(PlatingMaterialStats.HELMET.getId(), PlatingMaterialStats.CHESTPLATE.getId(), PlatingMaterialStats.LEGGINGS.getId(), PlatingMaterialStats.BOOTS.getId(), PlatingMaterialStats.SHIELD.getId());
    private static final Component PLATING_LABEL = TConstruct.makeTranslation("stat", "plating").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.UNDERLINE});
    private static final Component ARMOR_PLATING_LABEL = TConstruct.makeTranslation("stat", "plating_armor").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.UNDERLINE});
    private static final Component SHIELD_LABEL = TConstruct.makeTranslation("stat", "plating_shield").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.UNDERLINE});

    public ArmorMaterialContent(MaterialVariantId materialVariant, boolean detailed) {
        super(materialVariant, detailed);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    @Nullable
    protected MaterialStatsId getStatType(int index) {
        return switch (index) {
            case 0 -> StatlessMaterialStats.MAILLE.getIdentifier();
            case 1 -> StatlessMaterialStats.SHIELD_CORE.getIdentifier();
            default -> null;
        };
    }

    @Override
    protected String getTextKey(MaterialId material) {
        if (this.detailed) {
            String primaryKey = String.format("material.%s.%s.armor", material.m_135827_(), material.m_135815_());
            if (Util.canTranslate(primaryKey)) {
                return primaryKey;
            }
            return String.format("material.%s.%s.encyclopedia", material.m_135827_(), material.m_135815_());
        }
        return String.format("material.%s.%s.flavor", material.m_135827_(), material.m_135815_());
    }

    @Override
    protected boolean supportsStatType(MaterialStatsId statsId) {
        return SUPPORTED.contains((Object)statsId);
    }

    private static void addPlatingItem(MaterialStatsId statType, List<ItemStack> stacks, MaterialVariantId variant) {
        for (ArmorItem.Type slotType : ArmorItem.Type.values()) {
            if (!statType.equals((Object)PlatingMaterialStats.TYPES.get(slotType.ordinal()).getId())) continue;
            stacks.add(((ToolPartItem)TinkerToolParts.plating.get((Enum)slotType)).withMaterialForDisplay(variant));
            return;
        }
        ItemStack tool = ToolBuildHandler.createSingleMaterial((IModifiable)TinkerTools.plateShield.get(), MaterialVariant.of(variant));
        if (!tool.m_41619_()) {
            stacks.add(tool);
        } else {
            stacks.add(((ModifiableItem)TinkerTools.plateShield.get()).getRenderTool());
        }
    }

    @Override
    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        MaterialVariantId materialVariant = this.getMaterialVariant();
        MaterialId material = materialVariant.getId();
        this.addTitle(list, this.getTitle(), true, MaterialTooltipCache.getColor(materialVariant).m_131265_());
        this.addDisplayItems(list, rightSide ? 164 : 0, materialVariant);
        int y = this.getTitleHeight();
        int x = (rightSide ? 0 : 22) + 2;
        IMaterialRegistry registry = MaterialRegistry.getInstance();
        List<PlatingMaterialStats> stats = TOP_DOWN_STATS.stream().flatMap(id -> registry.getMaterialStats(material, (MaterialStatsId)((Object)id)).stream()).toList();
        if (!stats.isEmpty()) {
            ArrayList<ItemStack> plating = new ArrayList<ItemStack>();
            for (PlatingMaterialStats stat2 : stats) {
                ArmorMaterialContent.addPlatingItem(stat2.getIdentifier(), plating, materialVariant);
            }
            int platingWidth = book.fontRenderer.m_92852_((FormattedText)PLATING_LABEL);
            list.add((BookElement)new TextComponentElement(x, y, platingWidth, 10, PLATING_LABEL));
            for (int i = 0; i < plating.size(); ++i) {
                if (i != 0) {
                    list.add((BookElement)new TextElement(platingWidth - 2 + x + i * 20, y, 15, 10, "/"));
                }
                list.add((BookElement)new TinkerItemElement(platingWidth + 5 + x + i * 20, y, 0.5f, List.of((ItemStack)plating.get(i))));
            }
            y += 10;
            ArrayList<TextComponentData> lineData = new ArrayList<TextComponentData>();
            ArmorMaterialContent.addStatLine(lineData, stats, ToolStats.DURABILITY, PlatingMaterialStats::durability);
            ArmorMaterialContent.addStatLine(lineData, stats, ToolStats.ARMOR, PlatingMaterialStats::armor);
            ArmorMaterialContent.addStatLine(lineData, stats, ToolStats.ARMOR_TOUGHNESS, PlatingMaterialStats::toughness);
            ArmorMaterialContent.addStatLine(lineData, stats, ToolStats.KNOCKBACK_RESISTANCE, stat -> stat.knockbackResistance() * 10.0f);
            list.add((BookElement)new TextComponentElement(x - 2, y, 162, 176, lineData));
            y += lineData.size() * 5;
        }
        y = Math.max(this.addTraits(x - 3, y, list, ARMOR_PLATING_LABEL, PlatingMaterialStats.HELMET.getId()), this.addTraits(x + 81, y, list, SHIELD_LABEL, PlatingMaterialStats.SHIELD.getId()));
        y = this.addAllMaterialStats(x, y, list, 1, false);
        this.addDescription(x, y, list);
    }

    private static void addStatLine(List<TextComponentData> lineData, List<PlatingMaterialStats> plating, FloatToolStat stat, ToFloatFunction<PlatingMaterialStats> statGetter) {
        String[] values = (String[])plating.stream().map(s -> Util.COMMA_FORMAT.format(statGetter.apply((PlatingMaterialStats)s))).toArray(String[]::new);
        boolean allMatch = true;
        for (int i = 1; i < values.length; ++i) {
            if (values[0].equals(values[i])) continue;
            allMatch = false;
            break;
        }
        String stats = allMatch ? values[0] : Strings.join((String[])values, (String)" / ");
        TextComponentData data = new TextComponentData((Component)stat.getPrefix().m_7220_((Component)Component.m_237113_((String)stats).m_130938_(style -> style.m_131148_(stat.getColor()))));
        data.tooltips = new Component[]{stat.getDescription()};
        lineData.add(data);
        lineData.add(new TextComponentData("\n"));
    }

    private int addTraits(int x, int y, List<BookElement> list, Component title, MaterialStatsId statsId) {
        MaterialVariantId material;
        IMaterialRegistry registry = MaterialRegistry.getInstance();
        if (registry.getMaterialStats((material = this.getMaterialVariant()).getId(), statsId).isEmpty()) {
            return y;
        }
        list.add((BookElement)new TextComponentElement(x, y, 81, 10, title));
        ArrayList lineData = Lists.newArrayList();
        ArmorMaterialContent.addTraitLines(lineData, registry.getTraits(material.getId(), statsId));
        list.add((BookElement)new TextComponentElement(x, y += 12, 81, 176, (Collection)lineData));
        return y + lineData.size() * 5 + 3;
    }
}

