/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.culinaryconstruct.platform;

import com.illusivesoulworks.culinaryconstruct.CulinaryConstructConstants;
import com.illusivesoulworks.culinaryconstruct.api.CulinaryConstructCapabilities;
import com.illusivesoulworks.culinaryconstruct.api.ICulinaryIngredient;
import com.illusivesoulworks.culinaryconstruct.client.CulinaryConstructForgeClientMod;
import com.illusivesoulworks.culinaryconstruct.common.network.CPacketRename;
import com.illusivesoulworks.culinaryconstruct.common.network.CulinaryConstructForgeNetwork;
import com.illusivesoulworks.culinaryconstruct.platform.services.IPlatform;
import java.util.Optional;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.items.ItemHandlerHelper;

public class ForgePlatform
implements IPlatform {
    @Override
    public Optional<ICulinaryIngredient> getCulinaryIngredient(ItemStack stack) {
        return stack.getCapability(CulinaryConstructCapabilities.CULINARY_INGREDIENT).resolve();
    }

    @Override
    public void giveItemToPlayer(ItemStack stack, Player player) {
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
    }

    @Override
    public boolean isFluidValid(ItemStack stack) {
        Fluid fluid = FluidUtil.getFluidHandler((ItemStack)stack).map(fluidHandler -> fluidHandler.getFluidInTank(0).getFluid()).orElse(Fluids.f_76191_);
        if (fluid == Fluids.f_76191_) {
            return false;
        }
        FluidType fluidType = fluid.getFluidType();
        return !fluidType.isLighterThanAir() && fluidType.getTemperature() <= 400 && !fluidType.isAir();
    }

    @Override
    public Integer getFluidColor(ItemStack stack) {
        Fluid fluid = FluidUtil.getFluidHandler((ItemStack)stack).map(fluidHandler -> fluidHandler.getFluidInTank(0).getFluid()).orElse(Fluids.f_76191_);
        if (fluid == Fluids.f_76193_ || fluid == Fluids.f_76191_) {
            return null;
        }
        if (FMLEnvironment.dist.isClient()) {
            return CulinaryConstructForgeClientMod.getFluidColor(fluid);
        }
        CulinaryConstructConstants.LOG.error("Attempted to retrieve fluid color in a non-client!");
        return null;
    }

    @Override
    public void cureStatusEffects(ItemStack stack, Player player) {
        player.curePotionEffects(stack);
    }

    @Override
    public ItemStack getContainerItem(ItemStack stack) {
        return stack.getCraftingRemainingItem();
    }

    @Override
    public void sendRenamePacket(CPacketRename msg) {
        CulinaryConstructForgeNetwork.get().sendToServer((Object)msg);
    }
}

