/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.culinaryconstruct.common.util;

import com.illusivesoulworks.culinaryconstruct.api.CulinaryConstructApi;
import com.illusivesoulworks.culinaryconstruct.api.ICulinaryIngredient;
import com.illusivesoulworks.culinaryconstruct.common.config.CulinaryConstructConfig;
import com.illusivesoulworks.culinaryconstruct.common.registry.CulinaryConstructRegistry;
import com.illusivesoulworks.culinaryconstruct.common.util.CulinaryNBT;
import com.illusivesoulworks.culinaryconstruct.common.util.CulinaryTags;
import com.illusivesoulworks.culinaryconstruct.platform.Services;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Mth;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CulinaryCalculator {
    private final NonNullList<ItemStack> ingredients;
    private final NonNullList<ItemStack> solids;
    private final List<ItemStack> processed = new ArrayList<ItemStack>();
    private final ItemStack base;
    private final List<Integer> liquidColors;
    private int food;
    private float saturation;
    private int complexity;

    public CulinaryCalculator(ItemStack baseIn, NonNullList<ItemStack> ingredientsIn) {
        this.base = baseIn;
        this.ingredients = ingredientsIn;
        this.solids = NonNullList.m_122779_();
        this.liquidColors = new ArrayList<Integer>();
    }

    public ItemStack getResult() {
        int maxFood;
        OutputType type;
        ArrayList<ItemStack> process = new ArrayList<ItemStack>((Collection<ItemStack>)this.ingredients);
        this.processed.clear();
        if (CulinaryTags.isBread(this.base)) {
            type = OutputType.SANDWICH;
            maxFood = (Integer)CulinaryConstructConfig.SERVER.maxFoodPerSandwich.get();
        } else if (CulinaryTags.isBowl(this.base)) {
            type = OutputType.BOWL;
            maxFood = Integer.MAX_VALUE;
        } else {
            return ItemStack.f_41583_;
        }
        if (type == OutputType.SANDWICH) {
            process.add(this.base);
        }
        for (ItemStack stack : process) {
            if (stack.m_41619_() || this.processStack(stack)) continue;
            return ItemStack.f_41583_;
        }
        if (type == OutputType.SANDWICH && !this.liquidColors.isEmpty()) {
            return ItemStack.f_41583_;
        }
        if (this.saturation <= 0.0f || this.food <= 0) {
            return ItemStack.f_41583_;
        }
        this.saturation /= (float)this.food;
        int count = 1;
        if (type == OutputType.SANDWICH) {
            count = (int)Math.ceil((double)this.food / (double)maxFood);
        }
        this.food = (int)Math.ceil((double)this.food / (double)count);
        int quality = Mth.m_14045_((int)(this.complexity - this.getSize() / 2 + 1), (int)0, (int)4);
        this.saturation *= 1.0f + (float)(quality - 2) * 0.3f;
        ItemStack result = type == OutputType.SANDWICH ? new ItemStack((ItemLike)CulinaryConstructRegistry.SANDWICH.get()) : new ItemStack((ItemLike)CulinaryConstructRegistry.BOWL.get());
        CulinaryNBT.setSize(result, this.getSize());
        CulinaryNBT.setIngredientsList(result, this.ingredients);
        CulinaryNBT.setFoodAmount(result, this.food);
        CulinaryNBT.setSaturation(result, this.saturation);
        CulinaryNBT.setQuality(result, quality);
        CulinaryNBT.setBase(result, this.base);
        CulinaryNBT.setSolids(result, this.solids);
        CulinaryNBT.setSolidsSize(result, this.solids.size());
        CulinaryNBT.setOriginalCount(result, count);
        if (!this.liquidColors.isEmpty() && type != OutputType.SANDWICH) {
            this.liquidColors.removeIf(Objects::isNull);
            CulinaryNBT.setLiquids(result, this.liquidColors);
        }
        result.m_41764_(count);
        return result;
    }

    public boolean processStack(ItemStack stack) {
        FoodProperties food = Services.REGISTRY.getFoodProperties(stack, null);
        Optional<ICulinaryIngredient> culinary = CulinaryConstructApi.getCulinaryIngredient(stack);
        int foodAmount = 0;
        float saturationAmount = 0.0f;
        boolean valid = true;
        if (culinary.isPresent()) {
            culinary.ifPresent(ingredient -> {
                if (ingredient.isLiquid()) {
                    this.liquidColors.add(ingredient.getLiquidColor());
                } else {
                    this.solids.add((Object)stack);
                }
            });
            valid = culinary.map(ICulinaryIngredient::isValid).orElse(true);
            foodAmount = culinary.map(ICulinaryIngredient::getFoodAmount).orElse(0);
            saturationAmount = culinary.map(ICulinaryIngredient::getSaturation).orElse(Float.valueOf(0.0f)).floatValue();
        } else if (food != null) {
            foodAmount = food.m_38744_();
            saturationAmount = food.m_38745_();
            this.solids.add((Object)stack);
        }
        if (!valid) {
            return false;
        }
        this.food += foodAmount;
        this.saturation += saturationAmount * (float)foodAmount;
        boolean unique = true;
        for (ItemStack existing : this.processed) {
            if (existing.m_41619_() || !ItemStack.m_41728_((ItemStack)existing, (ItemStack)stack)) continue;
            unique = false;
            break;
        }
        if (unique) {
            ++this.complexity;
        }
        this.processed.add(stack);
        return true;
    }

    public int getSize() {
        return this.ingredients.size();
    }

    static enum OutputType {
        SANDWICH,
        BOWL;

    }
}

