/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.culinaryconstruct.common.capability;

import com.illusivesoulworks.culinaryconstruct.api.ICulinaryIngredient;
import com.illusivesoulworks.culinaryconstruct.platform.Services;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.block.CakeBlock;

public class CulinaryIngredients {
    private static final List<Pair<Predicate<Item>, Function<ItemStack, ICulinaryIngredient>>> DEFAULT_LIST = new ArrayList<Pair<Predicate<Item>, Function<ItemStack, ICulinaryIngredient>>>();

    public static void setup() {
        DEFAULT_LIST.clear();
        DEFAULT_LIST.add((Pair<Predicate<Item>, Function<ItemStack, ICulinaryIngredient>>)new Pair(item -> {
            BlockItem blockItem;
            return item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof CakeBlock;
        }, stack -> new ICulinaryIngredient(){

            @Override
            public int getFoodAmount() {
                return 14;
            }

            @Override
            public float getSaturation() {
                return 0.2f;
            }
        }));
        DEFAULT_LIST.add((Pair<Predicate<Item>, Function<ItemStack, ICulinaryIngredient>>)new Pair(item -> item instanceof BucketItem, stack -> new ICulinaryIngredient((ItemStack)stack){
            final /* synthetic */ ItemStack val$stack;
            {
                this.val$stack = itemStack;
            }

            @Override
            public boolean isValid() {
                return Services.PLATFORM.isFluidValid(this.val$stack);
            }

            @Override
            public boolean isLiquid() {
                return true;
            }

            @Override
            public Integer getLiquidColor() {
                return Services.PLATFORM.getFluidColor(this.val$stack);
            }
        }));
        DEFAULT_LIST.add((Pair<Predicate<Item>, Function<ItemStack, ICulinaryIngredient>>)new Pair(item -> item instanceof MilkBucketItem, stack -> new ICulinaryIngredient((ItemStack)stack){
            final /* synthetic */ ItemStack val$stack;
            {
                this.val$stack = itemStack;
            }

            @Override
            public void onEaten(Player player) {
                if (!player.m_9236_().m_5776_()) {
                    Services.PLATFORM.cureStatusEffects(this.val$stack, player);
                }
            }

            @Override
            public boolean isLiquid() {
                return true;
            }

            @Override
            public Integer getLiquidColor() {
                return 0xFFFFFF;
            }
        }));
        DEFAULT_LIST.add((Pair<Predicate<Item>, Function<ItemStack, ICulinaryIngredient>>)new Pair(item -> item instanceof PotionItem, stack -> new ICulinaryIngredient((ItemStack)stack){
            final /* synthetic */ ItemStack val$stack;
            {
                this.val$stack = itemStack;
            }

            @Override
            public List<Pair<MobEffectInstance, Float>> getEffects() {
                ArrayList<Pair<MobEffectInstance, Float>> list = new ArrayList<Pair<MobEffectInstance, Float>>();
                PotionUtils.m_43547_((ItemStack)this.val$stack).forEach(effect -> list.add(Pair.of((Object)new MobEffectInstance(effect.m_19544_(), effect.m_19557_(), effect.m_19564_()), (Object)Float.valueOf(1.0f))));
                return list;
            }

            @Override
            public boolean isLiquid() {
                return true;
            }

            @Override
            public Integer getLiquidColor() {
                return PotionUtils.m_43575_((ItemStack)this.val$stack);
            }
        }));
        DEFAULT_LIST.add((Pair<Predicate<Item>, Function<ItemStack, ICulinaryIngredient>>)new Pair(item -> item instanceof SuspiciousStewItem, stack -> new ICulinaryIngredient((ItemStack)stack){
            final /* synthetic */ ItemStack val$stack;
            {
                this.val$stack = itemStack;
            }

            @Override
            public List<Pair<MobEffectInstance, Float>> getEffects() {
                ArrayList<Pair<MobEffectInstance, Float>> list = new ArrayList<Pair<MobEffectInstance, Float>>();
                CompoundTag compoundnbt = this.val$stack.m_41783_();
                if (compoundnbt != null && compoundnbt.m_128425_("Effects", 9)) {
                    ListTag listnbt = compoundnbt.m_128437_("Effects", 10);
                    for (int i = 0; i < listnbt.size(); ++i) {
                        MobEffect effect;
                        int j = 160;
                        CompoundTag compoundnbt1 = listnbt.m_128728_(i);
                        if (compoundnbt1.m_128425_("EffectDuration", 3)) {
                            j = compoundnbt1.m_128451_("EffectDuration");
                        }
                        if ((effect = MobEffect.m_19453_((int)compoundnbt1.m_128445_("EffectId"))) == null) continue;
                        list.add((Pair<MobEffectInstance, Float>)Pair.of((Object)new MobEffectInstance(effect, j), (Object)Float.valueOf(1.0f)));
                    }
                }
                return list;
            }
        }));
    }

    public static List<Pair<Predicate<Item>, Function<ItemStack, ICulinaryIngredient>>> getDefaults() {
        return DEFAULT_LIST;
    }
}

