/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.culinaryconstruct.client.model;

import com.google.common.collect.ImmutableList;
import com.illusivesoulworks.culinaryconstruct.client.model.CulinaryOverrides;
import com.illusivesoulworks.culinaryconstruct.client.model.color.ColorMixer;
import com.illusivesoulworks.culinaryconstruct.client.model.color.ColoredQuadTransformer;
import com.illusivesoulworks.culinaryconstruct.common.util.CulinaryNBT;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;

public final class FoodBowlGeometry
implements IUnbakedGeometry<FoodBowlGeometry> {
    private final List<TextureAtlasSprite> ingredients;
    private final List<Integer> layers;
    private final List<Integer> liquids;

    public FoodBowlGeometry() {
        this(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    private FoodBowlGeometry(List<TextureAtlasSprite> ingredients, List<Integer> layers, List<Integer> liquids) {
        this.ingredients = ingredients;
        this.layers = layers;
        this.liquids = liquids;
    }

    private FoodBowlGeometry withStack(ItemStack stack) {
        ImmutableList.Builder builder = ImmutableList.builder();
        NonNullList<ItemStack> solids = CulinaryNBT.getSolids(stack);
        for (ItemStack ing : solids) {
            builder.add((Object)Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(ing).getParticleIcon(ModelData.EMPTY));
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < solids.size(); ++i) {
            list.add(i);
        }
        List<Integer> liquids = CulinaryNBT.getLiquids(stack);
        return new FoodBowlGeometry((List<TextureAtlasSprite>)builder.build(), list, liquids);
    }

    public static RenderTypeGroup getLayerRenderTypes() {
        return new RenderTypeGroup(RenderType.m_110466_(), ForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite baseSprite = spriteGetter.apply(context.getMaterial("bowl"));
        StandaloneGeometryBakingContext itemContext = StandaloneGeometryBakingContext.builder((IGeometryBakingContext)context).withGui3d(false).withUseBlockLight(false).build(modelLocation);
        CompositeModel.Baked.Builder modelBuilder = CompositeModel.Baked.builder((IGeometryBakingContext)itemContext, (TextureAtlasSprite)baseSprite, (ItemOverrides)new BakedFoodBowlOverrides(this, context, baker, spriteGetter, modelState, modelLocation), (ItemTransforms)context.getTransforms());
        ArrayList<Integer> ingredientColors = new ArrayList<Integer>();
        this.ingredients.forEach(sprite -> ingredientColors.add(ColorMixer.getDominantColor(sprite)));
        List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (SpriteContents)baseSprite.m_245424_());
        List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, material -> baseSprite, (ModelState)modelState, (ResourceLocation)modelLocation);
        RenderTypeGroup normalRenderTypes = FoodBowlGeometry.getLayerRenderTypes();
        modelBuilder.addQuads(normalRenderTypes, (Collection)quads);
        ColoredQuadTransformer coloredQuadTransformer = new ColoredQuadTransformer();
        if (this.liquids != null) {
            ArrayList opaqueColors = new ArrayList();
            this.liquids.forEach(color -> {
                if (color != null) {
                    opaqueColors.add(color);
                }
            });
            boolean isOpaque = !opaqueColors.isEmpty();
            int liquidColor = isOpaque ? ColorMixer.getMixedColor(this.liquids) : ColorMixer.getMixedColor(ingredientColors);
            TextureAtlasSprite sprite2 = spriteGetter.apply(context.getMaterial("liquid_base"));
            unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (SpriteContents)sprite2.m_245424_());
            quads = UnbakedGeometryHelper.bakeElements((List)unbaked, material -> sprite2, (ModelState)modelState, (ResourceLocation)modelLocation);
            coloredQuadTransformer.color(quads, liquidColor);
            modelBuilder.addQuads(normalRenderTypes, (Collection)quads);
            if (this.ingredients.size() >= 3) {
                TextureAtlasSprite overflowSprite = spriteGetter.apply(context.getMaterial("liquid_overflow"));
                unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (SpriteContents)overflowSprite.m_245424_());
                quads = UnbakedGeometryHelper.bakeElements((List)unbaked, material -> overflowSprite, (ModelState)modelState, (ResourceLocation)modelLocation);
                coloredQuadTransformer.color(quads, liquidColor);
                modelBuilder.addQuads(normalRenderTypes, (Collection)quads);
            }
        }
        for (int i = 0; i < this.ingredients.size(); ++i) {
            TextureAtlasSprite sprite3 = spriteGetter.apply(context.getMaterial("layer" + this.layers.get(i)));
            unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (SpriteContents)sprite3.m_245424_());
            quads = UnbakedGeometryHelper.bakeElements((List)unbaked, material -> sprite3, (ModelState)modelState, (ResourceLocation)modelLocation);
            coloredQuadTransformer.color(quads, (Integer)ingredientColors.get(i));
            modelBuilder.addQuads(normalRenderTypes, (Collection)quads);
        }
        modelBuilder.setParticle(baseSprite);
        return modelBuilder.build();
    }

    private static final class BakedFoodBowlOverrides
    extends CulinaryOverrides<FoodBowlGeometry> {
        public BakedFoodBowlOverrides(FoodBowlGeometry model, IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ResourceLocation modelLocation) {
            super(model, context, baker, spriteGetter, modelState, modelLocation);
        }

        @Override
        protected BakedModel getBakedModel(BakedModel originalModel, ItemStack stack, @Nullable Level world, @Nullable LivingEntity entity) {
            FoodBowlGeometry unbaked = ((FoodBowlGeometry)this.model).withStack(stack);
            return unbaked.bake(this.context, this.baker, this.spriteGetter, this.modelState, this, new ResourceLocation("culinaryconstruct", "food_bowl"));
        }
    }
}

