/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.toolbox.MountedToolbox;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.AllTags;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ConductorToolboxLayer<T extends ConductorEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public ConductorToolboxLayer(RenderLayerParent<T, M> pRenderer) {
        super(pRenderer);
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, @NotNull T conductorEntity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemstack = ((ConductorEntity)((Object)conductorEntity)).getToolboxDisplayStack();
        if (itemstack.m_204117_(AllTags.AllItemTags.TOOLBOXES.tag) && ((ConductorEntity)((Object)conductorEntity)).isCarryingToolbox()) {
            MountedToolbox holder = ((ConductorEntity)((Object)conductorEntity)).getToolbox();
            BlockState blockState = ((BlockItem)itemstack.m_41720_()).m_40614_().m_49966_();
            SuperByteBuffer body = CachedBuffers.partial((PartialModel)CRBlockPartials.TOOLBOX_BODIES.get(holder.getColor()), (BlockState)blockState);
            SuperByteBuffer lid = CachedBuffers.partial((PartialModel)((PartialModel)AllPartialModels.TOOLBOX_LIDS.get(holder.getColor())), (BlockState)blockState);
            SuperByteBuffer drawer = CachedBuffers.partial((PartialModel)AllPartialModels.TOOLBOX_DRAWER, (BlockState)blockState);
            float lidAngle = holder.lid.getValue(partialTick);
            float drawerOffset = holder.drawers.getValue(partialTick);
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            poseStack.m_85837_(-0.5, -1.2, -0.94);
            double rotate = 0.0;
            VertexConsumer builder = buffer.m_6299_(RenderType.m_110457_());
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)body.center()).rotateY((float)rotate)).uncenter()).translate(0.0f, 0.375f, 0.75f)).translate(0.0f, -0.375f, -0.75f)).light(packedLight).renderInto(poseStack, builder);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)lid.center()).rotateY((float)rotate)).uncenter()).translate(0.0f, 0.375f, 0.75f)).rotateX(60.0f * lidAngle)).translate(0.0f, -0.375f, -0.75f)).light(packedLight).renderInto(poseStack, builder);
            for (int offset : Iterate.zeroAndOne) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)drawer.center()).rotateY((float)rotate)).uncenter()).translate(0.0f, (float)offset / 8.0f, -drawerOffset * 0.175f * (float)(2 - offset))).light(packedLight).renderInto(poseStack, builder);
            }
            poseStack.m_85849_();
        }
    }
}

