/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.locomotion;

import cofh.thermal.core.ThermalCore;
import cofh.thermal.locomotion.client.gui.EnergyMinecartScreen;
import cofh.thermal.locomotion.client.gui.FluidMinecartScreen;
import cofh.thermal.locomotion.client.renderer.entity.EnergyMinecartRenderer;
import cofh.thermal.locomotion.client.renderer.entity.FluidMinecartRenderer;
import cofh.thermal.locomotion.client.renderer.entity.UnderwaterMinecartRenderer;
import cofh.thermal.locomotion.client.renderer.entity.model.EnergyMinecartModel;
import cofh.thermal.locomotion.client.renderer.entity.model.FluidMinecartModel;
import cofh.thermal.locomotion.client.renderer.entity.model.UnderwaterMinecartModel;
import cofh.thermal.locomotion.init.registries.TLocBlocks;
import cofh.thermal.locomotion.init.registries.TLocContainers;
import cofh.thermal.locomotion.init.registries.TLocEntities;
import cofh.thermal.locomotion.init.registries.TLocItems;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="thermal_locomotion")
public class ThermalLocomotion {
    public ThermalLocomotion() {
        this.setFeatureFlags();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::entityLayerSetup);
        modEventBus.addListener(this::entityRendererSetup);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        TLocBlocks.register();
        TLocItems.register();
        TLocContainers.register();
        TLocEntities.register();
    }

    private void setFeatureFlags() {
    }

    private void entityLayerSetup(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(UnderwaterMinecartModel.UNDERWATER_MINECART_LAYER, UnderwaterMinecartModel::createMesh);
        event.registerLayerDefinition(EnergyMinecartModel.ENERGY_MINECART_LAYER, EnergyMinecartModel::createMesh);
        event.registerLayerDefinition(FluidMinecartModel.FLUID_MINECART_LAYER, FluidMinecartModel::createMesh);
    }

    private void entityRendererSetup(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)TLocEntities.UNDERWATER_CART.get(), UnderwaterMinecartRenderer::new);
        event.registerEntityRenderer((EntityType)TLocEntities.ENERGY_CART.get(), EnergyMinecartRenderer::new);
        event.registerEntityRenderer((EntityType)TLocEntities.FLUID_CART.get(), FluidMinecartRenderer::new);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(this::registerGuiFactories);
        event.enqueueWork(this::registerRenderLayers);
    }

    private void registerGuiFactories() {
        MenuScreens.m_96206_((MenuType)((MenuType)TLocContainers.ENERGY_CART_CONTAINER.get()), EnergyMinecartScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)TLocContainers.FLUID_CART_CONTAINER.get()), FluidMinecartScreen::new);
    }

    private void registerRenderLayers() {
        RenderType cutout = RenderType.m_110463_();
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("crossover_rail")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("prismarine_rail")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("prismarine_crossover_rail")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("prismarine_activator_rail")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("prismarine_detector_rail")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("prismarine_powered_rail")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("lumium_rail")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("lumium_crossover_rail")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("lumium_activator_rail")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("lumium_detector_rail")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("lumium_powered_rail")), (RenderType)cutout);
    }
}

