/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.commandstructures.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.telepathicgrunt.commandstructures.CommandStructuresMain;
import com.telepathicgrunt.commandstructures.Utilities;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class StructureSpawnCommand {
    public static void createCommand(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        String commandString = "spawnstructure";
        String locationArg = "location";
        String poolArg = "startpoolresourcelocation";
        String depthArg = "depth";
        String heightmapArg = "heightmapsnap";
        String legacyBoundsArg = "legacyboundingboxrule";
        String disableProcessors = "disableprocessors";
        String sendChunkLightingPacket = "sendchunklightingpacket";
        String randomSeed = "randomseed";
        LiteralCommandNode source = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)commandString).requires(permission -> permission.m_6761_(2))).then(Commands.m_82129_((String)locationArg, (ArgumentType)Vec3Argument.m_120841_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)poolArg, (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, sb) -> SharedSuggestionProvider.m_82926_(StructureSpawnCommand.startPoolSuggestions((CommandContext<CommandSourceStack>)ctx), (SuggestionsBuilder)sb)).executes(cs -> {
            StructureSpawnCommand.generateStructure(Vec3Argument.m_120849_((CommandContext)cs, (String)locationArg), (ResourceLocation)cs.getArgument(poolArg, ResourceLocation.class), 10, false, false, false, false, null, (CommandContext<CommandSourceStack>)cs);
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)depthArg, (ArgumentType)IntegerArgumentType.integer()).executes(cs -> {
            StructureSpawnCommand.generateStructure(Vec3Argument.m_120849_((CommandContext)cs, (String)locationArg), (ResourceLocation)cs.getArgument(poolArg, ResourceLocation.class), (Integer)cs.getArgument(depthArg, Integer.class), false, false, false, false, null, (CommandContext<CommandSourceStack>)cs);
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)heightmapArg, (ArgumentType)BoolArgumentType.bool()).executes(cs -> {
            StructureSpawnCommand.generateStructure(Vec3Argument.m_120849_((CommandContext)cs, (String)locationArg), (ResourceLocation)cs.getArgument(poolArg, ResourceLocation.class), (Integer)cs.getArgument(depthArg, Integer.class), (Boolean)cs.getArgument(heightmapArg, Boolean.class), false, false, false, null, (CommandContext<CommandSourceStack>)cs);
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)legacyBoundsArg, (ArgumentType)BoolArgumentType.bool()).executes(cs -> {
            StructureSpawnCommand.generateStructure(Vec3Argument.m_120849_((CommandContext)cs, (String)locationArg), (ResourceLocation)cs.getArgument(poolArg, ResourceLocation.class), (Integer)cs.getArgument(depthArg, Integer.class), (Boolean)cs.getArgument(heightmapArg, Boolean.class), (Boolean)cs.getArgument(legacyBoundsArg, Boolean.class), false, false, null, (CommandContext<CommandSourceStack>)cs);
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)disableProcessors, (ArgumentType)BoolArgumentType.bool()).executes(cs -> {
            StructureSpawnCommand.generateStructure(Vec3Argument.m_120849_((CommandContext)cs, (String)locationArg), (ResourceLocation)cs.getArgument(poolArg, ResourceLocation.class), (Integer)cs.getArgument(depthArg, Integer.class), (Boolean)cs.getArgument(heightmapArg, Boolean.class), (Boolean)cs.getArgument(legacyBoundsArg, Boolean.class), (Boolean)cs.getArgument(disableProcessors, Boolean.class), false, null, (CommandContext<CommandSourceStack>)cs);
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)sendChunkLightingPacket, (ArgumentType)BoolArgumentType.bool()).executes(cs -> {
            StructureSpawnCommand.generateStructure(Vec3Argument.m_120849_((CommandContext)cs, (String)locationArg), (ResourceLocation)cs.getArgument(poolArg, ResourceLocation.class), (Integer)cs.getArgument(depthArg, Integer.class), (Boolean)cs.getArgument(heightmapArg, Boolean.class), (Boolean)cs.getArgument(legacyBoundsArg, Boolean.class), (Boolean)cs.getArgument(disableProcessors, Boolean.class), (Boolean)cs.getArgument(sendChunkLightingPacket, Boolean.class), null, (CommandContext<CommandSourceStack>)cs);
            return 1;
        })).then(Commands.m_82129_((String)randomSeed, (ArgumentType)LongArgumentType.longArg()).executes(cs -> {
            StructureSpawnCommand.generateStructure(Vec3Argument.m_120849_((CommandContext)cs, (String)locationArg), (ResourceLocation)cs.getArgument(poolArg, ResourceLocation.class), (Integer)cs.getArgument(depthArg, Integer.class), (Boolean)cs.getArgument(heightmapArg, Boolean.class), (Boolean)cs.getArgument(legacyBoundsArg, Boolean.class), (Boolean)cs.getArgument(disableProcessors, Boolean.class), (Boolean)cs.getArgument(sendChunkLightingPacket, Boolean.class), (Long)cs.getArgument(randomSeed, Long.class), (CommandContext<CommandSourceStack>)cs);
            return 1;
        }))))))))));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)commandString).redirect((CommandNode)source));
    }

    private static Set<ResourceLocation> startPoolSuggestions(CommandContext<CommandSourceStack> cs) {
        return ((CommandSourceStack)cs.getSource()).m_81372_().m_9598_().m_175515_(Registries.f_256948_).m_6566_();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void generateStructure(Coordinates coordinates, ResourceLocation structureStartPoolRL, int depth, boolean heightmapSnap, boolean legacyBoundingBoxRule, boolean disableProcessors, boolean sendChunkLightingPacket, Long randomSeed, CommandContext<CommandSourceStack> cs) {
        WorldgenRandom worldgenrandom;
        StructureTemplatePool templatePool;
        ServerLevel level = ((CommandSourceStack)cs.getSource()).m_81372_();
        BlockPos centerPos = coordinates.m_119568_((CommandSourceStack)cs.getSource());
        if (heightmapSnap) {
            centerPos = centerPos.m_6625_(centerPos.m_123342_());
        }
        if ((templatePool = (StructureTemplatePool)level.m_9598_().m_175515_(Registries.f_256948_).m_7745_(structureStartPoolRL)) == null || templatePool.m_210590_() == 0) {
            String errorMsg = structureStartPoolRL + " template pool does not exist or is empty";
            CommandStructuresMain.LOGGER.error(errorMsg);
            throw new CommandRuntimeException((Component)Component.m_237115_((String)errorMsg));
        }
        long finalSeed = randomSeed == null ? level.m_7328_() : randomSeed.longValue();
        ChunkPos chunkPos = randomSeed == null ? new ChunkPos(centerPos) : new ChunkPos(0, 0);
        Structure.GenerationContext newGenerationContext = new Structure.GenerationContext(level.m_9598_(), level.m_7726_().m_8481_(), level.m_7726_().m_8481_().m_62218_(), level.m_7726_().m_214994_(), level.m_215082_(), finalSeed, chunkPos, (LevelHeightAccessor)level, biomeHolder -> true);
        Optional pieceGenerator = JigsawPlacement.m_227238_((Structure.GenerationContext)newGenerationContext, (Holder)Holder.m_205709_((Object)templatePool), Optional.empty(), (int)depth, (BlockPos)centerPos, (boolean)legacyBoundingBoxRule, heightmapSnap ? Optional.of(Heightmap.Types.WORLD_SURFACE_WG) : Optional.empty(), (int)80);
        if (!pieceGenerator.isPresent()) {
            String errorMsg = structureStartPoolRL + " Template Pool spawned no pieces.";
            CommandStructuresMain.LOGGER.error(errorMsg);
            throw new CommandRuntimeException((Component)Component.m_237115_((String)errorMsg));
        }
        if (randomSeed == null) {
            worldgenrandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.m_224599_()));
            long i = worldgenrandom.m_64690_(finalSeed, centerPos.m_123341_(), centerPos.m_123343_());
            worldgenrandom.m_190064_(i, 0, 0);
        } else {
            worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(randomSeed.longValue()));
        }
        BlockPos finalCenterPos = centerPos;
        List structurePieceList = ((Structure.GenerationStub)pieceGenerator.get()).m_226677_().m_192780_().f_192741_();
        structurePieceList.forEach(piece -> {
            if (disableProcessors) {
                PoolElementStructurePiece poolElementStructurePiece;
                StructurePoolElement patt9880$temp;
                if (piece instanceof PoolElementStructurePiece && (patt9880$temp = (poolElementStructurePiece = (PoolElementStructurePiece)piece).m_209918_()) instanceof SinglePoolElement) {
                    SinglePoolElement singlePoolElement = (SinglePoolElement)patt9880$temp;
                    Holder oldProcessorList = singlePoolElement.f_210412_;
                    ResourceKey emptyKey = ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("minecraft", "empty"));
                    Optional emptyProcessorList = ((CommandSourceStack)cs.getSource()).m_81372_().m_9598_().m_175515_(Registries.f_257011_).m_203636_(emptyKey);
                    emptyProcessorList.ifPresent(processors -> {
                        singlePoolElement.f_210412_ = processors;
                    });
                    StructureSpawnCommand.generatePiece(level, level.m_7726_().m_8481_(), chunkPos, worldgenrandom, finalCenterPos, piece);
                    singlePoolElement.f_210412_ = oldProcessorList;
                }
            } else {
                StructureSpawnCommand.generatePiece(level, level.m_6018_().m_7726_().m_8481_(), chunkPos, worldgenrandom, finalCenterPos, piece);
            }
        });
        if (!structurePieceList.isEmpty()) {
            if (!sendChunkLightingPacket) return;
            Utilities.refreshChunksOnClients(level);
            return;
        }
        String errorMsg = structureStartPoolRL + " Template Pool spawned no pieces.";
        CommandStructuresMain.LOGGER.error(errorMsg);
        throw new CommandRuntimeException((Component)Component.m_237115_((String)errorMsg));
    }

    private static void generatePiece(ServerLevel level, ChunkGenerator chunkGenerator, ChunkPos chunkPos, WorldgenRandom worldgenrandom, BlockPos finalCenterPos, StructurePiece piece) {
        piece.m_213694_((WorldGenLevel)level, level.m_215010_(), chunkGenerator, (RandomSource)worldgenrandom, BoundingBox.m_71044_(), chunkPos, finalCenterPos);
    }
}

