/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.tracker.types;

import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import pregenerator.common.tracker.WorldTracker;
import pregenerator.common.tracker.types.BaseWorldEntry;
import pregenerator.common.tracker.types.IWorldEntry;

public class EntityEntry
extends BaseWorldEntry {
    public EntityEntry(int id, int count) {
        super(id, count);
    }

    public EntityEntry(FriendlyByteBuf buf) {
        super(buf);
    }

    public EntityType<?> getEntity() {
        return (EntityType)((ForgeRegistry)ForgeRegistries.ENTITY_TYPES).getValue(this.id);
    }

    @Override
    protected ResourceLocation getKey(int id, RegistryAccess registry) {
        return ((ForgeRegistry)ForgeRegistries.ENTITY_TYPES).getKey(id).m_135782_();
    }

    @Override
    public Component getName(RegistryAccess registry) {
        return this.getEntity().m_20676_();
    }

    @Override
    public boolean canDelete(boolean chunk) {
        return true;
    }

    @Override
    public int deleteWorld(WorldTracker tracker, Player player) {
        EntityType type = (EntityType)((ForgeRegistry)ForgeRegistries.ENTITY_TYPES).getValue(this.id);
        if (type == null) {
            return 0;
        }
        int[] count = new int[1];
        tracker.getWorld().m_142646_().m_142690_((EntityTypeTest)type, AbortableIterationConsumer.m_260908_(T -> {
            T.m_146870_();
            count[0] = count[0] + 1;
        }));
        return count[0];
    }

    @Override
    public int deleteChunk(WorldTracker tracker, long position) {
        EntityType type = (EntityType)((ForgeRegistry)ForgeRegistries.ENTITY_TYPES).getValue(this.id);
        if (type == null) {
            return 0;
        }
        ServerLevel level = tracker.getWorld();
        ChunkPos pos = new ChunkPos(position);
        AABB box = new AABB(pos.m_151384_(0, level.m_141937_(), 0), pos.m_151384_(16, level.m_151558_(), 16));
        int[] count = new int[1];
        level.m_142646_().m_142137_((EntityTypeTest)type, box, AbortableIterationConsumer.m_260908_(T -> {
            T.m_146870_();
            count[0] = count[0] + 1;
        }));
        return count[0];
    }

    public static List<IWorldEntry> getLevel(ServerLevel level) {
        BaseWorldEntry.Counter<EntityType> counter = new BaseWorldEntry.Counter<EntityType>();
        level.m_142646_().m_142273_().forEach(T -> {
            if (T instanceof Player) {
                return;
            }
            counter.add(T.m_6095_());
        });
        return counter.map((T, C) -> new EntityEntry(((ForgeRegistry)ForgeRegistries.ENTITY_TYPES).getID(T), C));
    }

    public static List<IWorldEntry> getChunk(LevelChunk chunk) {
        Level level = chunk.m_62953_();
        if (level instanceof ServerLevel) {
            BaseWorldEntry.Counter<EntityType> counter = new BaseWorldEntry.Counter<EntityType>();
            ((ServerLevel)level).m_142646_().m_142232_(new AABB(chunk.m_7697_().m_151384_(0, level.m_141937_(), 0), chunk.m_7697_().m_151384_(16, level.m_151558_(), 16)), T -> {
                if (T instanceof Player) {
                    return;
                }
                counter.add(T.m_6095_());
            });
            return counter.map((T, C) -> new EntityEntry(((ForgeRegistry)ForgeRegistries.ENTITY_TYPES).getID(T), C));
        }
        return ObjectLists.emptyList();
    }
}

