/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.networking.packets;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pregenerator.client.gui.ProgressScreen;
import pregenerator.client.helpers.IProgressListener;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.networking.IPregenPacket;

public class ProgressPacket {

    public static class Complete
    implements IPregenPacket.IRequestPacket {
        @Override
        public void process(Player player) {
            this.processClient();
        }

        @OnlyIn(value=Dist.CLIENT)
        public void processClient() {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof IProgressListener) {
                ((IProgressListener)screen).onCompleted();
            }
        }
    }

    public static class Cancel
    implements IPregenPacket {
        UUID taskId;

        public Cancel() {
        }

        public Cancel(UUID taskId) {
            this.taskId = taskId;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130077_(this.taskId);
        }

        @Override
        public void read(FriendlyByteBuf buffer) {
            this.taskId = buffer.m_130259_();
        }

        @Override
        public void process(Player player) {
            ServerManager.INSTANCE.interruptMiniTask(this.taskId);
        }
    }

    public static class Update
    implements IPregenPacket {
        long current;
        long max;

        public Update() {
        }

        public Update(long current, long max) {
            this.current = current;
            this.max = max;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130103_(this.current);
            buffer.m_130103_(this.max);
        }

        @Override
        public void read(FriendlyByteBuf buffer) {
            this.current = buffer.m_130258_();
            this.max = buffer.m_130258_();
        }

        @Override
        public void process(Player player) {
            this.processClient();
        }

        @OnlyIn(value=Dist.CLIENT)
        public void processClient() {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof IProgressListener) {
                ((IProgressListener)screen).updateProgress(this.current, this.max);
            }
        }
    }

    public static class Start
    implements IPregenPacket {
        long max;
        UUID taskId;
        Component message;

        public Start() {
        }

        public Start(long max, UUID taskId, Component message) {
            this.max = max;
            this.taskId = taskId;
            this.message = message;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130103_(this.max);
            buffer.m_130077_(this.taskId);
            buffer.m_130083_(this.message);
        }

        @Override
        public void read(FriendlyByteBuf buffer) {
            this.max = buffer.m_130258_();
            this.taskId = buffer.m_130259_();
            this.message = buffer.m_130238_();
        }

        @Override
        public void process(Player player) {
            this.processClient();
        }

        @OnlyIn(value=Dist.CLIENT)
        public void processClient() {
            Minecraft mc = Minecraft.m_91087_();
            mc.m_91152_((Screen)new ProgressScreen(mc.f_91080_, this.taskId, this.max, this.message));
        }
    }
}

