/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.networking.packets;

import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.TextUtil;
import pregenerator.client.gui.PregenMenu;
import pregenerator.common.base.TaskStorage;
import pregenerator.common.deleter.tasks.IDeletionTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.utils.misc.PregenAction;

public class CommandPacket {

    public static class AnswerPerms
    implements IPregenPacket {
        List<PregenAction> perms = new ObjectArrayList();

        public AnswerPerms() {
        }

        public AnswerPerms(List<PregenAction> perms) {
            this.perms = perms;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            IPregenPacket.writeCollectionReverse(buffer, this.perms, FriendlyByteBuf::m_130068_);
        }

        @Override
        public void read(FriendlyByteBuf buffer) {
            IPregenPacket.readCollection(buffer, this.perms, T -> (PregenAction)T.m_130066_(PregenAction.class));
        }

        @Override
        public void process(Player player) {
            this.processClient();
        }

        @OnlyIn(value=Dist.CLIENT)
        private void processClient() {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof PregenMenu) {
                ((PregenMenu)screen).receivePermissions(this.perms);
            }
        }
    }

    public static class RequestPerms
    implements IPregenPacket.IRequestPacket {
        @Override
        public void process(Player player) {
            NetworkManager.INSTANCE.sendToPlayer(new AnswerPerms(ChunkPregenerator.getValidActions(player)), player);
        }
    }

    public static class DeletionTask
    implements IPregenPacket {
        IDeletionTask task;

        public DeletionTask() {
        }

        public DeletionTask(IDeletionTask task) {
            this.task = task;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130079_(IDeletionTask.saveTask(this.task));
        }

        @Override
        public void read(FriendlyByteBuf buffer) {
            this.task = IDeletionTask.loadTask(buffer.m_130260_());
        }

        @Override
        public void process(Player player) {
            if (this.task == null || !ChunkPregenerator.canDoAction(player, PregenAction.COMMANDS)) {
                return;
            }
            ServerManager.INSTANCE.startTask(this.task, player.m_20148_(), arg_0 -> ((Player)player).m_213846_(arg_0));
        }
    }

    public static class GenTask
    implements IPregenPacket {
        ITask task;

        public GenTask() {
        }

        public GenTask(ITask task) {
            this.task = task;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130079_(ITask.saveTask(this.task));
        }

        @Override
        public void read(FriendlyByteBuf buffer) {
            this.task = ITask.loadTask(buffer.m_130260_());
        }

        @Override
        public void process(Player player) {
            if (this.task == null || !ChunkPregenerator.canDoAction(player, PregenAction.COMMANDS)) {
                return;
            }
            ServerManager.INSTANCE.startTask(this.task, player.m_20148_(), arg_0 -> ((Player)player).m_213846_(arg_0));
        }
    }

    public static class Action
    implements IPregenPacket {
        int action;

        public Action() {
        }

        public Action(int action) {
            this.action = action;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130130_(this.action);
        }

        @Override
        public void read(FriendlyByteBuf buffer) {
            this.action = buffer.m_130242_();
        }

        @Override
        public void process(Player player) {
            if (this.action < 5) {
                if (!ChunkPregenerator.canDoAction(player, PregenAction.COMMANDS)) {
                    player.m_5661_((Component)TextUtil.translate("network.chunk_pregen.failures.no_permissions"), false);
                    return;
                }
                switch (this.action) {
                    case 0: {
                        ServerManager.INSTANCE.pauseTask(null, arg_0 -> ((Player)player).m_213846_(arg_0));
                        break;
                    }
                    case 1: {
                        ServerManager.INSTANCE.resumeTask(null, arg_0 -> ((Player)player).m_213846_(arg_0));
                        break;
                    }
                    case 2: {
                        ServerManager.INSTANCE.stopTask(null, arg_0 -> ((Player)player).m_213846_(arg_0), false);
                        break;
                    }
                    case 3: {
                        ServerManager.INSTANCE.continueTask(arg_0 -> ((Player)player).m_213846_(arg_0));
                        break;
                    }
                    case 4: {
                        ServerManager.INSTANCE.removeTask(null, arg_0 -> ((Player)player).m_213846_(arg_0));
                    }
                }
            } else {
                switch (this.action) {
                    case 5: {
                        TaskStorage.getListeners().add(player.m_20148_(), true);
                        break;
                    }
                    case 6: {
                        TaskStorage.getListeners().add(player.m_20148_(), false);
                        break;
                    }
                    case 7: {
                        TaskStorage.getListeners().remove(player.m_20148_());
                        break;
                    }
                    case 8: {
                        ServerManager.INSTANCE.addListener(player.m_20148_());
                        break;
                    }
                    case 9: {
                        ServerManager.INSTANCE.removeListener(player.m_20148_());
                    }
                }
            }
            Request.processPlayer(player);
        }
    }

    public static class Answer
    implements IPregenPacket {
        int listeningState;
        boolean listening;
        int totalTasks;
        int runningTasks;
        int pausedTasks;

        public Answer() {
        }

        public Answer(int listeningState, boolean listening, int totalTasks, int runningTasks, int pausedTasks) {
            this.listeningState = listeningState;
            this.listening = listening;
            this.totalTasks = totalTasks;
            this.runningTasks = runningTasks;
            this.pausedTasks = pausedTasks;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130130_(this.listeningState);
            buffer.writeBoolean(this.listening);
            buffer.m_130130_(this.totalTasks);
            buffer.m_130130_(this.runningTasks);
            buffer.m_130130_(this.pausedTasks);
        }

        @Override
        public void read(FriendlyByteBuf buffer) {
            this.listeningState = buffer.m_130242_();
            this.listening = buffer.readBoolean();
            this.totalTasks = buffer.m_130242_();
            this.runningTasks = buffer.m_130242_();
            this.pausedTasks = buffer.m_130242_();
        }

        @Override
        public void process(Player player) {
            this.processClient();
        }

        @OnlyIn(value=Dist.CLIENT)
        private void processClient() {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof PregenMenu) {
                ((PregenMenu)screen).receiveData(this.listeningState, this.listening, this.totalTasks, this.runningTasks, this.pausedTasks);
            }
        }
    }

    public static class Request
    implements IPregenPacket.IRequestPacket {
        @Override
        public void process(Player player) {
            Request.processPlayer(player);
        }

        public static void processPlayer(Player player) {
            int[] result = new int[3];
            if (ChunkPregenerator.canDoAction(player, PregenAction.COMMANDS)) {
                result = ServerManager.INSTANCE.getTasks((G, D, A) -> {
                    int[] output = new int[3];
                    output[0] = G.size() + D.size();
                    output[1] = A.size();
                    BooleanIterator booleanIterator = A.values().iterator();
                    while (booleanIterator.hasNext()) {
                        boolean entry = (Boolean)booleanIterator.next();
                        output[2] = output[2] + (entry ? 0 : 1);
                    }
                    return output;
                });
            }
            NetworkManager.INSTANCE.sendToPlayer(new Answer(TaskStorage.getListeners().getState(player.m_20148_()), ServerManager.INSTANCE.isListening(player.m_20148_()), result[0], result[1], result[2]), player);
        }
    }
}

