/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.manager;

import carbonconfiglib.config.ConfigEntry;
import com.google.common.base.Supplier;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.time.DurationFormatUtils;
import pregenerator.ChunkPregenerator;
import pregenerator.PregenConfig;
import pregenerator.base.api.TextUtil;
import pregenerator.base.mixins.common.server.MinecraftServerMixin;
import pregenerator.base.mixins.common.storage.ChunkLoaderMixin;
import pregenerator.base.mixins.common.storage.IOWorkerMixin;
import pregenerator.base.mixins.common.storage.RegionFileCacheMixin;
import pregenerator.common.base.IBaseTask;
import pregenerator.common.base.IMiniTask;
import pregenerator.common.base.ListenerStorage;
import pregenerator.common.base.PregenTaskEvent;
import pregenerator.common.base.ProcessListener;
import pregenerator.common.base.TaskStorage;
import pregenerator.common.deleter.ChunkDeleter;
import pregenerator.common.deleter.DeletionProcessor;
import pregenerator.common.deleter.tasks.IDeletionTask;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.ChunkProcessor;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.BenchmarkManager;
import pregenerator.common.manager.IProcess;
import pregenerator.common.manager.TaskQueue;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.networking.packets.CommandPacket;
import pregenerator.common.networking.packets.TaskPacket;
import pregenerator.common.utils.collections.SynchronizedLong2ObjectLinkedOpenHashMap;
import pregenerator.common.utils.config.internal.SpeedEntry;
import pregenerator.common.utils.misc.AverageCounter;

public class ServerManager {
    public static final ServerManager INSTANCE = new ServerManager();
    public Object2ObjectMap<ResourceKey<Level>, IProcess<?, ?>> processor = new Object2ObjectLinkedOpenHashMap();
    public TaskQueue<ChunkProcess, ITask, ChunkProcessor> generation = new TaskQueue(true, ChunkProcessor.class, (Map<ResourceKey<Level>, IProcess<?, ?>>)this.processor, TaskStorage::getGenStorage);
    public TaskQueue<ChunkDeleter, IDeletionTask, DeletionProcessor> deletion = new TaskQueue(false, DeletionProcessor.class, (Map<ResourceKey<Level>, IProcess<?, ?>>)this.processor, TaskStorage::getDeletionStorage);
    Map<UUID, IMiniTask> miniTasks = new Object2ObjectLinkedOpenHashMap();
    Set<ProcessListener> listeners = new ObjectLinkedOpenHashSet();
    AverageCounter memoryAverage = new AverageCounter(600);
    int size;
    boolean wasActive = false;

    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        int index = PregenConfig.INSTANCE.threadingRule.get();
        int cores = Runtime.getRuntime().availableProcessors();
        this.size = index == 0 ? 1 : Math.max(1, cores / Math.max(1, 10 - index * 2));
        this.generation.populate(this.size, (Supplier<ChunkProcessor>)((Supplier)ChunkProcessor::new));
        this.deletion.populate(this.size, (Supplier<DeletionProcessor>)((Supplier)DeletionProcessor::new));
    }

    public int getProcessors() {
        return this.size;
    }

    private MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public long getSeed() {
        return this.getServer().m_129880_(Level.f_46428_).m_7328_();
    }

    public float getChunksPerTick(ResourceKey<Level> dimension) {
        IProcess process = (IProcess)this.processor.get(dimension);
        if (process instanceof ChunkProcessor) {
            return ((ChunkProcessor)process).getActiveSpeed();
        }
        SpeedEntry entry = (SpeedEntry)PregenConfig.INSTANCE.mappedSpeedConfig.get(dimension);
        return entry == null ? 1.0f : entry.getSpeed();
    }

    public <T> T getTasks(TaskPacket.TaskFunction<T> creator) {
        Object2BooleanLinkedOpenHashMap map = new Object2BooleanLinkedOpenHashMap();
        for (IProcess value : this.processor.values()) {
            UUID id = value.getTaskId();
            if (id == null) continue;
            map.put((Object)id, value.isRunning());
        }
        return creator.apply(this.generation.getTasks(), this.deletion.getTasks(), (Object2BooleanMap<UUID>)map);
    }

    public void startMiniTask(UUID taskId, IMiniTask task) {
        this.miniTasks.put(taskId, task);
    }

    public void interruptMiniTask(UUID taskId) {
        IMiniTask task = this.miniTasks.remove(taskId);
        if (task != null) {
            task.interrupt();
        }
    }

    public boolean hasRetroBlockingTask() {
        for (IProcess process : this.processor.values()) {
            if (!process.isBlockingRetrogen()) continue;
            return true;
        }
        return false;
    }

    public int startTask(IBaseTask<?> task, UUID id, Consumer<Component> listener) {
        if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
            listener.accept((Component)TextUtil.translate("command.chunk_pregen.benchmark.active_queue"));
            return 0;
        }
        if (ServerLifecycleHooks.getCurrentServer() instanceof DedicatedServer && Runtime.getRuntime().availableProcessors() <= 1 && PregenConfig.INSTANCE.showDockerWarning.get()) {
            listener.accept((Component)TextUtil.translate("command.chunk_pregen.misc.docker").m_6879_().m_130940_(ChatFormatting.DARK_RED));
        }
        if (task instanceof ITask) {
            ITask gen = (ITask)task;
            if (!ProcessListener.PREVIEW.getOwner().equals(id)) {
                gen.setOwner(id);
            }
            if (this.generation.startTask(gen, listener, this.getServer())) {
                this.updateListeners(id, true);
            }
        } else if (task instanceof IDeletionTask && this.deletion.startTask((IDeletionTask)task, listener, this.getServer())) {
            this.updateListeners(id, true);
        }
        this.updateAutoRestart();
        return 0;
    }

    public int pauseTask(String taskName, Consumer<Component> listener) {
        if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
            listener.accept((Component)Component.m_237113_((String)"Benchmark Running. Pause is disabled"));
            return 0;
        }
        boolean found = false;
        for (IProcess entry : this.processor.values()) {
            if (taskName != null && !taskName.equalsIgnoreCase(entry.getTaskName()) || !entry.isRunning()) continue;
            entry.pauseTask();
            found = true;
            listener.accept((Component)Component.m_237113_((String)("Pausing [" + entry.getTaskName() + "] Task")));
        }
        if (!found) {
            listener.accept((Component)Component.m_237113_((String)"No Tasks Paused"));
        }
        return 0;
    }

    public int resumeTask(String taskName, Consumer<Component> listener) {
        if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
            listener.accept((Component)Component.m_237113_((String)"Benchmark Running. Resume is disabled"));
            return 0;
        }
        boolean found = false;
        for (IProcess entry : this.processor.values()) {
            if (taskName != null && !taskName.equalsIgnoreCase(entry.getTaskName()) || entry.isRunning()) continue;
            entry.resumeTask();
            found = true;
            listener.accept((Component)Component.m_237113_((String)("Resuming [" + entry.getTaskName() + "] Task")));
        }
        if (!found) {
            listener.accept((Component)Component.m_237113_((String)"No Tasks Resuming"));
        }
        return 0;
    }

    public int stopTask(String taskName, Consumer<Component> listener, boolean interrupt) {
        boolean found = false;
        ObjectIterator iter = this.processor.values().iterator();
        while (iter.hasNext()) {
            IProcess entry = (IProcess)iter.next();
            if (taskName != null && !taskName.equalsIgnoreCase(entry.getTaskName())) continue;
            listener.accept((Component)Component.m_237113_((String)("Stopping [" + entry.getTaskName() + "] Task")));
            entry.stopTask();
            found = true;
            if (entry.isMultithreaded()) continue;
            this.generation.consume(entry);
            this.deletion.consume(entry);
            iter.remove();
        }
        if (!found) {
            listener.accept((Component)Component.m_237113_((String)"No Tasks Paused"));
        } else {
            this.listeners.clear();
            MinecraftForge.EVENT_BUS.post((Event)new PregenTaskEvent.StoppedAll());
        }
        if (!this.isRunning() && !interrupt) {
            PregenConfig.INSTANCE.autoRestart.set((Object)false);
            PregenConfig.INSTANCE.save();
        }
        if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
            BenchmarkManager.INSTANCE.interruptBenchmark();
        }
        return 0;
    }

    public int removeTask(String taskName, Consumer<Component> listener) {
        this.stopTask(taskName, listener, false);
        int total = this.generation.removeTasks(taskName) + this.deletion.removeTasks(taskName);
        listener.accept((Component)Component.m_237113_((String)(total > 0 ? "Deleted [" + total + "] Tasks" : "No Tasks Deleted")));
        return 0;
    }

    public int continueTask(String name, UUID id, Consumer<Component> listener) {
        if (this.deletion.continueTask(name, listener, this.getServer())) {
            this.updateListeners(id, true);
            this.updateAutoRestart();
        } else if (this.generation.continueTask(name, listener, this.getServer())) {
            this.updateListeners(id, true);
            this.updateAutoRestart();
        }
        return 0;
    }

    public int continueTask(Consumer<Component> listener) {
        this.updateListeners(null, true);
        MinecraftServer server = this.getServer();
        boolean found = true;
        while (this.deletion.findNextTask(listener, server, true)) {
            found = false;
        }
        if (found) {
            while (this.generation.findNextTask(listener, server, true)) {
                found = false;
            }
        }
        this.updateAutoRestart();
        return 0;
    }

    public void onTaskFinished(ResourceKey<Level> type) {
        IProcess entry = (IProcess)this.processor.remove(type);
        if (entry != null) {
            this.generation.consume(entry);
            this.deletion.consume(entry);
        }
        this.updateListeners(null, true);
        Consumer<Component> listener = this::listen;
        MinecraftServer server = this.getServer();
        boolean found = true;
        while (this.deletion.findNextTask(listener, server, true)) {
            found = false;
        }
        if (found) {
            while (this.generation.findNextTask(listener, server, true)) {
                found = false;
            }
        }
        if (found && !this.isRunning()) {
            BenchmarkManager.INSTANCE.onBenchmarksFinished(this::listen);
            if (this.shouldFinishListening()) {
                this.listeners.clear();
            }
        }
        this.updateAutoRestart();
    }

    public void listen(Component text) {
        try {
            for (ProcessListener listener : this.listeners) {
                listener.sendMessage(text);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            for (IProcess process : new ObjectArrayList(this.processor.values())) {
                process.onTickStart();
            }
            return;
        }
        int limit = PregenConfig.INSTANCE.playerLimit.get();
        boolean paused = limit >= 0 && limit <= ServerLifecycleHooks.getCurrentServer().m_7416_();
        long startTime = System.currentTimeMillis();
        for (IProcess process : new ObjectArrayList(this.processor.values())) {
            process.onTickStop(paused);
        }
        if (!paused && this.processor.size() > 0 && PregenConfig.INSTANCE.enableMemoryProtector.get()) {
            this.memoryAverage.addMore(this.freeMemory());
            this.memoryAverage.onFinished();
            if (PregenConfig.INSTANCE.requiredFreeMemory.get() > this.memoryAverage.getAverage()) {
                this.stopTask(null, T -> {}, true);
                for (ServerLevel level : event.getServer().m_129785_()) {
                    boolean save = level.f_8564_;
                    level.f_8564_ = false;
                    level.m_8643_(null, true, false);
                    level.f_8564_ = save;
                }
                ChunkPregenerator.LOGGER.info("Chunk Pregenerators Memory Protector is enabled. (Can be disabled in the config)");
                ChunkPregenerator.LOGGER.info("Free Memory [" + this.memoryAverage.getAverage() + "MB] is below the suggested safe value [" + PregenConfig.INSTANCE.requiredFreeMemory.get() + "MB]");
                ChunkPregenerator.LOGGER.info("This risks World Corruption due to running out of ram.");
                ChunkPregenerator.LOGGER.info("To prevent this a forceful restart is being done!");
                ChunkPregenerator.LOGGER.info("The Worlds and Pregen Progress have been saved!");
                ChunkPregenerator.LOGGER.info("Restarting now!");
                ServerLifecycleHooks.handleExit((int)0);
            }
        }
        if (this.processor.size() > 0 && PregenConfig.INSTANCE.enableLoginWarning.get()) {
            server = event.getServer();
            long longest = 0L;
            for (IProcess process : this.processor.values()) {
                longest = Math.max(longest, process.getExpectedTime());
            }
            MutableComponent time = TextUtil.literal("Pregeneration Active! ETA: ~" + DurationFormatUtils.formatDuration((long)longest, (String)"HH:mm:ss")).m_130940_(ChatFormatting.RED);
            this.setStatus(server, (Component)TextUtil.empty().m_7220_((Component)time).m_130946_("\n").m_7220_((Component)TextUtil.literal(server.m_129916_())));
            this.wasActive = true;
        } else if (this.wasActive) {
            this.wasActive = false;
            server = event.getServer();
            this.setStatus(server, (Component)TextUtil.literal(server.m_129916_()));
        }
        boolean removed = false;
        Iterator<IMiniTask> iter = this.miniTasks.values().iterator();
        while (iter.hasNext()) {
            if (iter.next().update(startTime)) continue;
            iter.remove();
            removed = true;
        }
        if (removed && this.shouldFinishListening()) {
            this.listeners.clear();
        }
    }

    private void setStatus(MinecraftServer server, Component message) {
        MinecraftServerMixin mixin = (MinecraftServerMixin)server;
        ServerStatus status = server.m_129928_();
        mixin.setPregenStatus(new ServerStatus(message, status.f_134901_(), status.f_134902_(), status.f_134903_(), status.f_242955_(), status.forgeData()));
        mixin.rebuildPregenStatus(server.m_129928_());
    }

    public byte[] sendData() {
        if (this.processor.isEmpty() && this.miniTasks.isEmpty()) {
            return new byte[0];
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(this.processor.size());
        for (Object entry : this.processor.object2ObjectEntrySet()) {
            buf.m_130085_(((ResourceKey)entry.getKey()).m_135782_());
            buf.writeByte((int)((IProcess)entry.getValue()).getClientDataId());
            FriendlyByteBuf friendlyByteBuf = new FriendlyByteBuf(Unpooled.buffer());
            ((IProcess)entry.getValue()).sendClientData(friendlyByteBuf);
            byte[] data = new byte[friendlyByteBuf.writerIndex()];
            friendlyByteBuf.readBytes(data);
            buf.m_130087_(data);
        }
        int usableMiniTasks = 0;
        for (IMiniTask iMiniTask : this.miniTasks.values()) {
            if (!iMiniTask.hasClientOverlay()) continue;
            ++usableMiniTasks;
        }
        buf.writeInt(usableMiniTasks);
        for (Map.Entry entry : this.miniTasks.entrySet()) {
            IMiniTask task = (IMiniTask)entry.getValue();
            if (!task.hasClientOverlay()) continue;
            buf.m_130077_((UUID)entry.getKey());
            buf.writeByte((int)task.getClientDataId());
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
            task.writeData(buffer);
            byte[] data = new byte[buffer.writerIndex()];
            buffer.readBytes(data);
            buf.m_130087_(data);
        }
        byte[] data = new byte[buf.writerIndex()];
        buf.readBytes(data);
        return data;
    }

    public void addListener(UUID id) {
        this.listeners.add(ProcessListener.create(id));
    }

    public void updateListeners(UUID id, boolean triggerAuto) {
        ListenerStorage storage = TaskStorage.getListeners();
        if (!storage.isIgnoring(id)) {
            this.listeners.add(ProcessListener.create(id));
        }
        if (triggerAuto) {
            TaskStorage.getListeners().updateListeners(this.listeners);
        }
    }

    public void removeListener(UUID id) {
        this.listeners.remove(ProcessListener.create(id));
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        this.removeListener(event.getEntity().m_20148_());
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        UUID id = event.getEntity().m_20148_();
        if (this.getServer().m_129792_() && !TaskStorage.getListeners().contains(id)) {
            TaskStorage.getListeners().add(id, !PregenConfig.INSTANCE.pregenOverlay.isEnabled());
        }
        if (TaskStorage.getListeners().isAutoListening(id)) {
            this.listeners.add(ProcessListener.create(id));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerServerJoinEvent(ClientPlayerNetworkEvent.LoggingIn event) {
        if (PregenConfig.INSTANCE.pregenOverlay.isEnabled()) {
            NetworkManager.INSTANCE.sendToServer(new CommandPacket.Action(6));
        }
    }

    @SubscribeEvent
    public void onServerStopped(ServerStoppingEvent event) {
        this.stopTask(null, T -> {}, true);
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartingEvent event) {
        if (!TaskStorage.getListeners().contains(null)) {
            TaskStorage.getListeners().add(null, true);
        }
        if (PregenConfig.INSTANCE.autoRestart.get()) {
            this.onTaskFinished(null);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor world = event.getLevel();
        if (world instanceof ServerLevel) {
            try {
                RegionFileCacheMixin mixin = (RegionFileCacheMixin)((IOWorkerMixin)((ChunkLoaderMixin)((ServerLevel)world).m_7726_().f_8325_).getWorker()).getStorage();
                Long2ObjectLinkedOpenHashMap<RegionFile> cache = mixin.getRegionCache();
                mixin.setRegionCache(new SynchronizedLong2ObjectLinkedOpenHashMap<RegionFile>((Map<Long, RegionFile>)cache));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void updateAutoRestart() {
        ConfigEntry.BoolValue value = PregenConfig.INSTANCE.autoRestart;
        if (value.get() != this.isRunning()) {
            value.set((Object)this.isRunning());
            PregenConfig.INSTANCE.save();
        }
    }

    public boolean hasProcessorsLeft() {
        return !this.generation.isEmpty();
    }

    public boolean isRunning() {
        return this.processor.size() > 0;
    }

    public boolean isRunning(ResourceKey<Level> type) {
        return this.processor.get(type) != null;
    }

    public boolean shouldFinishListening() {
        return this.processor.isEmpty() && this.miniTasks.isEmpty();
    }

    public long[] getData(ResourceKey<Level> target) {
        long[] data = new long[6];
        for (IProcess entry : this.processor.values()) {
            if (!(entry instanceof ChunkProcessor)) continue;
            ChunkProcessor process = (ChunkProcessor)entry;
            data[0] = data[0] + process.getTotal();
            data[1] = data[1] + process.getGenDone();
            data[2] = data[2] + process.getLightDone();
        }
        IProcess entry = (IProcess)this.processor.get(target);
        if (entry instanceof ChunkProcessor) {
            ChunkProcessor process = (ChunkProcessor)entry;
            data[3] = data[3] + process.getTotal();
            data[4] = data[4] + process.getGenDone();
            data[5] = data[5] + process.getLightDone();
        }
        return data;
    }

    public boolean isListening(UUID id) {
        return this.listeners.contains(ProcessListener.create(id));
    }

    int freeMemory() {
        Runtime rn = Runtime.getRuntime();
        return (int)(rn.maxMemory() - rn.totalMemory() + rn.freeMemory() >> 20);
    }
}

