/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.base;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import pregenerator.common.base.IBaseTask;

public class SimpleTaskStorage<T extends IBaseTask<?>> {
    Object2ObjectMap<String, T> taskStorage = new Object2ObjectLinkedOpenHashMap();
    ObjectSet<String> activeTasks = new ObjectLinkedOpenHashSet();
    Function<CompoundTag, T> loader;
    Function<T, CompoundTag> saver;
    Runnable dirtyCall;

    public SimpleTaskStorage(Runnable dirtyCall, Function<CompoundTag, T> loader, Function<T, CompoundTag> saver) {
        this.dirtyCall = dirtyCall;
        this.loader = loader;
        this.saver = saver;
    }

    public void read(CompoundTag nbt) {
        ListTag list = nbt.m_128437_("tasks", 10);
        int m = list.size();
        for (int i = 0; i < m; ++i) {
            IBaseTask entry = (IBaseTask)this.loader.apply(list.m_128728_(i));
            if (entry == null) continue;
            this.taskStorage.put((Object)entry.getName(), (Object)entry);
        }
    }

    public CompoundTag write(CompoundTag compound) {
        ListTag list = new ListTag();
        for (IBaseTask entry : this.taskStorage.values()) {
            CompoundTag nbt = this.saver.apply(entry);
            if (nbt == null) continue;
            list.add((Object)nbt);
        }
        compound.m_128365_("tasks", (Tag)list);
        return compound;
    }

    public boolean addTask(T task) {
        if (task != null && this.taskStorage.putIfAbsent((Object)task.getName(), task) == null) {
            this.markDirty();
            return true;
        }
        return false;
    }

    public Set<String> getTasks() {
        return this.taskStorage.keySet();
    }

    public List<T> getTaskEntries() {
        return new ObjectArrayList(this.taskStorage.values());
    }

    public Set<String> getActiveTasks() {
        return this.activeTasks;
    }

    public T getTask(String name) {
        return (T)((IBaseTask)this.taskStorage.get((Object)name));
    }

    public boolean isTaskActive(String name) {
        return this.activeTasks.contains((Object)name);
    }

    public boolean stopTask(String name) {
        return this.activeTasks.remove((Object)name);
    }

    public void startTask(String name) {
        this.activeTasks.add((Object)name);
    }

    public boolean removeTask(String name) {
        IBaseTask task = (IBaseTask)this.taskStorage.remove((Object)name);
        if (task != null) {
            this.activeTasks.remove((Object)name);
            this.markDirty();
        }
        return task != null;
    }

    public T getNextTask(Set<ResourceKey<Level>> presentTypes) {
        for (IBaseTask task : this.taskStorage.values()) {
            if (this.activeTasks.contains((Object)task.getName()) || presentTypes.contains(task.getDimension())) continue;
            this.activeTasks.add((Object)task.getName());
            return (T)task;
        }
        return null;
    }

    public void clear() {
        this.activeTasks.clear();
        this.taskStorage.clear();
        this.markDirty();
    }

    public int size() {
        return this.taskStorage.size();
    }

    protected Runnable getDirtyCall() {
        return this.dirtyCall;
    }

    public void markDirty() {
        this.dirtyCall.run();
    }
}

