/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.info;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.time.DurationFormatUtils;
import pregenerator.PregenConfig;
import pregenerator.base.api.Align;
import pregenerator.base.api.IRenderHelper;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.comp.PregenButton;
import pregenerator.client.info.IProcessorInfo;
import pregenerator.client.info.IRenderObj;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.networking.packets.TaskPacket;
import pregenerator.common.utils.misc.Area;

public class PregenProcessorInfo
implements IProcessorInfo {
    List<IRenderObj> objects = new ObjectArrayList();
    float height = 0.0f;
    boolean minimized = false;
    ResourceKey<Level> dimension;

    @Override
    public void setDimension(ResourceKey<Level> dimension) {
        this.dimension = dimension;
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        boolean preparing = buffer.readBoolean();
        String taskName = buffer.m_130277_();
        byte modeValue = buffer.readByte();
        GenerationType type = modeValue < 0 ? null : GenerationType.values()[modeValue];
        long totalMemory = buffer.readLong();
        long maxMemory = buffer.readLong();
        long freeMemory = buffer.readLong();
        long prepValue = 0L;
        long prepMax = 0L;
        boolean running = false;
        boolean validating = false;
        long validationProgress = 0L;
        long validationTotal = 0L;
        boolean multithreaded = false;
        long duration = 0L;
        long totalChunks = 0L;
        long terrainDone = 0L;
        float speed_terrain = 0.0f;
        long lightDone = 0L;
        float speed_light = 0.0f;
        int pointsOfInterest = 0;
        int chunksLoaded = 0;
        long lightQueue = 0L;
        int chunksToUnload = 0;
        Area area = null;
        if (preparing) {
            prepValue = buffer.readLong();
            prepMax = buffer.readLong();
        } else {
            running = buffer.readBoolean();
            validating = buffer.readBoolean();
            if (validating) {
                validationProgress = buffer.readLong();
                validationTotal = buffer.readLong();
            }
            multithreaded = buffer.readBoolean();
            duration = buffer.readLong();
            totalChunks = buffer.readLong();
            terrainDone = buffer.readLong();
            speed_terrain = buffer.readFloat();
            lightDone = buffer.readLong();
            speed_light = buffer.readFloat();
            pointsOfInterest = buffer.readInt();
            chunksLoaded = buffer.readInt();
            lightQueue = buffer.readLong();
            chunksToUnload = buffer.readInt();
            if (buffer.readBoolean()) {
                area = new Area(buffer);
            }
        }
        this.objects.clear();
        this.objects.add(new HeaderMenu());
        this.objects.add(IRenderObj.text("ui.chunk_pregen.generator.header", Align.CENTER));
        this.objects.add(IRenderObj.padding(1.0f));
        this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.name", taskName));
        if (type != null) {
            this.objects.add(IRenderObj.text((Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.task_type").m_6879_().m_130946_(" ").m_7220_(type.createText())));
        }
        if (this.minimized) {
            if (preparing) {
                this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.prep"));
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.deleter.prep.progress", NUMBERS.format(prepValue), NUMBERS.format(prepMax), (float)prepValue / (float)prepMax));
                this.objects.add(IRenderObj.padding(1.0f));
            } else if (!running) {
                this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.paused"));
            } else {
                this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.running_time", this.getTime(duration)));
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.deleter.progress", NUMBERS.format(lightDone), NUMBERS.format(totalChunks), Math.min(1.0f, (float)lightDone / (float)totalChunks)));
                this.objects.add(IRenderObj.padding(1.0f));
            }
        } else {
            this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.dimension", this.dimension == null ? TextUtil.translate("ui.chunk_pregen.deleter.dimension.unknown") : TextUtil.dimension(this.dimension)));
            if (preparing) {
                this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.prep"));
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.tracker.ram", NUMBERS.format(totalMemory - freeMemory >> 20), NUMBERS.format(maxMemory >> 20), maxMemory <= 0L ? 0.0f : (float)(totalMemory - freeMemory) / (float)maxMemory));
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.deleter.prep.progress", NUMBERS.format(prepValue), NUMBERS.format(prepMax), (float)prepValue / (float)prepMax));
            } else if (!running) {
                this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.paused"));
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.tracker.ram", NUMBERS.format(totalMemory - freeMemory >> 20), NUMBERS.format(maxMemory >> 20), maxMemory <= 0L ? 0.0f : (float)(totalMemory - freeMemory) / (float)maxMemory));
                this.objects.add(IRenderObj.padding(1.0f));
            } else {
                this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.running_time", DurationFormatUtils.formatDuration((long)duration, (String)"HH:mm:ss")));
                if (area != null) {
                    this.objects.add(IRenderObj.text("ui.chunk_pregen.generator.working_area"));
                    this.objects.add(IRenderObj.text("ui.chunk_pregen.generator.working_area.from", area.getMinX(), area.getMinZ()));
                    this.objects.add(IRenderObj.text("ui.chunk_pregen.generator.working_area.to", area.getMaxX(), area.getMaxZ()));
                } else {
                    this.objects.add(IRenderObj.text("ui.chunk_pregen.generator.working_area.fetching"));
                }
                this.objects.add(IRenderObj.text(multithreaded ? "ui.chunk_pregen.generator.eta_full" : "ui.chunk_pregen.generator.eta_small", this.getTime((long)((float)(totalChunks - terrainDone) / speed_terrain) * 50L), this.getTime((long)((float)(totalChunks - lightDone) / speed_light) * 50L)));
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.tracker.ram", NUMBERS.format(totalMemory - freeMemory >> 20), NUMBERS.format(maxMemory >> 20), maxMemory <= 0L ? 0.0f : (float)(totalMemory - freeMemory) / (float)maxMemory));
                this.objects.add(IRenderObj.padding(2.0f));
                if (multithreaded) {
                    this.objects.add(IRenderObj.text("ui.chunk_pregen.generator.terrain_progress", FLOATING_NUMBERS.format(speed_terrain)));
                    this.objects.add(IRenderObj.bar("ui.chunk_pregen.deleter.progress", NUMBERS.format(terrainDone), NUMBERS.format(totalChunks), totalChunks == 0L ? 0.0f : (float)terrainDone / (float)totalChunks));
                    this.objects.add(IRenderObj.padding(2.0f));
                }
                this.objects.add(IRenderObj.text(multithreaded ? "ui.chunk_pregen.generator.light_progress" : "ui.chunk_pregen.generator.progress", FLOATING_NUMBERS.format(speed_light)));
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.deleter.progress", NUMBERS.format(lightDone), NUMBERS.format(totalChunks), totalChunks == 0L ? 0.0f : (float)lightDone / (float)totalChunks));
                this.objects.add(IRenderObj.padding(2.0f));
                if (validating) {
                    this.objects.add(IRenderObj.text("ui.chunk_pregen.generator.validating"));
                    this.objects.add(IRenderObj.bar("ui.chunk_pregen.deleter.progress", NUMBERS.format(validationProgress), NUMBERS.format(validationTotal), validationTotal == 0L ? 0.0f : (float)validationProgress / (float)validationTotal));
                }
                this.objects.add(IRenderObj.text(multithreaded ? "ui.chunk_pregen.generator.queue_full" : "ui.chunk_pregen.generator.queue_small", NUMBERS.format(lightQueue), NUMBERS.format(chunksToUnload)));
                this.objects.add(IRenderObj.text("ui.chunk_pregen.generator.vanilla_info", NUMBERS.format(chunksLoaded), NUMBERS.format(pointsOfInterest)));
            }
        }
        this.objects.add(new FooterMenu(running, taskName));
        this.height = IRenderObj.height(this.objects);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(IRenderHelper helper, int x, int y, float scale) {
        helper.setupCanvasSize(100.0f);
        helper.drawArea(x, y, 100.0f, this.height - 2.0f);
        float yOffset = 3.0f;
        for (IRenderObj obj : this.objects) {
            obj.render(helper, x + 4, (float)y + yOffset, 100.0f, scale);
            yOffset += obj.height();
        }
    }

    @Override
    public boolean onClick(int mouseX, int mouseY) {
        for (IRenderObj obj : this.objects) {
            if (!obj.onClick(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getID() {
        return 1;
    }

    @Override
    public int getWidth() {
        return 109;
    }

    @Override
    public int getHeight() {
        return (int)this.height + 6;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class HeaderMenu
    extends IRenderObj.Interactable {
        PregenButton close = this.addChild(new PregenButton(0, 0, 12, 12, (Component)TextUtil.literal("X"), this::onClose));
        PregenButton minimize = this.addChild(new PregenButton(0, 0, 12, 12, (Component)TextUtil.literal("_"), this::onMinimize));

        @Override
        public float height() {
            return 0.0f;
        }

        private void onClose(Button button) {
            PregenConfig.INSTANCE.pregenOverlay.setEnabled(false);
            PregenConfig.INSTANCE.save();
        }

        private void onMinimize(Button button) {
            PregenProcessorInfo.this.minimized = !PregenProcessorInfo.this.minimized;
        }

        @Override
        public void setupInteractables(float x, float y, float width, float scale, float posScale) {
            this.close.m_252865_((int)((x + width - 2.0f) * posScale) - (int)((float)this.close.m_5711_() * 0.5f * scale));
            this.close.m_253211_((int)((y - 1.0f) * posScale));
            this.minimize.m_252865_((int)((x + width - 8.0f) * posScale) - (int)((float)this.minimize.m_5711_() * 0.5f * scale));
            this.minimize.m_253211_((int)((y - 1.0f) * posScale));
        }
    }

    public static class FooterMenu
    extends IRenderObj.Interactable {
        PregenButton remove = this.addChild(new PregenButton(0, 0, 50, 14, (Component)TextUtil.translate("ui.chunk_pregen.deleter.remove"), this::onRemove));
        PregenButton stop = this.addChild(new PregenButton(0, 0, 50, 14, (Component)TextUtil.translate("ui.chunk_pregen.deleter.stop"), this::onStop));
        PregenButton pause;
        boolean paused;
        String taskId;

        public FooterMenu(boolean paused, String taskId) {
            this.paused = paused;
            this.taskId = taskId;
            this.pause = this.addChild(new PregenButton(0, 0, 50, 14, (Component)TextUtil.translate(paused ? "ui.chunk_pregen.deleter.pause" : "ui.chunk_pregen.deleter.resume"), this::onPause));
        }

        @Override
        public float height() {
            return 7.0f;
        }

        private void onRemove(Button button) {
            NetworkManager.INSTANCE.sendToServer(new TaskPacket.Action(4, this.taskId));
        }

        private void onStop(Button button) {
            NetworkManager.INSTANCE.sendToServer(new TaskPacket.Action(2, this.taskId));
        }

        private void onPause(Button button) {
            NetworkManager.INSTANCE.sendToServer(new TaskPacket.Action(this.paused ? 0 : 1, this.taskId));
        }

        @Override
        public void setupInteractables(float x, float y, float width, float scale, float posScale) {
            this.remove.m_252865_((int)(x * posScale));
            this.remove.m_253211_((int)(y * posScale));
            this.stop.m_252865_((int)(x * posScale) + (int)(25.0f * posScale));
            this.stop.m_253211_((int)(y * posScale));
            this.pause.m_252865_((int)(x * posScale) + (int)(50.0f * posScale));
            this.pause.m_253211_((int)(y * posScale));
        }
    }
}

