/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import pregenerator.PregenConfig;
import pregenerator.base.api.TextUtil;
import pregenerator.client.ProcessorRenderer;
import pregenerator.client.gui.PregenMenu;
import pregenerator.client.helpers.AddTabEvent;

public class ClientHandler {
    public static final ClientHandler INSTANCE = new ClientHandler();
    public ProcessorRenderer processor = new ProcessorRenderer();
    @OnlyIn(value=Dist.CLIENT)
    KeyMapping uiKey;

    public void onInfoPacketReceived(byte[] data) {
        this.processor.onInfoPacketReceived(data);
    }

    public void addFunctions(IEventBus bus) {
        bus.addListener(this::registerKeys);
        bus.addListener(this::registerOverlay);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerKeys(RegisterKeyMappingsEvent event) {
        this.uiKey = new KeyMapping("Options Gui", 73, "Chunk-Pregenerator");
        event.register(this.uiKey);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onDecorationAdded(AddTabEvent event) {
        if (ModList.get().isLoaded("pregen_expansion") || !PregenConfig.INSTANCE.previewInfo.get()) {
            return;
        }
        event.getHelper().m_264139_((LayoutElement)new ExtendedButton(0, 0, 210, 18, (Component)TextUtil.translateStyled("gui.chunk_pregen.button.preview", ChatFormatting.GOLD), T -> this.openPreview(Minecraft.m_91087_().f_91080_)));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openPreview(Screen parent) {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91152_((Screen)new ConfirmScreen(T -> {
            PregenConfig.INSTANCE.previewInfo.set((Object)false);
            PregenConfig.INSTANCE.save();
            if (T) {
                String s = "https://github.com/TinyModularThings/Chunk-Pregenerator-Issue-Tracker";
                mc.m_91152_((Screen)new ConfirmLinkScreen(open -> {
                    if (open) {
                        Util.m_137581_().m_137646_(s);
                    }
                    mc.m_91152_(parent);
                }, s, true));
                return;
            }
            mc.m_91152_(parent);
        }, (Component)TextUtil.translate("gui.chunk_pregen.missing_screen.header"), (Component)TextUtil.translateStyled("gui.chunk_pregen.missing_screen.body", ChatFormatting.GRAY), (Component)TextUtil.translate("gui.chunk_pregen.missing_screen.wiki"), (Component)TextUtil.translate("gui.chunk_pregen.missing_screen.back")));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onKeyPressed(InputEvent.Key event) {
        Minecraft mc = Minecraft.m_91087_();
        if (this.uiKey.m_90857_() && mc.f_91080_ == null) {
            mc.m_91152_(PregenMenu.MENU.get());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerOverlay(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("pregen_overlays", (gui, graphics, partialTick, screenWidth, screenHeight) -> {
            this.processor.onUIRenderer(graphics);
            GlStateManager._enableDepthTest();
        });
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onInput(InputEvent.MouseButton.Pre event) {
        int mouseY;
        int mouseX;
        Minecraft mc = Minecraft.m_91087_();
        if (event.getButton() == 0 && event.getAction() == 1 && mc.f_91080_ instanceof ChatScreen && this.processor.onClick(mouseX = (int)(mc.f_91067_.m_91589_() * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85443_()), mouseY = (int)(mc.f_91067_.m_91594_() * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85444_()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onUIUpdate(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START || Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        this.processor.update();
    }
}

