/*
 * Decompiled with CFR 0.152.
 */
package net.adeptstack.registry;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.decoration.palettes.GlassPaneBlock;
import com.simibubi.create.content.decoration.slidingDoor.SlidingDoorBlock;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import net.adeptstack.Main;
import net.adeptstack.behaviour.doorBlock.DoorBlockMovementBehaviour;
import net.adeptstack.behaviour.doorBlock.DoorBlockMovingInteraction;
import net.adeptstack.behaviour.slidingDoor.TrainSlidingDoorMovementBehaviour;
import net.adeptstack.behaviour.slidingDoor.TrainSlidingDoorMovingInteraction;
import net.adeptstack.blocks.LineBlock;
import net.adeptstack.blocks.doors.slidingDoor.TrainSlidingDoorBlock;
import net.adeptstack.blocks.panelBlocks.IsoWallBlock;
import net.adeptstack.blocks.panelBlocks.platformBlocks.PlatformBlockCH;
import net.adeptstack.blocks.panelBlocks.platformBlocks.PlatformBlockDE;
import net.adeptstack.blocks.panelBlocks.platformBlocks.PlatformBlockNL;
import net.adeptstack.registry.ModSounds;
import net.adeptstack.registry.ModTabs;
import net.adeptstack.registry.ModTags;
import net.adeptstack.utils.TrainSlidingDoorProperties;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.material.MapColor;

public class TrainUtilitiesBuilderTransformers {
    public static BlockEntry<PlatformBlockDE> DEPlatformBlock(String id, MapColor color) {
        return ((BlockBuilder)((BlockBuilder)Main.REGISTRATE.block(id, PlatformBlockDE::new).initialProperties(() -> Blocks.f_50183_).properties(p -> p.m_284180_(color).m_60918_(SoundType.f_56743_)).transform(TagGen.pickaxeOnly())).tag(new TagKey[]{ModTags.AllBlockTags.PLATFORM_BLOCKS.tag}).loot((lr, block) -> lr.m_247577_((Block)block, lr.m_247033_((ItemLike)block))).item().tag(new TagKey[]{ModTags.AllItemTags.PLATFORM_BLOCKS.tag}).tab(ModTabs.TRAINUTILS_TAB.getKey()).build()).register();
    }

    public static BlockEntry<PlatformBlockNL> NLPlatformBlock(String id, MapColor color) {
        return ((BlockBuilder)((BlockBuilder)Main.REGISTRATE.block(id, PlatformBlockNL::new).initialProperties(() -> Blocks.f_50183_).properties(p -> p.m_284180_(color).m_60918_(SoundType.f_56743_)).transform(TagGen.pickaxeOnly())).tag(new TagKey[]{ModTags.AllBlockTags.PLATFORM_BLOCKS.tag}).loot((lr, block) -> lr.m_247577_((Block)block, lr.m_247033_((ItemLike)block))).item().tag(new TagKey[]{ModTags.AllItemTags.PLATFORM_BLOCKS.tag}).tab(ModTabs.TRAINUTILS_TAB.getKey()).build()).register();
    }

    public static BlockEntry<PlatformBlockCH> CHPlatformBlock(String id, MapColor color) {
        return ((BlockBuilder)((BlockBuilder)Main.REGISTRATE.block(id, PlatformBlockCH::new).initialProperties(() -> Blocks.f_50183_).properties(p -> p.m_284180_(color).m_60918_(SoundType.f_56743_)).transform(TagGen.pickaxeOnly())).tag(new TagKey[]{ModTags.AllBlockTags.PLATFORM_BLOCKS.tag}).loot((lr, block) -> lr.m_247577_((Block)block, lr.m_247033_((ItemLike)block))).item().tag(new TagKey[]{ModTags.AllItemTags.PLATFORM_BLOCKS.tag}).tab(ModTabs.TRAINUTILS_TAB.getKey()).build()).register();
    }

    public static BlockEntry<GlassBlock> GlassBlock(String id, MapColor color) {
        return ((BlockBuilder)((BlockBuilder)Main.REGISTRATE.block(id, GlassBlock::new).initialProperties(() -> Blocks.f_50058_).properties(p -> p.m_60918_(SoundType.f_56744_).m_284180_(color).m_60955_().m_60971_((s, w, b) -> false)).transform(TagGen.pickaxeOnly())).tag(new TagKey[]{ModTags.AllBlockTags.FRAMEABLE.tag}).loot((lr, block) -> lr.m_247577_((Block)block, lr.m_247033_((ItemLike)block))).item().tab(ModTabs.TRAINUTILS_TAB.getKey()).build()).register();
    }

    public static BlockEntry<GlassPaneBlock> GlassPaneBlock(String id, MapColor color) {
        return ((BlockBuilder)((BlockBuilder)Main.REGISTRATE.block(id, GlassPaneBlock::new).initialProperties(() -> Blocks.f_50185_).properties(p -> p.m_60918_(SoundType.f_56744_).m_284180_(color)).addLayer(() -> RenderType::m_110466_).transform(TagGen.pickaxeOnly())).tag(new TagKey[]{ModTags.AllBlockTags.FRAMEABLE.tag}).loot((lr, block) -> lr.m_247577_((Block)block, lr.m_247033_((ItemLike)block))).item().tab(ModTabs.TRAINUTILS_TAB.getKey()).build()).register();
    }

    public static BlockEntry<Block> DefaultBlock(String id, MapColor color) {
        return ((BlockBuilder)((BlockBuilder)Main.REGISTRATE.block(id, Block::new).initialProperties(() -> Blocks.f_50058_).properties(p -> p.m_60918_(SoundType.f_56742_).m_284180_(color)).transform(TagGen.pickaxeOnly())).tag(new TagKey[]{ModTags.AllBlockTags.FRAMEABLE.tag}).loot((lr, block) -> lr.m_247577_(block, lr.m_247033_((ItemLike)block))).item().tab(ModTabs.TRAINUTILS_TAB.getKey()).build()).register();
    }

    public static BlockEntry<IsoWallBlock> IsoWallBlock(String id, MapColor color) {
        return ((BlockBuilder)((BlockBuilder)Main.REGISTRATE.block(id, IsoWallBlock::new).initialProperties(() -> Blocks.f_50183_).properties(p -> p.m_284180_(MapColor.f_283930_).m_60918_(SoundType.f_56743_)).transform(TagGen.pickaxeOnly())).loot((lr, block) -> lr.m_247577_((Block)block, lr.m_247033_((ItemLike)block))).item().tab(ModTabs.TRAINUTILS_TAB.getKey()).build()).register();
    }

    public static BlockEntry<LineBlock> LineBlock(String id, MapColor color) {
        return ((BlockBuilder)((BlockBuilder)Main.REGISTRATE.block(id, LineBlock::new).initialProperties(() -> Blocks.f_50542_).properties(p -> p.m_284180_(color)).transform(TagGen.pickaxeOnly())).tag(new TagKey[]{ModTags.AllBlockTags.FRAMEABLE.tag}).tag(new TagKey[]{ModTags.AllBlockTags.LINE_BLOCKS.tag}).loot((lr, block) -> lr.m_247577_((Block)block, lr.m_247033_((ItemLike)block))).item().tag(new TagKey[]{ModTags.AllItemTags.LINE_BLOCKS.tag}).tab(ModTabs.TRAINUTILS_TAB.getKey()).build()).register();
    }

    public static <B extends DoorBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> defaultDoor(String type) {
        return b -> (BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)b.initialProperties(() -> Blocks.f_50154_).properties(p -> p.m_60913_(3.0f, 6.0f)).addLayer(() -> RenderType::m_110463_).transform(TagGen.pickaxeOnly())).onRegister(MovingInteractionBehaviour.interactionBehaviour((MovingInteractionBehaviour)new DoorBlockMovingInteraction()))).onRegister(MovementBehaviour.movementBehaviour((MovementBehaviour)new DoorBlockMovementBehaviour()))).tag(new TagKey[]{BlockTags.f_13103_}).tag(new TagKey[]{ModTags.AllBlockTags.DOORS.tag}).tag(new TagKey[]{AllTags.AllBlockTags.NON_DOUBLE_DOOR.tag}).loot((lr, block) -> lr.m_247577_((Block)block, lr.m_247398_((Block)block))).item().tag(new TagKey[]{ItemTags.f_13179_}).tag(new TagKey[]{ModTags.AllItemTags.DOORS.tag}).tag(new TagKey[]{AllTags.AllItemTags.CONTRAPTION_CONTROLLED.tag}).tab(ModTabs.DOORS_TAB.getKey()).build();
    }

    public static BlockEntry<DoorBlock> DefaultMinecraftDoor(String type, MapColor colour) {
        return ((BlockBuilder)Main.REGISTRATE.block("door_" + type, p -> new DoorBlock(p, BlockSetType.f_271100_)).initialProperties((NonNullSupplier)AllBlocks.FRAMED_GLASS_DOOR).properties(p -> p.m_60918_(SoundType.f_56743_).m_284180_(colour)).transform(TrainUtilitiesBuilderTransformers.defaultDoor(type))).properties(BlockBehaviour.Properties::m_60955_).register();
    }

    public static <B extends TrainSlidingDoorBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> slidingDoor(String type) {
        return b -> (BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)b.initialProperties(() -> Blocks.f_50154_).properties(p -> p.m_60913_(3.0f, 6.0f)).transform(TagGen.pickaxeOnly())).onRegister(MovingInteractionBehaviour.interactionBehaviour((MovingInteractionBehaviour)new TrainSlidingDoorMovingInteraction()))).onRegister(MovementBehaviour.movementBehaviour((MovementBehaviour)new TrainSlidingDoorMovementBehaviour(type)))).tag(new TagKey[]{BlockTags.f_13103_}).tag(new TagKey[]{ModTags.AllBlockTags.DOORS.tag}).tag(new TagKey[]{AllTags.AllBlockTags.NON_DOUBLE_DOOR.tag}).loot((lr, block) -> lr.m_247577_((Block)block, lr.m_247398_((Block)block))).item().tag(new TagKey[]{ItemTags.f_13179_}).tag(new TagKey[]{ModTags.AllItemTags.DOORS.tag}).tag(new TagKey[]{AllTags.AllItemTags.CONTRAPTION_CONTROLLED.tag}).tab(ModTabs.DOORS_TAB.getKey()).build();
    }

    public static BlockEntry<TrainSlidingDoorBlock> TrainSlidingDoor(String type, boolean folds, MapColor colour) {
        return ((BlockBuilder)Main.REGISTRATE.block("door_" + type, p -> new TrainSlidingDoorBlock((BlockBehaviour.Properties)p, (BlockSetType)SlidingDoorBlock.GLASS_SET_TYPE.get(), folds, TrainUtilitiesBuilderTransformers.GetSlidingDoorDefaultSound(type))).initialProperties((NonNullSupplier)AllBlocks.FRAMED_GLASS_DOOR).properties(p -> p.m_60918_(SoundType.f_56743_).m_284180_(colour)).addLayer(() -> RenderType::m_110466_).transform(TrainUtilitiesBuilderTransformers.slidingDoor(type))).properties(BlockBehaviour.Properties::m_60955_).register();
    }

    public static BlockEntry<TrainSlidingDoorBlock> TintedTrainSlidingDoor(String type, boolean folds, MapColor colour) {
        return ((BlockBuilder)Main.REGISTRATE.block("door_" + type, p -> new TrainSlidingDoorBlock((BlockBehaviour.Properties)p, (BlockSetType)SlidingDoorBlock.GLASS_SET_TYPE.get(), folds, TrainUtilitiesBuilderTransformers.GetSlidingDoorDefaultSound(type))).initialProperties((NonNullSupplier)AllBlocks.FRAMED_GLASS_DOOR).properties(p -> p.m_60918_(SoundType.f_56743_).m_284180_(colour)).addLayer(() -> RenderType::m_110466_).transform(TrainUtilitiesBuilderTransformers.slidingDoor(type))).properties(BlockBehaviour.Properties::m_60955_).register();
    }

    public static TrainSlidingDoorProperties GetSlidingDoorProperties(int variant) {
        if (variant == 2) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_ICE_OPEN.get(), (SoundEvent)ModSounds.DOOR_ICE_CLOSE.get(), 0.025f);
        }
        if (variant == 3) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_IC2_OPEN.get(), (SoundEvent)ModSounds.DOOR_IC2_CLOSE.get(), 0.025f);
        }
        if (variant == 4) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_RRX_OPEN.get(), (SoundEvent)ModSounds.DOOR_RRX_CLOSE.get(), 0.025f);
        }
        if (variant == 5) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_FLIRT_OPEN.get(), (SoundEvent)ModSounds.DOOR_FLIRT_CLOSE.get(), 0.025f);
        }
        if (variant == 6) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_SW_NYC_OPEN.get(), (SoundEvent)ModSounds.DOOR_SW_NYC_CLOSE.get(), 0.025f);
        }
        if (variant == 7) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_PKP_IC_OPEN.get(), (SoundEvent)ModSounds.DOOR_PKP_IC_CLOSE.get(), 0.025f);
        }
        if (variant == 8) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_IC_OPEN.get(), (SoundEvent)ModSounds.DOOR_IC_CLOSE.get(), 0.025f);
        }
        if (variant == 9) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_ELEV_OPEN.get(), (SoundEvent)ModSounds.DOOR_ELEV_CLOSE.get(), 0.045f);
        }
        if (variant == 10) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_LONDON_1973_STOCK_OPEN.get(), (SoundEvent)ModSounds.DOOR_LONDON_1973_STOCK_CLOSE.get(), 0.025f);
        }
        if (variant == 11) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_LONDON_S7_STOCK_OPEN.get(), (SoundEvent)ModSounds.DOOR_LONDON_S7_STOCK_CLOSE.get(), 0.025f);
        }
        if (variant == 12) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_LONDON_OVERGROUND_OPEN.get(), (SoundEvent)ModSounds.DOOR_LONDON_OVERGROUND_CLOSE.get(), 0.025f);
        }
        if (variant == 13) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_RAILJET_OPEN.get(), (SoundEvent)ModSounds.DOOR_RAILJET_CLOSE.get(), 0.025f);
        }
        if (variant == 14) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_SBAHN_OPEN.get(), (SoundEvent)ModSounds.DOOR_SBAHN_CLOSE.get(), 0.025f);
        }
        if (variant == 15) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_TALENT_OPEN.get(), (SoundEvent)ModSounds.DOOR_TALENT_CLOSE.get(), 0.025f);
        }
        if (variant == 16) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_CAF_URBOS_3_OPEN.get(), (SoundEvent)ModSounds.DOOR_CAF_URBOS_3_CLOSE.get(), 0.025f);
        }
        if (variant == 17) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_SUBWAY_OPEN.get(), (SoundEvent)ModSounds.DOOR_SUBWAY_CLOSE.get(), 0.035f);
        }
        if (variant == 18) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_ICE_MODERN_OPEN.get(), (SoundEvent)ModSounds.DOOR_ICE_MODERN_CLOSE.get(), 0.025f);
        }
        if (variant == 19) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_CLASS_350_OPEN.get(), (SoundEvent)ModSounds.DOOR_CLASS_350_CLOSE.get(), 0.025f);
        }
        if (variant == 20) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_CLASS_390_OPEN.get(), (SoundEvent)ModSounds.DOOR_CLASS_390_CLOSE.get(), 0.025f);
        }
        if (variant == 21) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_CLASS_450_OPEN.get(), (SoundEvent)ModSounds.DOOR_CLASS_450_CLOSE.get(), 0.025f);
        }
        if (variant == 22) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_1996_STOCK_OPEN.get(), (SoundEvent)ModSounds.DOOR_1996_STOCK_CLOSE.get(), 0.025f);
        }
        return new TrainSlidingDoorProperties(SoundEvents.f_12056_, SoundEvents.f_12055_, 0.15f);
    }

    public static int GetSlidingDoorDefaultSound(String type) {
        if (type == "ice" || type == "ice_top") {
            return 2;
        }
        if (type == "ic2") {
            return 3;
        }
        if (type == "rrx" || type == "goahead_desiro") {
            return 4;
        }
        if (type == "flirt" || type == "flirt_vias" || type == "ungarian_flirt") {
            return 5;
        }
        if (type == "sw_nyc") {
            return 6;
        }
        if (type == "pkp_ic_white" || type == "pkp_ic_blue") {
            return 7;
        }
        if (type == "ic") {
            return 8;
        }
        if (type == "elev_glass" || type == "elev_metal") {
            return 9;
        }
        if (type == "london_1973_stock") {
            return 10;
        }
        if (type == "london_s7_stock") {
            return 11;
        }
        if (type == "london_overground" || type == "london_el") {
            return 12;
        }
        if (type == "railjet") {
            return 13;
        }
        if (type == "sbahn_cologne" || type == "sbahn_vrr") {
            return 14;
        }
        if (type == "talent1" || type == "talent2" || type == "talent3") {
            return 15;
        }
        if (type == "caf_urbos_3") {
            return 16;
        }
        if (type == "warsaw_tram") {
            return 17;
        }
        if (type == "ice_modern_top" || type == "ice_modern") {
            return 18;
        }
        if (type == "class_350") {
            return 19;
        }
        if (type == "class_390") {
            return 20;
        }
        if (type == "class_450") {
            return 21;
        }
        if (type == "1996_stock") {
            return 22;
        }
        return 0;
    }
}

